/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageData;
import jetbrains.coverage.report.CoverageSourceData;
import jetbrains.coverage.report.ReportBuilderFactory;
import jetbrains.coverage.report.ReportGenerationFailedException;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.html.HTMLReportBuilder;
import jetbrains.coverage.report.impl.FooterInfos;
import jetbrains.coverage.report.impl.IOUtil;
import jetbrains.coverage.report.impl.html.ClassSourceReportGenerator;
import jetbrains.coverage.report.impl.html.ClassesIndexGenerator;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.LocalGeneratorPathsBase;
import jetbrains.coverage.report.impl.html.MapToSet;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.ModulesIndexGenerator;
import jetbrains.coverage.report.impl.html.ModulesLocalPaths;
import jetbrains.coverage.report.impl.html.NamespacesIndexGenerator;
import jetbrains.coverage.report.impl.html.NamespacesLocalPaths;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateFactory;
import jetbrains.coverage.report.impl.html.TemplateProcessorFactory;
import jetbrains.coverage.report.impl.html.fs.FileSystem;
import jetbrains.coverage.report.impl.html.fs.RealFSImpl;
import jetbrains.coverage.report.impl.html.fs.ZipFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLReportBuilderImpl
implements HTMLReportBuilder {
    private File myReportDir;
    private File myReportZip;
    private String myResourceBundleName = "javaCoverage";
    private String myReportTitle = "";
    private String myCharset = Charset.defaultCharset().displayName();
    private static final String CSS_DIR = "css";
    private static final String IMG_DIR = "img";
    private static final String JS_DIR = "js";
    private String myFooterText;
    private String myFooterSourceText;

    public File getReportZip() {
        return this.myReportZip;
    }

    @Override
    public void setReportZip(@NotNull File reportZip) {
        this.myReportZip = reportZip;
        this.setReportDir(this.myReportZip.getParentFile());
    }

    @Override
    public void setReportDir(@NotNull File reportDir) {
        this.myReportDir = reportDir;
    }

    public void setResourceBundleName(@NotNull String resourceBundleName) {
        this.myResourceBundleName = resourceBundleName;
    }

    @Override
    public void setFooterHTML(@NotNull String html2) {
        this.myFooterText = html2;
    }

    @Override
    public void setSourceCodeFooterHTML(@NotNull String html2) {
        this.myFooterSourceText = html2;
    }

    public void setReportTitle(@NotNull String reportTitle) {
        this.myReportTitle = reportTitle;
    }

    public void setCharset(@NotNull String charset) {
        this.myCharset = charset;
    }

    @Override
    public void generateReport(@NotNull CoverageData coverageData) throws ReportGenerationFailedException {
        StatisticsCalculator covStatsCalculator = ReportBuilderFactory.createStatisticsCalculator();
        this.generateReport(coverageData, covStatsCalculator);
    }

    @Override
    public void generateReport(@NotNull CoverageData data, @NotNull StatisticsCalculator calculator) throws ReportGenerationFailedException {
        calculator.compute(data);
        this.doGenerateReport(data, calculator);
    }

    private void doGenerateReport(CoverageData data, StatisticsCalculator covStatsCalculator) {
        FileSystem fs = null;
        try {
            TemplateProcessorFactory fac;
            LocalGeneratorPathsBase paths;
            fs = this.createFS();
            this.createReportDir(fs);
            MapToSet<ModuleInfo, ClassInfo> moduleToClassesMap = this.groupByModules(data.getClasses());
            TemplateFactory templateFactory = new TemplateFactory();
            if (moduleToClassesMap.keySet().size() > 1) {
                paths = new ModulesLocalPaths(this.myReportDir);
                fac = new TemplateProcessorFactory(templateFactory, this.myResourceBundleName, true, this.getFooterInfos(), fs, this.myReportTitle, this.myCharset);
                new ModulesIndexGenerator(fac.createModulesIndexProcessor(), paths).generateModulesIndex(moduleToClassesMap.keySet(), covStatsCalculator);
            } else {
                fac = new TemplateProcessorFactory(templateFactory, this.myResourceBundleName, false, this.getFooterInfos(), fs, this.myReportTitle, this.myCharset);
                paths = new NamespacesLocalPaths(this.myReportDir);
            }
            if (moduleToClassesMap.isEmpty()) {
                fac.createEmptyTemplate().renderTemplate(Collections.<String, Object>emptyMap(), paths.getModulesIndexPath(SortOption.NONE));
            } else {
                for (ModuleInfo info : moduleToClassesMap.keySet()) {
                    this.generateReportForModule(data.getSourceData(), covStatsCalculator, fac, paths, moduleToClassesMap, info);
                }
            }
        }
        catch (IOException e) {
            throw new ReportGenerationFailedException("Failed to generate report", e);
        }
        finally {
            if (fs instanceof Closeable) {
                IOUtil.close((Closeable)((Object)fs));
            }
        }
    }

    private FileSystem createFS() throws IOException {
        if (this.myReportZip != null) {
            return new ZipFileSystem(this.myReportZip);
        }
        if (this.myReportDir != null) {
            return new RealFSImpl();
        }
        throw new IllegalStateException("Report directory must be specified");
    }

    @NotNull
    private FooterInfos getFooterInfos() {
        return new FooterInfos(){

            public String getModulesIndexFooterHTML() {
                return HTMLReportBuilderImpl.this.myFooterText;
            }

            public String getNamespacesIndexFooterHTML() {
                return HTMLReportBuilderImpl.this.myFooterText;
            }

            public String getClassesIndexFooterHTML() {
                return HTMLReportBuilderImpl.this.myFooterText;
            }

            public String getSourceFooterHTML() {
                return HTMLReportBuilderImpl.this.myFooterSourceText == null ? HTMLReportBuilderImpl.this.myFooterText : HTMLReportBuilderImpl.this.myFooterSourceText;
            }
        };
    }

    private void generateReportForModule(@Nullable CoverageSourceData sourceInfo, @NotNull StatisticsCalculator covStatsCalculator, @NotNull TemplateProcessorFactory fac, @NotNull LocalGeneratorPaths paths, @NotNull MapToSet<ModuleInfo, ClassInfo> moduleToClassesMap, @NotNull ModuleInfo info) throws IOException {
        MapToSet<String, ClassInfo> namespaceToClassMap = this.groupByNamespace(moduleToClassesMap.getValues(info));
        new NamespacesIndexGenerator(fac.createNamespacesIndexProcessor(), paths).generateNamespacesIndex(info, namespaceToClassMap.keySet(), covStatsCalculator);
        for (String namespace : namespaceToClassMap.keySet()) {
            Collection<ClassInfo> nClasses = namespaceToClassMap.getValues(namespace);
            new ClassesIndexGenerator(fac.createClassesIndexProcessor(), paths).generateNamespaceIndex(info, namespace, nClasses, covStatsCalculator);
            for (ClassInfo clazz : nClasses) {
                new ClassSourceReportGenerator(fac.createClassSourceProcessor(), paths, sourceInfo).generateClassCoverage(info, namespace, clazz, covStatsCalculator);
            }
        }
    }

    private void createReportDir(@NotNull FileSystem fs) {
        try {
            this.prepareReportDir(fs);
        }
        catch (IOException e) {
            throw new ReportGenerationFailedException("Failed to create report directory", e);
        }
    }

    @Override
    public void generateReport(@NotNull CoverageData before, @NotNull CoverageData after) throws ReportGenerationFailedException {
        StatisticsCalculator covStatsCalculator = ReportBuilderFactory.createStatisticsCalculator();
        covStatsCalculator.compute(before, after);
        this.doGenerateReport(after, covStatsCalculator);
    }

    private void prepareReportDir(@NotNull FileSystem fs) throws IOException {
        File cssDir = new File(this.myReportDir, CSS_DIR);
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/css/coverage.css", fs.openFile(new File(cssDir, "coverage.css")));
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/css/idea.min.css", fs.openFile(new File(cssDir, "idea.min.css")));
        File imgDir = new File(this.myReportDir, IMG_DIR);
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/img/arrowUp.gif", fs.openFile(new File(imgDir, "arrowUp.gif")));
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/img/arrowDown.gif", fs.openFile(new File(imgDir, "arrowDown.gif")));
        File jsDir = new File(this.myReportDir, JS_DIR);
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/js/highlight.min.js", fs.openFile(new File(jsDir, "highlight.min.js")));
        IOUtil.copyResource(this.getClass(), "/htmlTemplates/js/highlightjs-line-numbers.min.js", fs.openFile(new File(jsDir, "highlightjs-line-numbers.min.js")));
    }

    private MapToSet<ModuleInfo, ClassInfo> groupByModules(Collection<ClassInfo> coverageData) {
        MapToSet<ModuleInfo, ClassInfo> set = new MapToSet<ModuleInfo, ClassInfo>();
        for (ClassInfo info : coverageData) {
            set.addValue(ModuleInfo.fromClassInfo(info), info);
        }
        return set;
    }

    private MapToSet<String, ClassInfo> groupByNamespace(Collection<ClassInfo> coverageData) {
        MapToSet<String, ClassInfo> set = new MapToSet<String, ClassInfo>();
        for (ClassInfo cd : coverageData) {
            String ns = cd.getNamespace();
            set.addValue(ns, cd);
        }
        return set;
    }
}

