/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.report.jacoco.analyzable;

import io.github.surpsg.deltacoverage.report.ConsoleHtmlReportLinkRenderer;
import io.github.surpsg.deltacoverage.report.FullReport;
import io.github.surpsg.deltacoverage.report.JacocoReport;
import io.github.surpsg.deltacoverage.report.ReportBound;
import io.github.surpsg.deltacoverage.report.ReportType;
import io.github.surpsg.deltacoverage.report.jacoco.analyzable.AnalyzableReport;
import io.github.surpsg.deltacoverage.report.jacoco.csv.TextualReportOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/github/surpsg/deltacoverage/report/jacoco/analyzable/FullCoverageAnalyzableReport;", "Lio/github/surpsg/deltacoverage/report/jacoco/analyzable/AnalyzableReport;", "report", "Lio/github/surpsg/deltacoverage/report/FullReport;", "(Lio/github/surpsg/deltacoverage/report/FullReport;)V", "reportBound", "Lio/github/surpsg/deltacoverage/report/ReportBound;", "getReportBound", "()Lio/github/surpsg/deltacoverage/report/ReportBound;", "buildAnalyzer", "Lorg/jacoco/core/analysis/Analyzer;", "executionDataStore", "Lorg/jacoco/core/data/ExecutionDataStore;", "coverageVisitor", "Lorg/jacoco/core/analysis/ICoverageVisitor;", "buildHtmReportVisitor", "Lorg/jacoco/report/IReportVisitor;", "reportFile", "Ljava/io/File;", "buildReportVisitor", "jacocoReport", "Lio/github/surpsg/deltacoverage/report/JacocoReport;", "buildVisitor", "createFileOutputStream", "Ljava/io/FileOutputStream;", "delta-coverage-core"})
@SourceDebugExtension(value={"SMAP\nFullCoverageAnalyzableReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullCoverageAnalyzableReport.kt\nio/github/surpsg/deltacoverage/report/jacoco/analyzable/FullCoverageAnalyzableReport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1045#2:84\n1603#2,9:85\n1855#2:94\n1856#2:96\n1612#2:97\n1#3:95\n1#3:98\n*S KotlinDebug\n*F\n+ 1 FullCoverageAnalyzableReport.kt\nio/github/surpsg/deltacoverage/report/jacoco/analyzable/FullCoverageAnalyzableReport\n*L\n27#1:84\n28#1:85,9\n28#1:94\n28#1:96\n28#1:97\n28#1:95\n*E\n"})
public class FullCoverageAnalyzableReport
implements AnalyzableReport {
    @NotNull
    private final FullReport report;
    @NotNull
    private final ReportBound reportBound;

    public FullCoverageAnalyzableReport(@NotNull FullReport report) {
        Intrinsics.checkNotNullParameter(report, "report");
        this.report = report;
        this.reportBound = ReportBound.FULL_REPORT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IReportVisitor buildVisitor() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$sortedBy$iv = this.report.getJacocoReports();
        boolean $i$f$sortedBy = false;
        Iterable $this$mapNotNull$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                JacocoReport it = (JacocoReport)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getReportType().getPriority());
                it = (JacocoReport)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getReportType().getPriority());
            }
        });
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IReportVisitor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JacocoReport it = (JacocoReport)element$iv$iv;
            boolean bl2 = false;
            if (this.buildReportVisitor(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List p0 = (List)destination$iv$iv;
        boolean bl = false;
        return new MultiReportVisitor(p0);
    }

    private final IReportVisitor buildReportVisitor(JacocoReport jacocoReport) {
        IReportVisitor iReportVisitor;
        File reportFile = this.report.resolveReportAbsolutePath(jacocoReport);
        switch (WhenMappings.$EnumSwitchMapping$0[jacocoReport.getReportType().ordinal()]) {
            case 1: {
                FileOutputStream fileOutputStream = this.createFileOutputStream(reportFile);
                XMLFormatter xMLFormatter = new XMLFormatter();
                OutputStream p0 = fileOutputStream;
                boolean bl = false;
                iReportVisitor = xMLFormatter.createVisitor(p0);
                break;
            }
            case 2: {
                FileOutputStream fileOutputStream = this.createFileOutputStream(reportFile);
                CSVFormatter cSVFormatter = new CSVFormatter();
                OutputStream p0 = fileOutputStream;
                boolean bl = false;
                iReportVisitor = cSVFormatter.createVisitor(p0);
                break;
            }
            case 3: {
                iReportVisitor = this.buildHtmReportVisitor(reportFile);
                break;
            }
            case 4: {
                TextualReportOutputStream textualReportOutputStream = new TextualReportOutputStream(jacocoReport.getReportType(), jacocoReport.getReportBound(), this.createFileOutputStream(reportFile));
                CSVFormatter cSVFormatter = new CSVFormatter();
                OutputStream p0 = textualReportOutputStream;
                boolean bl = false;
                iReportVisitor = cSVFormatter.createVisitor(p0);
                break;
            }
            case 5: {
                if (this.getReportBound() == ReportBound.FULL_REPORT) {
                    iReportVisitor = null;
                    break;
                }
                ReportType reportType = jacocoReport.getReportType();
                ReportBound reportBound = jacocoReport.getReportBound();
                PrintStream printStream = System.out;
                Intrinsics.checkNotNullExpressionValue(printStream, "out");
                TextualReportOutputStream textualReportOutputStream = new TextualReportOutputStream(reportType, reportBound, printStream);
                CSVFormatter cSVFormatter = new CSVFormatter();
                OutputStream p0 = textualReportOutputStream;
                boolean bl = false;
                iReportVisitor = cSVFormatter.createVisitor(p0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return iReportVisitor;
    }

    private final IReportVisitor buildHtmReportVisitor(File reportFile) {
        FileMultiReportOutput fileMultiReportOutput = new FileMultiReportOutput(reportFile);
        HTMLFormatter hTMLFormatter = new HTMLFormatter();
        IMultiReportOutput p0 = fileMultiReportOutput;
        boolean bl = false;
        IReportVisitor iReportVisitor = hTMLFormatter.createVisitor(p0);
        Intrinsics.checkNotNullExpressionValue(iReportVisitor, "let(...)");
        IReportVisitor htmlReporter = iReportVisitor;
        return new IReportVisitor(htmlReporter, this, reportFile){
            private final /* synthetic */ IReportVisitor $$delegate_0;
            final /* synthetic */ IReportVisitor $htmlReporter;
            final /* synthetic */ FullCoverageAnalyzableReport this$0;
            final /* synthetic */ File $reportFile;
            {
                this.$htmlReporter = $htmlReporter;
                this.this$0 = $receiver;
                this.$reportFile = $reportFile;
                this.$$delegate_0 = $htmlReporter;
            }

            public void visitBundle(IBundleCoverage p0, ISourceFileLocator p1) {
                this.$$delegate_0.visitBundle(p0, p1);
            }

            public IReportGroupVisitor visitGroup(String p0) {
                return this.$$delegate_0.visitGroup(p0);
            }

            public void visitInfo(List<SessionInfo> p0, Collection<ExecutionData> p1) {
                this.$$delegate_0.visitInfo(p0, p1);
            }

            public void visitEnd() {
                this.$htmlReporter.visitEnd();
                ConsoleHtmlReportLinkRenderer.INSTANCE.render(this.this$0.getReportBound(), this.$reportFile);
            }
        };
    }

    private final FileOutputStream createFileOutputStream(File $this$createFileOutputStream) {
        $this$createFileOutputStream.getParentFile().mkdirs();
        return new FileOutputStream($this$createFileOutputStream);
    }

    @Override
    @NotNull
    public Analyzer buildAnalyzer(@NotNull ExecutionDataStore executionDataStore, @NotNull ICoverageVisitor coverageVisitor) {
        Intrinsics.checkNotNullParameter(executionDataStore, "executionDataStore");
        Intrinsics.checkNotNullParameter(coverageVisitor, "coverageVisitor");
        return new Analyzer(executionDataStore, coverageVisitor);
    }

    @NotNull
    public ReportBound getReportBound() {
        return this.reportBound;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportType.values().length];
            try {
                nArray[ReportType.XML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportType.CSV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportType.HTML.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportType.MARKDOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportType.CONSOLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

