/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.diff.parse;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0002J\b\u0010\f\u001a\u00020\u0003H\u0002J\b\u0010\r\u001a\u00020\u0003H\u0002J\u001a\u0010\u000e\u001a\u00020\u0003*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u0003*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/surpsg/deltacoverage/diff/parse/ClassFile;", "", "sourceFileName", "", "className", "(Ljava/lang/String;Ljava/lang/String;)V", "path", "getPath", "()Ljava/lang/String;", "path$delegate", "Lkotlin/Lazy;", "computePath", "guessPathFromPackage", "sourceFileNameWithSlash", "resolveClassPathByParentOrDefault", "Ljava/nio/file/Path;", "defaultProvider", "Lkotlin/Function0;", "resolveWithNormalize", "fileName", "delta-coverage-core"})
public final class ClassFile {
    @NotNull
    private final String sourceFileName;
    @NotNull
    private final String className;
    @NotNull
    private final Lazy path$delegate;

    public ClassFile(@NotNull String sourceFileName, @NotNull String className) {
        Intrinsics.checkNotNullParameter(sourceFileName, "sourceFileName");
        Intrinsics.checkNotNullParameter(className, "className");
        this.sourceFileName = sourceFileName;
        this.className = className;
        this.path$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ ClassFile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ClassFile.access$computePath(this.this$0);
            }
        });
    }

    @NotNull
    public final String getPath() {
        Lazy lazy = this.path$delegate;
        return (String)lazy.getValue();
    }

    private final String computePath() {
        Path path2 = Paths.get(this.className, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        return this.resolveClassPathByParentOrDefault(path2, new Function0<String>(this){
            final /* synthetic */ ClassFile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ClassFile.access$guessPathFromPackage(this.this$0);
            }
        });
    }

    private final String guessPathFromPackage() {
        String filePathSuffix = StringsKt.replace$default(this.className, ".", "/", false, 4, null);
        Path path2 = Paths.get(filePathSuffix, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        return this.resolveClassPathByParentOrDefault(path2, new Function0<String>(this){
            final /* synthetic */ ClassFile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ClassFile.access$sourceFileNameWithSlash(this.this$0);
            }
        });
    }

    private final String sourceFileNameWithSlash() {
        return '/' + this.sourceFileName;
    }

    private final String resolveClassPathByParentOrDefault(Path $this$resolveClassPathByParentOrDefault, Function0<String> defaultProvider) {
        String string;
        if ($this$resolveClassPathByParentOrDefault.getParent() != null) {
            Path path2 = $this$resolveClassPathByParentOrDefault.getParent();
            Intrinsics.checkNotNullExpressionValue(path2, "getParent(...)");
            string = this.resolveWithNormalize(path2, this.sourceFileName);
        } else {
            string = defaultProvider.invoke();
        }
        return string;
    }

    private final String resolveWithNormalize(Path $this$resolveWithNormalize, String fileName) {
        return StringsKt.replace$default(((Object)$this$resolveWithNormalize.resolve(fileName)).toString(), "\\", "/", false, 4, null);
    }

    public static final /* synthetic */ String access$guessPathFromPackage(ClassFile $this) {
        return $this.guessPathFromPackage();
    }

    public static final /* synthetic */ String access$sourceFileNameWithSlash(ClassFile $this) {
        return $this.sourceFileNameWithSlash();
    }

    public static final /* synthetic */ String access$computePath(ClassFile $this) {
        return $this.computePath();
    }
}

