/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.diff.git;

import io.github.surpsg.deltacoverage.diff.git.CrlfStrategyKt;
import io.github.surpsg.deltacoverage.diff.git.JgitDiff;
import io.github.surpsg.deltacoverage.diff.git.UnknownRevisionException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/surpsg/deltacoverage/diff/git/JgitDiff;", "", "workingDir", "Ljava/io/File;", "(Ljava/io/File;)V", "repository", "Lorg/eclipse/jgit/lib/Repository;", "branches", "", "buildUnknownRevisionException", "Lio/github/surpsg/deltacoverage/diff/git/UnknownRevisionException;", "name", "initRepository", "obtain", "revision", "obtainDiffEntries", "", "Lorg/eclipse/jgit/diff/DiffEntry;", "git", "Lorg/eclipse/jgit/api/Git;", "target", "initialize", "", "Lorg/eclipse/jgit/diff/DiffFormatter;", "delta-coverage-core"})
@SourceDebugExtension(value={"SMAP\nJgitDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JgitDiff.kt\nio/github/surpsg/deltacoverage/diff/git/JgitDiff\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1855#2,2:119\n*S KotlinDebug\n*F\n+ 1 JgitDiff.kt\nio/github/surpsg/deltacoverage/diff/git/JgitDiff\n*L\n46#1:119,2\n*E\n"})
public final class JgitDiff {
    @NotNull
    private final Repository repository;

    public JgitDiff(@NotNull File workingDir) {
        Intrinsics.checkNotNullParameter(workingDir, "workingDir");
        this.repository = this.initRepository(workingDir);
    }

    private final Repository initRepository(File workingDir) {
        Repository repository;
        try {
            FileRepositoryBuilder fileRepositoryBuilder;
            FileRepositoryBuilder $this$initRepository_u24lambda_u240 = fileRepositoryBuilder = new FileRepositoryBuilder();
            boolean bl = false;
            $this$initRepository_u24lambda_u240.findGitDir(workingDir);
            $this$initRepository_u24lambda_u240.readEnvironment();
            $this$initRepository_u24lambda_u240.setMustExist(true);
            repository = fileRepositoryBuilder.build();
            Intrinsics.checkNotNull(repository);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Git directory not found in the project root " + workingDir.getAbsolutePath(), e);
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String obtain(@NotNull String revision) {
        Intrinsics.checkNotNullParameter(revision, "revision");
        ByteArrayOutputStream diffContent2 = new ByteArrayOutputStream();
        Object object = new Git(this.repository);
        Throwable throwable = null;
        try {
            DiffFormatter diffFormatter;
            Git git = (Git)object;
            boolean bl = false;
            DiffFormatter $this$obtain_u24lambda_u243_u24lambda_u242 = diffFormatter = new DiffFormatter(diffContent2);
            boolean bl2 = false;
            this.initialize($this$obtain_u24lambda_u243_u24lambda_u242);
            $this$obtain_u24lambda_u243_u24lambda_u242.setDiffComparator(RawTextComparator.WS_IGNORE_ALL);
            Iterable $this$forEach$iv = this.obtainDiffEntries(git, revision);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DiffEntry it = (DiffEntry)element$iv;
                boolean bl3 = false;
                $this$obtain_u24lambda_u243_u24lambda_u242.format(it);
            }
            $this$obtain_u24lambda_u243_u24lambda_u242.close();
            DiffFormatter diffFormatter2 = diffFormatter;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
        }
        byte[] byArray = diffContent2.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        object = byArray;
        return new String((byte[])object, Charsets.UTF_8);
    }

    private final void initialize(DiffFormatter $this$initialize) {
        $this$initialize.setRepository(this.repository);
        this.repository.getConfig().setEnum("core", null, "autocrlf", (Enum)CrlfStrategyKt.getCrlf$default(null, 1, null));
        $this$initialize.setQuotePaths(false);
        $this$initialize.setPathFilter(TreeFilter.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<DiffEntry> obtainDiffEntries(Git git, String target) {
        AutoCloseable autoCloseable = this.repository.newObjectReader();
        Throwable throwable = null;
        try {
            Object object;
            ObjectReader reader = (ObjectReader)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = new RevWalk(this.repository);
            Throwable throwable2 = null;
            try {
                CanonicalTreeParser canonicalTreeParser;
                CanonicalTreeParser canonicalTreeParser2;
                ObjectId objectId;
                RevWalk revWalk = (RevWalk)autoCloseable2;
                boolean bl2 = false;
                revWalk.setRevFilter(RevFilter.MERGE_BASE);
                ObjectId objectId2 = objectId = this.repository.resolve(target);
                if (objectId2 == null) {
                    throw this.buildUnknownRevisionException(target);
                }
                Intrinsics.checkNotNull(objectId2);
                ObjectId targetId = objectId;
                revWalk.markStart(revWalk.parseCommit(targetId));
                RevCommit revCommit = revWalk.parseCommit(this.repository.resolve("HEAD"));
                Intrinsics.checkNotNullExpressionValue(revCommit, "parseCommit(...)");
                RevCommit currentHeadCommit = revCommit;
                revWalk.markStart(currentHeadCommit);
                CanonicalTreeParser $this$obtainDiffEntries_u24lambda_u247_u24lambda_u246_u24lambda_u244 = canonicalTreeParser2 = new CanonicalTreeParser();
                boolean bl3 = false;
                RevCommit revCommit2 = revWalk.parseCommit(revWalk.next());
                Intrinsics.checkNotNullExpressionValue(revCommit2, "parseCommit(...)");
                RevCommit base = revCommit2;
                $this$obtainDiffEntries_u24lambda_u247_u24lambda_u246_u24lambda_u244.reset(reader, base.getTree());
                AbstractTreeIterator targetRevisionTreeParser = canonicalTreeParser2;
                CanonicalTreeParser $this$obtainDiffEntries_u24lambda_u247_u24lambda_u246_u24lambda_u245 = canonicalTreeParser = new CanonicalTreeParser();
                boolean bl4 = false;
                $this$obtainDiffEntries_u24lambda_u247_u24lambda_u246_u24lambda_u245.reset(reader, currentHeadCommit.getTree());
                CanonicalTreeParser currentHeadTreeParser = canonicalTreeParser;
                Object object2 = git.diff().setOldTree(targetRevisionTreeParser).setNewTree(currentHeadTreeParser).setCached(true).call();
                Intrinsics.checkNotNullExpressionValue(object2, "call(...)");
                object = object2;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            Object object3 = object;
            return object3;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private final UnknownRevisionException buildUnknownRevisionException(String name) {
        return new UnknownRevisionException(StringsKt.trimIndent("\n            Unknown revision '" + name + "'. Available branches: " + this.branches() + "\n            "));
    }

    private final String branches() {
        Object object = new Git(this.repository).branchList().call();
        Intrinsics.checkNotNullExpressionValue(object, "call(...)");
        return SequencesKt.joinToString$default(SequencesKt.sorted(SequencesKt.map(CollectionsKt.asSequence((Iterable)object), branches.1.INSTANCE)), ", ", null, null, 0, null, null, 62, null);
    }
}

