/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.offline;

import com.intellij.rt.coverage.offline.RawClassData;
import com.intellij.rt.coverage.offline.RawProjectData;
import com.intellij.rt.coverage.util.CommonArrayUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public class RawHitsReport {
    private static final int MAGIC = 284996684;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dump(File file, RawProjectData data) {
        DataOutputStream os = null;
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            os = CoverageIOUtil.openWriteFile(file);
            RawHitsReport.dump(os, data);
        }
        catch (Throwable e) {
            try {
                ErrorReporter.warn("Error during coverage report dump", e);
            }
            catch (Throwable throwable) {
                CoverageIOUtil.close(os);
                throw throwable;
            }
            CoverageIOUtil.close(os);
        }
        CoverageIOUtil.close(os);
    }

    public static void dump(DataOutput out, RawProjectData data) throws IOException {
        CoverageIOUtil.writeINT(out, 284996684);
        CoverageIOUtil.writeUTF(out, "");
        for (RawClassData classData : data.getClasses()) {
            int[] hits = CommonArrayUtil.getIntArray(classData.hits);
            if (hits == null || hits.length == 0) continue;
            CoverageIOUtil.writeUTF(out, classData.name);
            CoverageIOUtil.writeINT(out, hits.length);
            for (int hit : hits) {
                CoverageIOUtil.writeINT(out, hit);
            }
        }
        CoverageIOUtil.writeUTF(out, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawProjectData load(File file) throws IOException {
        RawProjectData projectData = new RawProjectData();
        DataInputStream is = null;
        try {
            String className;
            is = CoverageIOUtil.openReadFile(file);
            int magic = CoverageIOUtil.readINT(is);
            if (magic != 284996684) {
                throw new IOException("This file is not in raw hits report format");
            }
            CoverageIOUtil.readUTFFast(is);
            while (!"".equals(className = CoverageIOUtil.readUTFFast(is))) {
                int length = CoverageIOUtil.readINT(is);
                int[] hits = (int[])projectData.getOrCreateClass((String)className, (int)length, (boolean)true).hits;
                for (int i = 0; i < length; ++i) {
                    hits[i] = CoverageIOUtil.readINT(is);
                }
            }
        }
        finally {
            CoverageIOUtil.close(is);
        }
        return projectData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRawHitsFile(File file) throws IOException {
        DataInputStream is = null;
        try {
            is = CoverageIOUtil.openReadFile(file);
            int magic = CoverageIOUtil.readINT(is);
            boolean bl = magic == 284996684;
            return bl;
        }
        finally {
            CoverageIOUtil.close(is);
        }
    }

    public static void dumpOnExit(final File file, final RawProjectData data) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                RawHitsReport.dump(file, data);
            }
        }));
    }
}

