/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classFilter;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import org.jetbrains.coverage.org.objectweb.asm.FieldVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinValueClassFilter
extends ClassFilter {
    private boolean myEqualsVisited;
    private boolean myToStringVisited;
    private boolean myHashCodeVisited;
    private boolean myConstructorVisited;
    private boolean myBoxingVisited;
    private boolean myUnboxingVisited;
    private int myGetterLine = -1;
    private int myConstructorLine = -1;
    private int myFieldsCount = 0;
    private String myFieldType;

    public boolean isApplicable(InstrumentationData context) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        void var1_1;
        void var2_2;
        void var3_3;
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (!KotlinUtils.isKotlinClass(this.myContext)) {
            return mv;
        }
        if ("constructor-impl".equals(name) && (access & 8) != 0) {
            this.myConstructorVisited = true;
            return new MethodVisitor(this, 589824, mv){
                final /* synthetic */ KotlinValueClassFilter this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((int)var2_2, (MethodVisitor)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitCode() {
                    super.visitCode();
                    if (this.this$0.myConstructorLine >= 0) {
                        void var1_1;
                        Label label = new Label();
                        super.visitLabel(label);
                        1 v0 = this;
                        super.visitLineNumber(v0.this$0.myConstructorLine, (Label)var1_1);
                    }
                }
            };
        }
        if ("toString-impl".equals(name) && (access & 8) != 0) {
            this.myToStringVisited = true;
            return mv;
        }
        if ("equals-impl".equals(name) && (access & 8) != 0) {
            this.myEqualsVisited = true;
            return mv;
        }
        if ("hashCode-impl".equals(name) && (access & 8) != 0) {
            this.myHashCodeVisited = true;
            return mv;
        }
        if ("box-impl".equals(name) && (access & 8) != 0 && (access & 0x10) != 0 && (access & 0x1000) != 0) {
            this.myBoxingVisited = true;
            return mv;
        }
        if ("unbox-impl".equals(name) && (access & 0x10) != 0 && (access & 0x1000) != 0) {
            this.myUnboxingVisited = true;
            return mv;
        }
        if (name.startsWith("get") && this.myFieldType != null && ("()" + this.myFieldType).equals(var3_3) && !name.endsWith("-impl")) {
            return new MethodVisitor(this, 589824, mv){
                final /* synthetic */ KotlinValueClassFilter this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((int)var2_2, (MethodVisitor)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitLineNumber(int line2, Label start) {
                    void var2_2;
                    super.visitLineNumber(line2, (Label)var2_2);
                    if (this.this$0.myGetterLine == line2) {
                        return;
                    }
                    if (this.this$0.myGetterLine == -1) {
                        void var1_1;
                        KotlinValueClassFilter.access$102(this.this$0, (int)var1_1);
                        return;
                    }
                    KotlinValueClassFilter.access$102(this.this$0, -2);
                }
            };
        }
        if ("<init>".equals(var2_2) && (access & 0x1000) != 0 && (var1_1 & 2) != 0) {
            return new MethodVisitor(this, 589824, mv){
                final /* synthetic */ KotlinValueClassFilter this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((int)var2_2, (MethodVisitor)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitLineNumber(int line2, Label start) {
                    void var2_2;
                    super.visitLineNumber(line2, (Label)var2_2);
                    if (this.this$0.myConstructorLine == line2) {
                        return;
                    }
                    if (this.this$0.myConstructorLine == -1) {
                        void var1_1;
                        KotlinValueClassFilter.access$002(this.this$0, (int)var1_1);
                        return;
                    }
                    KotlinValueClassFilter.access$002(this.this$0, -2);
                }
            };
        }
        return mv;
    }

    /*
     * WARNING - void declaration
     */
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        ++this.myFieldsCount;
        this.myFieldType = descriptor;
        return super.visitField((int)var1_1, (String)var2_2, (String)var3_3, signature, value);
    }

    public void visitEnd() {
        if (this.myConstructorVisited && this.myEqualsVisited && this.myHashCodeVisited && this.myToStringVisited && this.myBoxingVisited && this.myUnboxingVisited && this.myFieldsCount == 1 && this.myGetterLine >= 0 && this.myGetterLine != this.myConstructorLine) {
            this.myContext.removeLine(this.myGetterLine);
        }
        super.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$102(KotlinValueClassFilter x0, int x1) {
        void var1_1;
        x0.myGetterLine = var1_1;
        return x0.myGetterLine;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$002(KotlinValueClassFilter x0, int x1) {
        void var1_1;
        x0.myConstructorLine = var1_1;
        return x0.myConstructorLine;
    }
}

