/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.data;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import com.intellij.rt.coverage.instrumentation.data.SwitchLabels;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntArrayList;
import org.jetbrains.coverage.gnu.trove.TIntHashSet;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.org.objectweb.asm.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationData {
    private final TIntObjectHashMap<LineData> myLines = new TIntObjectHashMap();
    private final Map<Key<?>, Object> myProperties = new HashMap();
    private final TIntArrayList myInstructions;
    private TIntHashSet myIgnoredLines;
    private int myIgnoreSection = 0;
    private int myNextId = 0;
    private int myMaxSeenLine;
    private boolean myLinesInCurrentMethod;
    private Label myLastFalseJump;
    private Label myLastTrueJump;
    private SwitchLabels myLastSwitchLabels;
    private Map<Label, Jump> myJumps;
    private Map<Label, Switch> mySwitches;

    /*
     * WARNING - void declaration
     */
    public InstrumentationData(ProjectData projectData) {
        void var1_1;
        this.myInstructions = var1_1.isInstructionsCoverageEnabled() ? new TIntArrayList() : null;
    }

    public int getSize() {
        return this.myNextId;
    }

    public void resetMethod() {
        this.myLinesInCurrentMethod = false;
        this.myLastFalseJump = null;
        this.myLastTrueJump = null;
        this.myLastSwitchLabels = null;
        if (this.myJumps != null) {
            this.myJumps.clear();
        }
        if (this.mySwitches != null) {
            this.mySwitches.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Jump getJump(Label jump) {
        void var1_1;
        if (this.myJumps == null) {
            return null;
        }
        return this.myJumps.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Switch getSwitch(Label label) {
        void var1_1;
        if (this.mySwitches == null) {
            return null;
        }
        return this.mySwitches.get(var1_1);
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    public TIntObjectHashMap<LineData> getLines() {
        return this.myLines;
    }

    /*
     * WARNING - void declaration
     */
    public LineData getLineData(int line2) {
        void var1_1;
        return this.myLines.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void createLineData(int line2, String methodNameAndDesc) {
        LineData lineData;
        boolean ignoreSection = this.isIgnoreSection();
        if (ignoreSection && !KotlinUtils.isKotlinClass(this)) {
            return;
        }
        this.myLinesInCurrentMethod = true;
        if (ignoreSection) {
            this.onIgnoredLine(line2);
        }
        if (!ignoreSection && this.myIgnoredLines != null) {
            this.myIgnoredLines.remove(line2);
        }
        if ((lineData = this.myLines.get(line2)) == null) {
            void var2_2;
            lineData = new LineData(line2, (String)var2_2);
            this.myLines.put(line2, lineData);
        }
        if (lineData.getId() == -1) {
            void var3_4;
            var3_4.setId(this.incrementId());
        }
        if (line2 > this.myMaxSeenLine) {
            void var1_1;
            this.myMaxSeenLine = var1_1;
        }
    }

    public boolean hasNoLinesInCurrentMethod() {
        return !this.myLinesInCurrentMethod;
    }

    public int getMaxSeenLine() {
        return this.myMaxSeenLine;
    }

    /*
     * WARNING - void declaration
     */
    public void addJump(LineData lineData, Label trueLabel, Label falseLabel) {
        void var1_1;
        void var2_2;
        void var3_3;
        int index = lineData.jumpsCount();
        int line2 = lineData.getLineNumber();
        Jump trueJump = new Jump(this.incrementId(), index, line2, false);
        Jump falseJump = new Jump(this.incrementId(), index, line2, true);
        this.myLastTrueJump = trueLabel;
        this.myLastFalseJump = falseLabel;
        if (this.myJumps == null) {
            this.myJumps = new HashMap<Label, Jump>();
        }
        this.myJumps.put((Label)var3_3, falseJump);
        this.myJumps.put((Label)var2_2, trueJump);
        JumpData jumpData = lineData.addJump(index);
        jumpData.setId(trueJump.getId(), trueJump.getType());
        var1_1.setId(falseJump.getId(), falseJump.getType());
    }

    /*
     * WARNING - void declaration
     */
    public void addSwitch(LineData lineData, int[] keys2, Label dflt, Label[] labels) {
        void var3_3;
        void var1_1;
        void var2_2;
        int index = lineData.switchesCount();
        List<Switch> switches = this.rememberSwitchLabels(lineData.getLineNumber(), dflt, labels, index);
        SwitchData switchData = lineData.addSwitch(index, (int[])var2_2);
        this.setSwitchIds((SwitchData)var1_1, (List<Switch>)var3_3);
    }

    public boolean isIgnoreSection() {
        return this.myIgnoreSection > 0;
    }

    public void setIgnoreSection(boolean ignore) {
        if (ignore) {
            ++this.myIgnoreSection;
            return;
        }
        --this.myIgnoreSection;
    }

    /*
     * WARNING - void declaration
     */
    public void removeLine(int line2) {
        void var1_1;
        this.myLines.remove(line2);
        this.onIgnoredLine((int)var1_1);
    }

    public TIntHashSet getIgnoredLines() {
        return this.myIgnoredLines;
    }

    /*
     * WARNING - void declaration
     */
    public void removeLastJump() {
        void var1_1;
        if (this.myLastTrueJump == null) {
            return;
        }
        this.myJumps.remove(this.myLastFalseJump);
        Jump trueJump = this.myJumps.remove(this.myLastTrueJump);
        this.myLastTrueJump = null;
        this.myLastFalseJump = null;
        if (trueJump == null) {
            return;
        }
        LineData lineData = this.myLines.get(trueJump.getLine());
        if (lineData == null) {
            return;
        }
        void v0 = var1_1;
        v0.removeJump(v0.jumpsCount() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeLastSwitch() {
        void var1_1;
        if (this.mySwitches == null) {
            return;
        }
        if (this.myLastSwitchLabels == null) {
            return;
        }
        Switch aSwitch = this.mySwitches.remove(this.myLastSwitchLabels.getDefault());
        Label[] labelArray = this.myLastSwitchLabels.getLabels();
        int n = labelArray.length;
        for (int i = 0; i < n; ++i) {
            Label label = labelArray[i];
            this.mySwitches.remove(label);
        }
        this.myLastSwitchLabels = null;
        if (aSwitch == null) {
            return;
        }
        LineData lineData = this.myLines.get(var1_1.getLine());
        if (lineData == null) {
            return;
        }
        labelArray.removeSwitch(labelArray.switchesCount() - 1);
    }

    public TIntArrayList getInstructions() {
        return this.myInstructions;
    }

    /*
     * WARNING - void declaration
     */
    public void addInstructions(int id, int instructions) {
        void var2_2;
        void var1_1;
        TIntArrayList tIntArrayList = this.myInstructions;
        tIntArrayList.set(id, tIntArrayList.get((int)var1_1) + var2_2);
    }

    private int incrementId() {
        if (this.myInstructions != null) {
            while (this.myInstructions.size() <= this.myNextId) {
                this.myInstructions.add(0);
            }
        }
        return this.myNextId++;
    }

    private List<Switch> rememberSwitchLabels(int line2, Label dflt, Label[] labels, int switchIndex) {
        ArrayList<Switch> result = new ArrayList<Switch>();
        if (this.mySwitches == null) {
            this.mySwitches = new HashMap<Label, Switch>();
        }
        this.myLastSwitchLabels = new SwitchLabels(dflt, labels);
        Switch aSwitch = new Switch(this.incrementId(), switchIndex, line2, -1);
        result.add(aSwitch);
        this.mySwitches.put(dflt, aSwitch);
        for (int i = labels.length - 1; i >= 0; --i) {
            aSwitch = new Switch(this.incrementId(), switchIndex, line2, i);
            result.add(aSwitch);
            this.mySwitches.put(labels[i], aSwitch);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void onIgnoredLine(int line2) {
        void var1_1;
        if (this.myIgnoredLines == null) {
            this.myIgnoredLines = new TIntHashSet();
        }
        this.myIgnoredLines.add((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setSwitchIds(SwitchData data, List<Switch> switches) {
        for (Switch aSwitch : switches) {
            void var3_3;
            data.setId(aSwitch.getId(), var3_3.getKey());
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> void put(Key<T> key, T value) {
        void var2_2;
        void var1_1;
        this.myProperties.put((Key<?>)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T get(Key<T> key) {
        void var1_1;
        return (T)this.myProperties.get(var1_1);
    }

    public int getMethodAccess() {
        return this.get(Key.METHOD_ACCESS);
    }

    public String getMethodName() {
        return this.get(Key.METHOD_NAME);
    }

    public String getMethodDesc() {
        return this.get(Key.METHOD_DESC);
    }

    public static void assertIds(ClassData classData) {
        for (LineData lineData : (LineData[])classData.getLines()) {
            SwitchData[] switches;
            if (lineData == null) continue;
            if (lineData.getId() == -1) {
                throw new AssertionError();
            }
            JumpData[] jumps = lineData.getJumps();
            if (jumps != null) {
                for (JumpData jumpData : jumps) {
                    if (jumpData.getId(true) == -1 || jumpData.getId(false) == -1) {
                        throw new AssertionError();
                    }
                }
            }
            if ((switches = lineData.getSwitches()) == null) continue;
            SwitchData[] switchDataArray = switches;
            int n = switches.length;
            for (int i = 0; i < n; ++i) {
                SwitchData switchData = switchDataArray[i];
                for (int i2 = -1; i2 < switchData.getHits().length; ++i2) {
                    if (switchData.getId(i2) == -1) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }
}

