/*
 * Decompiled with CFR 0.152.
 */
package io.github.mayubao.pay_library;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import com.alipay.sdk.app.PayTask;
import io.github.mayubao.pay_library.alipay.PayResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class AliPayReq2 {
    private static final int SDK_PAY_FLAG = 1;
    private static final int SDK_CHECK_FLAG = 2;
    private Activity mActivity;
    private String rawAliPayOrderInfo;
    private String signedAliPayOrderInfo;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PayResult payResult = new PayResult((String)msg.obj);
                    String resultInfo = payResult.getResult();
                    String resultStatus = payResult.getResultStatus();
                    if (TextUtils.equals((CharSequence)resultStatus, (CharSequence)"9000")) {
                        Toast.makeText((Context)AliPayReq2.this.mActivity, (CharSequence)"\u652f\u4ed8\u6210\u529f", (int)0).show();
                        if (AliPayReq2.this.mOnAliPayListener == null) break;
                        AliPayReq2.this.mOnAliPayListener.onPaySuccess(resultInfo);
                        break;
                    }
                    if (TextUtils.equals((CharSequence)resultStatus, (CharSequence)"8000")) {
                        Toast.makeText((Context)AliPayReq2.this.mActivity, (CharSequence)"\u652f\u4ed8\u7ed3\u679c\u786e\u8ba4\u4e2d", (int)0).show();
                        if (AliPayReq2.this.mOnAliPayListener == null) break;
                        AliPayReq2.this.mOnAliPayListener.onPayConfirmimg(resultInfo);
                        break;
                    }
                    Toast.makeText((Context)AliPayReq2.this.mActivity, (CharSequence)"\u652f\u4ed8\u5931\u8d25", (int)0).show();
                    if (AliPayReq2.this.mOnAliPayListener == null) break;
                    AliPayReq2.this.mOnAliPayListener.onPayFailure(resultInfo);
                    break;
                }
                case 2: {
                    Toast.makeText((Context)AliPayReq2.this.mActivity, (CharSequence)("\u68c0\u67e5\u7ed3\u679c\u4e3a\uff1a" + msg.obj), (int)0).show();
                    if (AliPayReq2.this.mOnAliPayListener == null) break;
                    AliPayReq2.this.mOnAliPayListener.onPayCheck(msg.obj.toString());
                    break;
                }
            }
        }
    };
    private OnAliPayListener mOnAliPayListener;

    public void send() {
        String orderInfo = this.rawAliPayOrderInfo;
        String sign = this.signedAliPayOrderInfo;
        try {
            sign = URLEncoder.encode(sign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        final String payInfo = orderInfo + "&sign=\"" + sign + "\"&" + this.getSignType();
        Runnable payRunnable = new Runnable(){

            @Override
            public void run() {
                PayTask alipay = new PayTask(AliPayReq2.this.mActivity);
                String result = alipay.pay(payInfo);
                Message msg = new Message();
                msg.what = 1;
                msg.obj = result;
                AliPayReq2.this.mHandler.sendMessage(msg);
            }
        };
        Thread payThread = new Thread(payRunnable);
        payThread.start();
    }

    public void check() {
        Runnable checkRunnable = new Runnable(){

            @Override
            public void run() {
                PayTask payTask = new PayTask(AliPayReq2.this.mActivity);
                boolean isExist = payTask.checkAccountIfExist();
                Message msg = new Message();
                msg.what = 2;
                msg.obj = isExist;
                AliPayReq2.this.mHandler.sendMessage(msg);
            }
        };
        Thread checkThread = new Thread(checkRunnable);
        checkThread.start();
    }

    public static String getOrderInfo(String partner, String seller, String outTradeNo, String subject, String body, String price, String callbackUrl) {
        String orderInfo = "partner=\"" + partner + "\"";
        orderInfo = orderInfo + "&seller_id=\"" + seller + "\"";
        orderInfo = orderInfo + "&out_trade_no=\"" + outTradeNo + "\"";
        orderInfo = orderInfo + "&subject=\"" + subject + "\"";
        orderInfo = orderInfo + "&body=\"" + body + "\"";
        orderInfo = orderInfo + "&total_fee=\"" + price + "\"";
        orderInfo = orderInfo + "&notify_url=\"" + callbackUrl + "\"";
        orderInfo = orderInfo + "&service=\"mobile.securitypay.pay\"";
        orderInfo = orderInfo + "&payment_type=\"1\"";
        orderInfo = orderInfo + "&_input_charset=\"utf-8\"";
        orderInfo = orderInfo + "&it_b_pay=\"30m\"";
        orderInfo = orderInfo + "&return_url=\"m.alipay.com\"";
        return orderInfo;
    }

    public String getSignType() {
        return "sign_type=\"RSA\"";
    }

    public AliPayReq2 setOnAliPayListener(OnAliPayListener onAliPayListener) {
        this.mOnAliPayListener = onAliPayListener;
        return this;
    }

    public static interface OnAliPayListener {
        public void onPaySuccess(String var1);

        public void onPayFailure(String var1);

        public void onPayConfirmimg(String var1);

        public void onPayCheck(String var1);
    }

    public static class AliOrderInfo {
        String partner;
        String seller;
        String outTradeNo;
        String subject;
        String body;
        String price;
        String callbackUrl;

        public AliOrderInfo setPartner(String partner) {
            this.partner = partner;
            return this;
        }

        public AliOrderInfo setSeller(String seller) {
            this.seller = seller;
            return this;
        }

        public AliOrderInfo setOutTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public AliOrderInfo setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public AliOrderInfo setBody(String body) {
            this.body = body;
            return this;
        }

        public AliOrderInfo setPrice(String price) {
            this.price = price;
            return this;
        }

        public AliOrderInfo setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public String createOrderInfo() {
            return AliPayReq2.getOrderInfo(this.partner, this.seller, this.outTradeNo, this.subject, this.body, this.price, this.callbackUrl);
        }
    }

    public static class Builder {
        private Activity activity;
        private String rawAliPayOrderInfo;
        private String signedAliPayOrderInfo;

        public Builder with(Activity activity) {
            this.activity = activity;
            return this;
        }

        public Builder setRawAliPayOrderInfo(String rawAliPayOrderInfo) {
            this.rawAliPayOrderInfo = rawAliPayOrderInfo;
            return this;
        }

        public Builder setSignedAliPayOrderInfo(String signedAliPayOrderInfo) {
            this.signedAliPayOrderInfo = signedAliPayOrderInfo;
            return this;
        }

        public AliPayReq2 create() {
            AliPayReq2 aliPayReq = new AliPayReq2();
            aliPayReq.mActivity = this.activity;
            aliPayReq.rawAliPayOrderInfo = this.rawAliPayOrderInfo;
            aliPayReq.signedAliPayOrderInfo = this.signedAliPayOrderInfo;
            return aliPayReq;
        }
    }
}

