/*
 * Decompiled with CFR 0.152.
 */
package io.github.mayubao.pay_library;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import com.alipay.sdk.app.PayTask;
import io.github.mayubao.pay_library.AliPayAPI;
import io.github.mayubao.pay_library.alipay.PayResult;
import io.github.mayubao.pay_library.alipay.SignUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class AliPayReq {
    private static final int SDK_PAY_FLAG = 1;
    private static final int SDK_CHECK_FLAG = 2;
    private Activity mActivity;
    private AliPayAPI.Config mConfig;
    private String outTradeNo;
    private String subject;
    private String body;
    private String price;
    private String callbackUrl;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PayResult payResult = new PayResult((String)msg.obj);
                    String resultInfo = payResult.getResult();
                    String resultStatus = payResult.getResultStatus();
                    if (TextUtils.equals((CharSequence)resultStatus, (CharSequence)"9000")) {
                        Toast.makeText((Context)AliPayReq.this.mActivity, (CharSequence)"\u652f\u4ed8\u6210\u529f", (int)0).show();
                        if (AliPayReq.this.mOnAliPayListener == null) break;
                        AliPayReq.this.mOnAliPayListener.onPaySuccess(resultInfo);
                        break;
                    }
                    if (TextUtils.equals((CharSequence)resultStatus, (CharSequence)"8000")) {
                        Toast.makeText((Context)AliPayReq.this.mActivity, (CharSequence)"\u652f\u4ed8\u7ed3\u679c\u786e\u8ba4\u4e2d", (int)0).show();
                        if (AliPayReq.this.mOnAliPayListener == null) break;
                        AliPayReq.this.mOnAliPayListener.onPayConfirmimg(resultInfo);
                        break;
                    }
                    Toast.makeText((Context)AliPayReq.this.mActivity, (CharSequence)"\u652f\u4ed8\u5931\u8d25", (int)0).show();
                    if (AliPayReq.this.mOnAliPayListener == null) break;
                    AliPayReq.this.mOnAliPayListener.onPayFailure(resultInfo);
                    break;
                }
                case 2: {
                    Toast.makeText((Context)AliPayReq.this.mActivity, (CharSequence)("\u68c0\u67e5\u7ed3\u679c\u4e3a\uff1a" + msg.obj), (int)0).show();
                    if (AliPayReq.this.mOnAliPayListener == null) break;
                    AliPayReq.this.mOnAliPayListener.onPayCheck(msg.obj.toString());
                    break;
                }
            }
        }
    };
    private OnAliPayListener mOnAliPayListener;

    public void sendWithConfig(AliPayAPI.Config config) {
        this.mConfig = config;
        this.send();
    }

    public void send() {
        String orderInfo = this.getOrderInfo(this.mConfig.getPartner(), this.mConfig.getSeller(), this.outTradeNo, this.subject, this.body, this.price, this.callbackUrl);
        String sign = this.sign(orderInfo);
        try {
            sign = URLEncoder.encode(sign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        final String payInfo = orderInfo + "&sign=\"" + sign + "\"&" + this.getSignType();
        Runnable payRunnable = new Runnable(){

            @Override
            public void run() {
                PayTask alipay = new PayTask(AliPayReq.this.mActivity);
                String result = alipay.pay(payInfo);
                Message msg = new Message();
                msg.what = 1;
                msg.obj = result;
                AliPayReq.this.mHandler.sendMessage(msg);
            }
        };
        Thread payThread = new Thread(payRunnable);
        payThread.start();
    }

    public void check() {
        Runnable checkRunnable = new Runnable(){

            @Override
            public void run() {
                PayTask payTask = new PayTask(AliPayReq.this.mActivity);
                boolean isExist = payTask.checkAccountIfExist();
                Message msg = new Message();
                msg.what = 2;
                msg.obj = isExist;
                AliPayReq.this.mHandler.sendMessage(msg);
            }
        };
        Thread checkThread = new Thread(checkRunnable);
        checkThread.start();
    }

    public String getOrderInfo(String partner, String seller, String outTradeNo, String subject, String body, String price, String callbackUrl) {
        String orderInfo = "partner=\"" + partner + "\"";
        orderInfo = orderInfo + "&seller_id=\"" + seller + "\"";
        orderInfo = orderInfo + "&out_trade_no=\"" + outTradeNo + "\"";
        orderInfo = orderInfo + "&subject=\"" + subject + "\"";
        orderInfo = orderInfo + "&body=\"" + body + "\"";
        orderInfo = orderInfo + "&total_fee=\"" + price + "\"";
        orderInfo = orderInfo + "&notify_url=\"" + callbackUrl + "\"";
        orderInfo = orderInfo + "&service=\"mobile.securitypay.pay\"";
        orderInfo = orderInfo + "&payment_type=\"1\"";
        orderInfo = orderInfo + "&_input_charset=\"utf-8\"";
        orderInfo = orderInfo + "&it_b_pay=\"30m\"";
        orderInfo = orderInfo + "&return_url=\"m.alipay.com\"";
        return orderInfo;
    }

    public String sign(String content) {
        return SignUtils.sign(content, this.mConfig.getAliRsaPrivate());
    }

    public String getSignType() {
        return "sign_type=\"RSA\"";
    }

    public AliPayReq setOnAliPayListener(OnAliPayListener onAliPayListener) {
        this.mOnAliPayListener = onAliPayListener;
        return this;
    }

    public static interface OnAliPayListener {
        public void onPaySuccess(String var1);

        public void onPayFailure(String var1);

        public void onPayConfirmimg(String var1);

        public void onPayCheck(String var1);
    }

    public static class Builder {
        private Activity activity;
        private AliPayAPI.Config config;
        private String outTradeNo;
        private String subject;
        private String body;
        private String price;
        private String callbackUrl;

        public Builder with(Activity activity) {
            this.activity = activity;
            return this;
        }

        public Builder apply(AliPayAPI.Config config) {
            this.config = config;
            return this;
        }

        public Builder setOutTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setPrice(String price) {
            this.price = price;
            return this;
        }

        public Builder setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public AliPayReq create() {
            AliPayReq aliPayReq = new AliPayReq();
            aliPayReq.mActivity = this.activity;
            aliPayReq.mConfig = this.config;
            aliPayReq.outTradeNo = this.outTradeNo;
            aliPayReq.subject = this.subject;
            aliPayReq.body = this.body;
            aliPayReq.price = this.price;
            aliPayReq.callbackUrl = this.callbackUrl;
            return aliPayReq;
        }
    }
}

