/*
 * Decompiled with CFR 0.152.
 */
package io.github.mayubao.pay_library;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelbase.BaseResp;
import com.tencent.mm.sdk.modelpay.PayReq;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.sdk.openapi.WXAPIFactory;

public class WechatPayReq
implements IWXAPIEventHandler {
    private static final String TAG = WechatPayReq.class.getSimpleName();
    private Activity mActivity;
    private String appId;
    private String partnerId;
    private String prepayId;
    private String packageValue;
    private String nonceStr;
    private String timeStamp;
    private String sign;
    IWXAPI mWXApi;
    private OnWechatPayListener mOnWechatPayListener;

    public void send() {
        this.mWXApi = WXAPIFactory.createWXAPI((Context)this.mActivity, null);
        this.mWXApi.handleIntent(this.mActivity.getIntent(), (IWXAPIEventHandler)this);
        this.mWXApi.registerApp(this.appId);
        PayReq request = new PayReq();
        request.appId = this.appId;
        request.partnerId = this.partnerId;
        request.prepayId = this.prepayId;
        request.packageValue = this.packageValue != null ? this.packageValue : "Sign=WXPay";
        request.nonceStr = this.nonceStr;
        request.timeStamp = this.timeStamp;
        request.sign = this.sign;
        this.mWXApi.sendReq((BaseReq)request);
    }

    public WechatPayReq setOnWechatPayListener(OnWechatPayListener onWechatPayListener) {
        this.mOnWechatPayListener = onWechatPayListener;
        return this;
    }

    public void onReq(BaseReq baseReq) {
        Toast.makeText((Context)this.mActivity, (CharSequence)("onReq===>>>get baseReq.getType : " + baseReq.getType()), (int)1).show();
        Log.d((String)TAG, (String)("onReq===>>>get baseReq.getType : " + baseReq.getType()));
    }

    public void onResp(BaseResp resp) {
        Toast.makeText((Context)this.mActivity, (CharSequence)("onResp===>>>get resp.getType : " + resp.getType()), (int)1).show();
        if (resp.getType() == 5) {
            Log.d((String)TAG, (String)("onPayFinish,errCode=" + resp.errCode));
            if (this.mOnWechatPayListener != null) {
                if (resp.errCode == 0) {
                    this.mOnWechatPayListener.onPaySuccess(resp.errCode);
                } else {
                    this.mOnWechatPayListener.onPayFailure(resp.errCode);
                }
            }
        }
    }

    public static interface OnWechatPayListener {
        public void onPaySuccess(int var1);

        public void onPayFailure(int var1);
    }

    public static class Builder {
        private Activity activity;
        private String appId;
        private String partnerId;
        private String prepayId;
        private String packageValue = "Sign=WXPay";
        private String nonceStr;
        private String timeStamp;
        private String sign;

        public Builder with(Activity activity) {
            this.activity = activity;
            return this;
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder setPartnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public Builder setPrepayId(String prepayId) {
            this.prepayId = prepayId;
            return this;
        }

        public Builder setPackageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public Builder setNonceStr(String nonceStr) {
            this.nonceStr = nonceStr;
            return this;
        }

        public Builder setTimeStamp(String timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public Builder setSign(String sign) {
            this.sign = sign;
            return this;
        }

        public WechatPayReq create() {
            WechatPayReq wechatPayReq = new WechatPayReq();
            wechatPayReq.mActivity = this.activity;
            wechatPayReq.appId = this.appId;
            wechatPayReq.partnerId = this.partnerId;
            wechatPayReq.prepayId = this.prepayId;
            wechatPayReq.packageValue = this.packageValue;
            wechatPayReq.nonceStr = this.nonceStr;
            wechatPayReq.timeStamp = this.timeStamp;
            wechatPayReq.sign = this.sign;
            return wechatPayReq;
        }
    }
}

