/*
 * Decompiled with CFR 0.152.
 */
package com.rits.cloning;

import com.rits.cloning.CloningException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import sun.misc.Unsafe;

class Fields {
    static final Accessor<Object> ACCESSOR = AccessorType.resolve(AccessorType.valueOf(System.getProperty(Fields.class.getName() + ".accessor", AccessorType.AUTO.name()).trim().toUpperCase()));

    private Fields() {
    }

    private static enum AccessorType {
        AUTO,
        UNSAFE,
        HANDLES,
        REFLECTION;


        private static Accessor<Object> resolve(AccessorType type) {
            switch (type.ordinal()) {
                case 0: {
                    try {
                        return UnsafeAccessor.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                case 2: {
                    return VarHandleAccessor.INSTANCE;
                }
                case 3: {
                    return ReflectionAccessor.INSTANCE;
                }
                case 1: {
                    return UnsafeAccessor.INSTANCE;
                }
            }
            throw new IllegalArgumentException("Unknown accessor type: " + String.valueOf((Object)type));
        }
    }

    static interface Accessor<C> {
        public C getCookie(Field var1);

        public Object get(Field var1, C var2, Object var3) throws IllegalAccessException;

        public void set(Field var1, C var2, Object var3, Object var4) throws IllegalAccessException;

        public void copy(Field var1, C var2, Object var3, Object var4) throws IllegalAccessException;
    }

    private static class UnsafeAccessor
    implements Accessor<Long> {
        private static final UnsafeAccessor INSTANCE = new UnsafeAccessor();
        private final Unsafe u = (Unsafe)UnsafeAccessor.findUnsafe();
        private final ClassValue<Map<Field, Long>> offsetByField = new ClassValue<Map<Field, Long>>(){

            @Override
            protected Map<Field, Long> computeValue(Class<?> clz) {
                HashMap<Field, Long> map = new HashMap<Field, Long>();
                for (Field f : clz.getDeclaredFields()) {
                    try {
                        long of = Modifier.isStatic(f.getModifiers()) ? u.staticFieldOffset(f) : u.objectFieldOffset(f);
                        map.put(f, of < 0L ? null : Long.valueOf(of));
                    }
                    catch (UnsupportedOperationException e) {
                        map.put(f, null);
                    }
                }
                return map;
            }
        };
        private final ClassValue<Map<Field, Object>> baseByStaticField = new ClassValue<Map<Field, Object>>(){

            @Override
            protected Map<Field, Object> computeValue(Class<?> clz) {
                HashMap<Field, Object> map = new HashMap<Field, Object>();
                for (Field f : clz.getDeclaredFields()) {
                    if (!Modifier.isStatic(f.getModifiers())) continue;
                    try {
                        map.put(f, u.staticFieldBase(f));
                    }
                    catch (UnsupportedOperationException e) {
                        map.put(f, null);
                    }
                }
                return map;
            }
        };

        private UnsafeAccessor() {
        }

        private static <UNSAFE> UNSAFE findUnsafe() {
            try {
                Field theUnsafe = Class.forName("sun.misc.Unsafe").getDeclaredField("theUnsafe");
                theUnsafe.trySetAccessible();
                return (UNSAFE)theUnsafe.get(null);
            }
            catch (ReflectiveOperationException e) {
                throw new CloningException(e);
            }
        }

        @Override
        public Long getCookie(Field field) {
            return this.offsetByField.get(field.getDeclaringClass()).get(field);
        }

        @Override
        public Object get(Field field, Long of, Object src) {
            Object src2;
            if (of == null && (of = this.getCookie(field)) == null) {
                return VarHandleAccessor.INSTANCE.get(field, VarHandleAccessor.INSTANCE.getCookie(field), src);
            }
            Class<?> t = field.getType();
            int mods = field.getModifiers();
            boolean v = Modifier.isVolatile(mods);
            Object object = src2 = Modifier.isStatic(mods) ? this.baseByStaticField.get(field.getDeclaringClass()).get(field) : src;
            return !t.isPrimitive() ? (v ? this.u.getObjectVolatile(src2, of) : this.u.getObject(src2, of)) : (t == Integer.TYPE ? Integer.valueOf(v ? this.u.getIntVolatile(src2, of) : this.u.getInt(src2, of)) : (t == Long.TYPE ? Long.valueOf(v ? this.u.getLongVolatile(src2, of) : this.u.getLong(src2, of)) : (t == Boolean.TYPE ? Boolean.valueOf(v ? this.u.getBooleanVolatile(src2, of) : this.u.getBoolean(src2, of)) : (t == Double.TYPE ? Double.valueOf(v ? this.u.getDoubleVolatile(src2, of) : this.u.getDouble(src2, of)) : (t == Float.TYPE ? Float.valueOf(v ? this.u.getFloatVolatile(src2, of) : this.u.getFloat(src2, of)) : (t == Character.TYPE ? Character.valueOf(v ? this.u.getCharVolatile(src2, of) : this.u.getChar(src2, of)) : (t == Byte.TYPE ? Byte.valueOf(v ? this.u.getByteVolatile(src2, of) : this.u.getByte(src2, of)) : (t == Short.TYPE ? Short.valueOf(v ? this.u.getShortVolatile(src2, of) : this.u.getShort(src2, of)) : VarHandleAccessor.INSTANCE.get(field, VarHandleAccessor.INSTANCE.getCookie(field), src)))))))));
        }

        @Override
        public void set(Field field, Long of, Object dst, Object value) throws IllegalAccessException {
            if (of == null && (of = this.getCookie(field)) == null) {
                VarHandleAccessor.INSTANCE.set(field, VarHandleAccessor.INSTANCE.getCookie(field), dst, value);
                return;
            }
            Object dst2 = Modifier.isStatic(field.getModifiers()) ? this.baseByStaticField.get(field.getDeclaringClass()).get(field) : dst;
            Class<?> t = field.getType();
            if (!t.isPrimitive()) {
                this.u.putObject(dst2, of, value);
            } else if (t == Integer.TYPE) {
                this.u.putInt(dst2, of, (Integer)value);
            } else if (t == Long.TYPE) {
                this.u.putLong(dst2, of, (Long)value);
            } else if (t == Boolean.TYPE) {
                this.u.putBoolean(dst2, of, (Boolean)value);
            } else if (t == Double.TYPE) {
                this.u.putDouble(dst2, of, (Double)value);
            } else if (t == Float.TYPE) {
                this.u.putFloat(dst2, of, ((Float)value).floatValue());
            } else if (t == Character.TYPE) {
                this.u.putChar(dst2, of, ((Character)value).charValue());
            } else if (t == Byte.TYPE) {
                this.u.putByte(dst2, of, (Byte)value);
            } else if (t == Short.TYPE) {
                this.u.putShort(dst2, of, (Short)value);
            } else {
                VarHandleAccessor.INSTANCE.set(field, VarHandleAccessor.INSTANCE.getCookie(field), dst, value);
            }
        }

        @Override
        public void copy(Field field, Long of, Object src, Object dst) throws IllegalAccessException {
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || of == null && (of = this.getCookie(field)) == null) {
                VarHandleAccessor.INSTANCE.copy(field, VarHandleAccessor.INSTANCE.getCookie(field), src, dst);
                return;
            }
            Class<?> t = field.getType();
            boolean v = Modifier.isVolatile(mods);
            if (!t.isPrimitive()) {
                this.u.putObject(dst, of, v ? this.u.getObjectVolatile(src, of) : this.u.getObject(src, of));
            } else if (t == Integer.TYPE) {
                this.u.putInt(dst, of, v ? this.u.getIntVolatile(src, of) : this.u.getInt(src, of));
            } else if (t == Long.TYPE) {
                this.u.putLong(dst, of, v ? this.u.getLongVolatile(src, of) : this.u.getLong(src, of));
            } else if (t == Boolean.TYPE) {
                this.u.putBoolean(dst, of, v ? this.u.getBooleanVolatile(src, of) : this.u.getBoolean(src, of));
            } else if (t == Double.TYPE) {
                this.u.putDouble(dst, of, v ? this.u.getDoubleVolatile(src, of) : this.u.getDouble(src, of));
            } else if (t == Float.TYPE) {
                this.u.putFloat(dst, of, v ? this.u.getFloatVolatile(src, of) : this.u.getFloat(src, of));
            } else if (t == Character.TYPE) {
                this.u.putChar(dst, of, v ? this.u.getCharVolatile(src, of) : this.u.getChar(src, of));
            } else if (t == Byte.TYPE) {
                this.u.putByte(dst, of, v ? this.u.getByteVolatile(src, of) : this.u.getByte(src, of));
            } else if (t == Short.TYPE) {
                this.u.putShort(dst, of, v ? this.u.getShortVolatile(src, of) : this.u.getShort(src, of));
            } else {
                VarHandleAccessor.INSTANCE.copy(field, VarHandleAccessor.INSTANCE.getCookie(field), src, dst);
            }
        }
    }

    private static class VarHandleAccessor
    implements Accessor<VarHandle> {
        private static final VarHandleAccessor INSTANCE = new VarHandleAccessor();
        private final ClassValue<Map<Field, VarHandle>> handleByField = new ClassValue<Map<Field, VarHandle>>(){
            private final MethodHandles.Lookup lookup = MethodHandles.lookup();

            @Override
            protected Map<Field, VarHandle> computeValue(Class<?> clz) {
                HashMap<Field, VarHandle> map = new HashMap<Field, VarHandle>();
                try {
                    MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(clz, this.lookup);
                    for (Field f : clz.getDeclaredFields()) {
                        f.trySetAccessible();
                        map.put(f, lookup.unreflectVarHandle(f));
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new CloningException(e);
                }
                return map;
            }
        };

        private VarHandleAccessor() {
        }

        @Override
        public VarHandle getCookie(Field field) {
            return this.handleByField.get(field.getDeclaringClass()).get(field);
        }

        @Override
        public Object get(Field field, VarHandle h, Object src) {
            boolean v = Modifier.isVolatile(field.getModifiers());
            return src == null ? (v ? h.getVolatile() : h.get()) : (v ? h.getVolatile(src) : h.get(src));
        }

        @Override
        public void set(Field field, VarHandle h, Object dst, Object value) throws IllegalAccessException {
            if (Modifier.isFinal(field.getModifiers())) {
                ReflectionAccessor.INSTANCE.set(field, ReflectionAccessor.INSTANCE.getCookie(field), dst, value);
            } else if (dst == null) {
                h.set(value);
            } else {
                h.set(dst, value);
            }
        }

        @Override
        public void copy(Field field, VarHandle hand, Object src, Object dst) throws IllegalAccessException {
            int mods = field.getModifiers();
            if (Modifier.isFinal(mods)) {
                ReflectionAccessor.INSTANCE.copy(field, ReflectionAccessor.INSTANCE.getCookie(field), src, dst);
                return;
            }
            Class<?> t = field.getType();
            boolean v = Modifier.isVolatile(mods);
            if (!t.isPrimitive()) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else if (t == Integer.TYPE) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else if (t == Long.TYPE) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else if (t == Boolean.TYPE) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else if (t == Double.TYPE) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else if (t == Float.TYPE) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else if (t == Character.TYPE) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else if (t == Byte.TYPE) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else if (t == Short.TYPE) {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            } else {
                hand.set(dst, v ? hand.getVolatile(src) : hand.get(src));
            }
        }
    }

    private static class ReflectionAccessor
    implements Accessor<Field> {
        private static final ReflectionAccessor INSTANCE = new ReflectionAccessor();

        private ReflectionAccessor() {
        }

        @Override
        public Field getCookie(Field field) {
            field.trySetAccessible();
            return field;
        }

        @Override
        public Object get(Field field, Field cookie, Object src) throws IllegalAccessException {
            return cookie.get(src);
        }

        @Override
        public void set(Field field, Field cookie, Object dst, Object value) throws IllegalAccessException {
            cookie.set(dst, value);
        }

        @Override
        public void copy(Field field, Field cookie, Object src, Object dst) throws IllegalAccessException {
            Class<?> t = field.getType();
            if (!t.isPrimitive()) {
                cookie.set(dst, cookie.get(src));
            } else if (t == Integer.TYPE) {
                cookie.setInt(dst, cookie.getInt(src));
            } else if (t == Long.TYPE) {
                cookie.setLong(dst, cookie.getLong(src));
            } else if (t == Boolean.TYPE) {
                cookie.setBoolean(dst, cookie.getBoolean(src));
            } else if (t == Double.TYPE) {
                cookie.setDouble(dst, cookie.getDouble(src));
            } else if (t == Float.TYPE) {
                cookie.setFloat(dst, cookie.getFloat(src));
            } else if (t == Character.TYPE) {
                cookie.setChar(dst, cookie.getChar(src));
            } else if (t == Byte.TYPE) {
                cookie.setByte(dst, cookie.getByte(src));
            } else if (t == Short.TYPE) {
                cookie.setShort(dst, cookie.getShort(src));
            } else {
                cookie.set(dst, cookie.get(src));
            }
        }
    }
}

