/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata.decorator;

import java.util.Locale;
import org.springframework.data.domain.Page;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.springdata.decorator.PaginationDecorator;
import org.thymeleaf.dialect.springdata.util.Messages;
import org.thymeleaf.dialect.springdata.util.PageUtils;
import org.thymeleaf.dialect.springdata.util.Strings;
import org.thymeleaf.model.IProcessableElementTag;

abstract class AbstractPagerDecorator
implements PaginationDecorator {
    AbstractPagerDecorator() {
    }

    @Override
    public final String decorate(IProcessableElementTag tag, ITemplateContext context) {
        String bundleName = this.getClass().getSimpleName();
        Locale locale = context.getLocale();
        Page<?> page = PageUtils.findPage(context);
        String previousPage = PageUtils.createPageUrl(context, page.getNumber() - 1);
        String prevKey = PageUtils.isFirstPage(page) ? "pager.previous" : "pager.previous.link";
        String prev = Messages.getMessage(bundleName, prevKey, locale, previousPage);
        String nextPage = PageUtils.createPageUrl(context, page.getNumber() + 1);
        String nextKey = page.isLast() ? "pager.next" : "pager.next.link";
        String next = Messages.getMessage(bundleName, nextKey, locale, nextPage);
        String content = Strings.concat(prev, next);
        return Messages.getMessage(bundleName, "pager", locale, content);
    }
}

