/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.ast.visitors;

import io.github.joke.spockmockable.Mockable;
import io.github.joke.spockmockable.ast.ClassCollector;
import io.github.joke.spockmockable.ast.scopes.ClassNodeScope;
import io.github.joke.spockmockable.shadow.javax.inject.Inject;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.SourceUnit;

@ClassNodeScope
public class AnnotationVisitor {
    private static final ClassNode MOCKABLE = ClassHelper.makeWithoutCaching(Mockable.class);
    private final SourceUnit sourceUnit;
    private final ClassCollector classCollector;

    public void visit(AnnotatedNode node) {
        new Visitor().visitAnnotations(node);
    }

    @Inject
    @Generated
    public AnnotationVisitor(SourceUnit sourceUnit, ClassCollector classCollector) {
        this.sourceUnit = sourceUnit;
        this.classCollector = classCollector;
    }

    private class Visitor
    extends ClassCodeVisitorSupport {
        protected void visitAnnotation(AnnotationNode node) {
            if (MOCKABLE.equals((Object)node.getClassNode())) {
                Map members = node.getMembers();
                Optional.ofNullable((Expression)members.get("className")).map(ASTNode::getText).ifPresent(AnnotationVisitor.this.classCollector::addClass);
                Optional.ofNullable((Expression)members.get("packageName")).map(ASTNode::getText).ifPresent(AnnotationVisitor.this.classCollector::addPackage);
            }
        }

        protected SourceUnit getSourceUnit() {
            return AnnotationVisitor.this.sourceUnit;
        }

        @Generated
        public Visitor() {
        }
    }
}

