/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.ast;

import io.github.joke.spockmockable.ast.ClassCollector;
import io.github.joke.spockmockable.shadow.javax.inject.Inject;
import io.github.joke.spockmockable.shadow.javax.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import lombok.Generated;
import org.codehaus.groovy.control.CompilationUnit;

@Singleton
class MetaInfWriter {
    private final ClassCollector classCollector;
    private final CompilationUnit compilationUnit;

    void write() {
        String classes = String.join((CharSequence)",", this.classCollector.getClassNames());
        String packages = String.join((CharSequence)",", this.classCollector.getPackageNames());
        File metaInf = new File(this.compilationUnit.getConfiguration().getTargetDirectory(), "META-INF");
        metaInf.mkdirs();
        File propertyFile = new File(metaInf, "spock-mockable.properties");
        Properties properties = new Properties();
        properties.put("classes", classes);
        properties.put("packages", packages);
        try (FileOutputStream output = new FileOutputStream(propertyFile);){
            properties.store(output, "io.github.joke:spock-mockable");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject
    @Generated
    public MetaInfWriter(ClassCollector classCollector, CompilationUnit compilationUnit) {
        this.classCollector = classCollector;
        this.compilationUnit = compilationUnit;
    }
}

