/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.agent;

import io.github.joke.spockmockable.agent.PropertyReader;
import io.github.joke.spockmockable.shadow.javax.inject.Inject;
import io.github.joke.spockmockable.shadow.javax.inject.Singleton;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReferenceLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReferenceLoader.class);
    private final PropertyReader propertyReader;
    private final AtomicReference<Object> classes = new AtomicReference();
    private final AtomicReference<Object> packages = new AtomicReference();

    boolean hasClasses() {
        return !this.getPackages().isEmpty() || !this.getClasses().isEmpty();
    }

    protected @Unmodifiable SortedSet<String> extractProperty(String propertyName) {
        return Optional.ofNullable(this.propertyReader).map(PropertyReader::getProperties).map(properties -> properties.getProperty(propertyName)).map(string -> string.split(",")).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), Collections::unmodifiableSortedSet));
    }

    @Generated
    public PropertyReader getPropertyReader() {
        return this.propertyReader;
    }

    @Inject
    @Generated
    public ReferenceLoader(PropertyReader propertyReader) {
        this.propertyReader = propertyReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @Generated
    public @Unmodifiable @NotNull SortedSet<String> getClasses() {
        Object value = this.classes.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.classes;
            synchronized (atomicReference) {
                value = this.classes.get();
                if (value == null) {
                    SortedSet<String> actualValue = this.extractProperty("classes");
                    value = actualValue == null ? this.classes : actualValue;
                    this.classes.set(value);
                }
            }
        }
        return (SortedSet)(value == this.classes ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @Generated
    public @Unmodifiable @NotNull SortedSet<String> getPackages() {
        Object value = this.packages.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.packages;
            synchronized (atomicReference) {
                value = this.packages.get();
                if (value == null) {
                    SortedSet<String> actualValue = this.extractProperty("packages");
                    value = actualValue == null ? this.packages : actualValue;
                    this.packages.set(value);
                }
            }
        }
        return (SortedSet)(value == this.packages ? null : value);
    }
}

