/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamsesso.jsonlogic.evaluator.expressions;

import io.github.jamsesso.jsonlogic.JsonLogic;
import io.github.jamsesso.jsonlogic.ast.JsonLogicArray;
import io.github.jamsesso.jsonlogic.ast.JsonLogicNode;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluator;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicExpression;

public class LogicExpression
implements JsonLogicExpression {
    public static final LogicExpression AND = new LogicExpression(true);
    public static final LogicExpression OR = new LogicExpression(false);
    private final boolean isAnd;

    private LogicExpression(boolean isAnd) {
        this.isAnd = isAnd;
    }

    @Override
    public String key() {
        return this.isAnd ? "and" : "or";
    }

    @Override
    public Object evaluate(JsonLogicEvaluator evaluator, JsonLogicArray arguments, Object data, String jsonPath) throws JsonLogicEvaluationException {
        if (arguments.size() < 1) {
            throw new JsonLogicEvaluationException(this.key() + " operator expects at least 1 argument", jsonPath);
        }
        Object result = null;
        int index = 0;
        for (JsonLogicNode element : arguments) {
            result = evaluator.evaluate(element, data, String.format("%s[%d]", jsonPath, index++));
            if ((!this.isAnd || JsonLogic.truthy(result)) && (this.isAnd || !JsonLogic.truthy(result))) continue;
            return result;
        }
        return result;
    }
}

