/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.daypickerlibrary.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.informramiz.daypickerlibrary.R;
import com.github.informramiz.daypickerlibrary.views.CircularTextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;

public class DayPickerView
extends FrameLayout
implements View.OnClickListener {
    private static final String LOG_TAG = DayPickerView.class.getSimpleName();
    public static final int DAY_SUNDAY = 0;
    public static final int DAY_MONDAY = 1;
    public static final int DAY_TUESDAY = 2;
    public static final int DAY_WEDNESDAY = 3;
    public static final int DAY_THURSDAY = 4;
    public static final int DAY_FRIDAY = 5;
    public static final int DAY_SATURDAY = 6;
    public static final int TOTAL_DAYS = 7;
    private boolean isMultiSelectionAllowed = true;
    private CircularTextView[] dayViews = new CircularTextView[7];
    @Nullable
    private OnDaysSelectionChangedListener onDaysSelectionChangedListener;

    public DayPickerView(@NonNull Context context) {
        super(context);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DayPickerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.DayPickerView);
        try {
            this.isMultiSelectionAllowed = typedArray.getBoolean(R.styleable.DayPickerView_isMultiSelectionAllowed, false);
        }
        finally {
            typedArray.recycle();
        }
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_day_picker_view, (ViewGroup)this, true);
        this.dayViews[0] = (CircularTextView)this.findViewById(R.id.view_sunday);
        this.dayViews[1] = (CircularTextView)this.findViewById(R.id.view_monday);
        this.dayViews[2] = (CircularTextView)this.findViewById(R.id.view_tuesday);
        this.dayViews[3] = (CircularTextView)this.findViewById(R.id.view_wednesday);
        this.dayViews[4] = (CircularTextView)this.findViewById(R.id.view_thursday);
        this.dayViews[5] = (CircularTextView)this.findViewById(R.id.view_friday);
        this.dayViews[6] = (CircularTextView)this.findViewById(R.id.view_saturday);
        for (CircularTextView dayView : this.dayViews) {
            dayView.setOnClickListener(this);
        }
        this.setDaySelected(this.getCurrentDay(), true);
    }

    public void onClick(View v) {
        this.decideOtherViewsSelection(v);
        if (this.onDaysSelectionChangedListener != null) {
            this.onDaysSelectionChangedListener.onDaysSelectionChange(this, this.getSelectedDays());
        }
    }

    public void setDaySelected(int day, boolean isSelected) {
        this.dayViews[day].setSelected(isSelected);
        this.decideOtherViewsSelection((View)this.dayViews[day]);
    }

    public void setDaysSelected(@NonNull @Size(value=7L) boolean[] selectedDays) {
        for (int i = 0; i < this.dayViews.length; ++i) {
            this.dayViews[i].setSelected(selectedDays[i]);
        }
    }

    @NonNull
    public boolean[] getSelectedDays() {
        boolean[] selectedDays = new boolean[7];
        for (int i = 0; i < this.dayViews.length; ++i) {
            selectedDays[i] = this.dayViews[i].isSelected();
        }
        return selectedDays;
    }

    public int getSelectedDaysCount() {
        return this.countTrue(this.getSelectedDays());
    }

    public boolean validateInput() {
        if (this.isMultiSelectionAllowed()) {
            return this.getSelectedDaysCount() >= 1;
        }
        return this.getSelectedDaysCount() == 1;
    }

    public boolean isMultiSelectionAllowed() {
        return this.isMultiSelectionAllowed;
    }

    public void setMultiSelectionAllowed(boolean multiSelectionAllowed) {
        this.isMultiSelectionAllowed = multiSelectionAllowed;
    }

    @Nullable
    public OnDaysSelectionChangedListener getOnDaysSelectionChangedListener() {
        return this.onDaysSelectionChangedListener;
    }

    public void setOnDaysSelectionChangedListener(@Nullable OnDaysSelectionChangedListener onDaysSelectionChangedListener) {
        this.onDaysSelectionChangedListener = onDaysSelectionChangedListener;
    }

    private void decideOtherViewsSelection(View viewToIgnore) {
        if (this.isMultiSelectionAllowed) {
            return;
        }
        for (CircularTextView dayView : this.dayViews) {
            if (dayView == viewToIgnore) continue;
            dayView.setSelected(false);
        }
    }

    private int countTrue(boolean[] values) {
        int count = 0;
        for (boolean value : values) {
            if (!value) continue;
            ++count;
        }
        return count;
    }

    private int getCurrentDay() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(7);
        return day - 1;
    }

    public static interface OnDaysSelectionChangedListener {
        public void onDaysSelectionChange(DayPickerView var1, boolean[] var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PickerDay {
    }
}

