/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.daypickerlibrary.views;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.github.informramiz.daypickerlibrary.R;
import com.github.informramiz.daypickerlibrary.views.DayPickerView;

public class DayPickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener {
    private static final String KEY_SELECTED_DAYS = "selectedDays";
    private static final String KEY_IS_MULTI_SELECTION_ALLOWED = "isMultiSelectionAllowed";
    private DayPickerView mDayPickerView;
    private TextView mHeaderTextView;
    @Nullable
    private boolean[] mInitialSelectedDays = new boolean[7];
    private boolean mIsMultiSelectionAllowed = true;
    @Nullable
    private OnDaysSelectedListener mOnDaysSelectedListener;

    public DayPickerDialog(Builder builder) {
        super(builder.context, builder.themeResId);
        this.mInitialSelectedDays = builder.initialSelectedDays;
        this.mOnDaysSelectedListener = builder.onDaysSelectedListener;
        this.mIsMultiSelectionAllowed = builder.isMultiSelectionAllowed;
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.day_picker_dialog, null);
        this.setView(view);
        this.setButton(-1, this.getContext().getString(17039370), this);
        this.setButton(-2, this.getContext().getString(0x1040000), this);
        this.mHeaderTextView = (TextView)view.findViewById(R.id.day_pick_dialog_header);
        if (!builder.isMultiSelectionAllowed) {
            this.mHeaderTextView.setText((CharSequence)this.getContext().getResources().getQuantityString(R.plurals.day_picker_dialog_title, 1));
        } else {
            this.mHeaderTextView.setText((CharSequence)this.getContext().getResources().getQuantityString(R.plurals.day_picker_dialog_title, 7));
        }
        this.mDayPickerView = (DayPickerView)view.findViewById(R.id.dayPickerView);
        if (this.mInitialSelectedDays != null) {
            this.mDayPickerView.setDaysSelected(this.mInitialSelectedDays);
        }
        this.mDayPickerView.setMultiSelectionAllowed(this.mIsMultiSelectionAllowed);
        this.mDayPickerView.setOnDaysSelectionChangedListener(new DayPickerView.OnDaysSelectionChangedListener(){

            @Override
            public void onDaysSelectionChange(DayPickerView dayPickerView, boolean[] selectedDays) {
                Log.i((String)DayPickerDialog.class.getSimpleName(), (String)"Days selection changed");
            }
        });
    }

    public void show() {
        super.show();
        this.getButton(-1).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DayPickerDialog.this.mDayPickerView.validateInput()) {
                    DayPickerDialog.this.onClick((DialogInterface)DayPickerDialog.this, -1);
                    DayPickerDialog.this.dismiss();
                }
            }
        });
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.mOnDaysSelectedListener == null) break;
                this.mOnDaysSelectedListener.onDaysSelected(this.mDayPickerView, this.mDayPickerView.getSelectedDays());
                break;
            }
            case -2: {
                this.cancel();
            }
        }
    }

    @NonNull
    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putBooleanArray(KEY_SELECTED_DAYS, this.mDayPickerView.getSelectedDays());
        state.putBoolean(KEY_IS_MULTI_SELECTION_ALLOWED, this.mDayPickerView.isMultiSelectionAllowed());
        return state;
    }

    public void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        boolean[] selectedDays = savedInstanceState.getBooleanArray(KEY_SELECTED_DAYS);
        if (selectedDays != null) {
            this.mDayPickerView.setDaysSelected(selectedDays);
        }
        this.mDayPickerView.setMultiSelectionAllowed(savedInstanceState.getBoolean(KEY_IS_MULTI_SELECTION_ALLOWED));
    }

    public static class Builder {
        @NonNull
        Context context;
        @Nullable
        boolean[] initialSelectedDays = null;
        boolean isMultiSelectionAllowed = true;
        @Nullable
        OnDaysSelectedListener onDaysSelectedListener = null;
        @StyleRes
        int themeResId = 0;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public Builder setInitialSelectedDays(@Nullable boolean[] initialSelectedDays) {
            this.initialSelectedDays = initialSelectedDays;
            return this;
        }

        public Builder setMultiSelectionAllowed(boolean multiSelectionAllowed) {
            this.isMultiSelectionAllowed = multiSelectionAllowed;
            return this;
        }

        public Builder setOnDaysSelectedListener(@Nullable OnDaysSelectedListener onDaysSelectedListener) {
            this.onDaysSelectedListener = onDaysSelectedListener;
            return this;
        }

        public Builder setThemeResId(int themeResId) {
            this.themeResId = themeResId;
            return this;
        }

        public DayPickerDialog build() {
            return new DayPickerDialog(this);
        }

        public void show() {
            this.build().show();
        }
    }

    public static interface OnDaysSelectedListener {
        public void onDaysSelected(DayPickerView var1, boolean[] var2);
    }
}

