/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.daypickerlibrary.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import com.github.informramiz.daypickerlibrary.R;
import com.github.informramiz.daypickerlibrary.views.CustomStateListDrawable;

public class CircularTextView
extends AppCompatTextView
implements View.OnClickListener {
    @Nullable
    private View.OnClickListener onClickListener = null;
    private boolean isAutoSelectEnabled = true;

    public CircularTextView(Context context) {
        super(context);
        this.init();
    }

    public CircularTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CircularTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void init() {
        this.setGravity(17);
        if (Build.VERSION.SDK_INT < 21) {
            this.setBackgroundDrawable((Drawable)new CustomStateListDrawable(this.getContext()));
        } else {
            this.setBackgroundDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.circular_text_view_background_selector));
        }
        this.setTextColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)R.color.circular_text_view_text_color_selector));
        super.setOnClickListener((View.OnClickListener)this);
    }

    public boolean isAutoSelectEnabled() {
        return this.isAutoSelectEnabled;
    }

    public void setAutoSelectEnabled(boolean autoSelectEnabled) {
        this.isAutoSelectEnabled = autoSelectEnabled;
    }

    public void onClick(View v) {
        if (this.isAutoSelectEnabled()) {
            this.handleAutoSelectEvent();
        }
        if (this.onClickListener != null) {
            this.onClickListener.onClick(v);
        }
    }

    private void handleAutoSelectEvent() {
        this.setSelected(!this.isSelected());
    }

    public void setOnClickListener(@Nullable View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }
}

