/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.daypickerlibrary.views;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import com.github.informramiz.daypickerlibrary.R;

public class CircularTextView
extends AppCompatTextView
implements View.OnClickListener {
    @Nullable
    private View.OnClickListener onClickListener = null;
    private boolean isAutoSelectEnabled = true;

    public CircularTextView(Context context) {
        super(context);
        this.init();
    }

    public CircularTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CircularTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void init() {
        this.setGravity(17);
        Drawable drawable2 = ResourcesCompat.getDrawable((Resources)this.getContext().getResources(), (int)R.drawable.circular_text_view_background_selector, (Resources.Theme)this.getContext().getTheme());
        this.setBackgroundDrawable(drawable2);
        this.setTextColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.circular_text_view_text_color_selector));
        super.setOnClickListener((View.OnClickListener)this);
    }

    public boolean isAutoSelectEnabled() {
        return this.isAutoSelectEnabled;
    }

    public void setAutoSelectEnabled(boolean autoSelectEnabled) {
        this.isAutoSelectEnabled = autoSelectEnabled;
    }

    public void onClick(View v) {
        if (this.isAutoSelectEnabled()) {
            this.handleAutoSelectEvent();
        }
        if (this.onClickListener != null) {
            this.onClickListener.onClick(v);
        }
    }

    private void handleAutoSelectEvent() {
        this.setSelected(!this.isSelected());
    }

    public void setOnClickListener(@Nullable View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }
}

