/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.androidfilepickerlibrary.utils;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;

@RequiresApi(api=16)
public class PermissionUtils {
    public static final String[] ATTACHMENT_PERMISSIONS = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};

    public static boolean checkStoragePermissions(@NonNull Context context) {
        return PermissionUtils.areAllPermissionsGranted(context, ATTACHMENT_PERMISSIONS);
    }

    public static void requestStoragePermissions(@NonNull Activity activity, int requestCode) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])ATTACHMENT_PERMISSIONS, (int)requestCode);
    }

    public static void requestStoragePermissions(@NonNull Fragment fragment, int requestCode) {
        fragment.requestPermissions(ATTACHMENT_PERMISSIONS, requestCode);
    }

    private static boolean areAllPermissionsGranted(Context context, String[] permissions) {
        for (String smsPermission : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)smsPermission) == 0) continue;
            return false;
        }
        return true;
    }

    private static void requestPermissions(Object obj, int requestCode, String[] permissions) {
        if (obj instanceof Activity) {
            Activity activity = (Activity)obj;
            ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)requestCode);
        } else if (obj instanceof Fragment) {
            Fragment fragment = (Fragment)obj;
            fragment.requestPermissions(permissions, requestCode);
        }
    }
}

