/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.androidfilepickerlibrary.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Base64;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.github.informramiz.androidfilepickerlibrary.FileInfo;
import com.github.informramiz.androidfilepickerlibrary.FilePickerCustomFileProvider;
import com.github.informramiz.androidfilepickerlibrary.utils.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    private static final String TAG = "FileUtils";
    private static final boolean DEBUG = false;
    public static final String MIME_TYPE_AUDIO = "audio/*";
    public static final String MIME_TYPE_TEXT = "text/*";
    public static final String MIME_TYPE_APK = "apk/*";
    public static final String MIME_TYPE_IMAGE = "image/*";
    public static final String MIME_TYPE_VIDEO = "video/*";
    public static final String MIME_TYPE_APP = "application/*";
    public static final String MIME_TYPE_PDF = "application/pdf";
    public static final String MIME_TYPE_PPT = "application/ppt";
    public static final String MIME_TYPE_DOC = "application/doc";
    public static final String MIME_TYPE_XLS = "application/xls";
    public static final String DATE_FORMAT = "yyyyMMdd_HHmmss";
    public static final String FILES_PREFIX = "filePicker_";
    public static final String MEDIA_FOLDER = "pickerMedia";
    public static final String IMAGE_EXTENSION = ".jpg";
    public static final String VIDEO_EXTENSION = ".mp4";
    public static final String[] DOC_FILE_EXTENTSIONS = new String[]{"pdf", "doc", "ppt", "xls", "txt"};
    public static final String[] AUDIO_FILE_EXTENTSIONS = new String[]{"mp3"};
    public static final String HIDDEN_PREFIX = ".";

    public static String encodeFileToBase64Binary(File file) {
        String encodedFile = null;
        try {
            FileInputStream fileInputStreamReader = new FileInputStream(file);
            byte[] bytes = new byte[(int)file.length()];
            fileInputStreamReader.read(bytes);
            encodedFile = Base64.encodeToString((byte[])bytes, (int)0);
            fileInputStreamReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodedFile;
    }

    public static String encodeFileToBase64Binary(ContentResolver contentResolver, Uri fileUri) {
        String encodedFile = null;
        try {
            InputStream fileInputStreamReader = contentResolver.openInputStream(fileUri);
            byte[] bytes = new byte[fileInputStreamReader.available()];
            fileInputStreamReader.read(bytes);
            encodedFile = Base64.encodeToString((byte[])bytes, (int)0);
            fileInputStreamReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodedFile;
    }

    public static byte[] readFileBytesFromUri(ContentResolver contentResolver, Uri fileUri) {
        try {
            InputStream inputStream = contentResolver.openInputStream(fileUri);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] bytes = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(bytes);
            inputStream.close();
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readFileFromUri(ContentResolver contentResolver, Uri fileUri) {
        try {
            String line;
            InputStream inputStream = contentResolver.openInputStream(fileUri);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            inputStream.close();
            reader.close();
            return stringBuilder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getExtension(String uri) {
        if (uri == null) {
            return null;
        }
        int dot = uri.lastIndexOf(HIDDEN_PREFIX);
        if (dot >= 0) {
            return uri.substring(dot);
        }
        return "";
    }

    public static String getExtensionFromMimeType(String mimeType) {
        return MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
    }

    public static String getMainFileType(String mimeType) {
        String type = mimeType.contains("image") ? "image" : (mimeType.contains("video") ? "video" : (mimeType.contains("audio") ? "audio" : (mimeType.contains("text") ? "text" : "application")));
        return type;
    }

    public static boolean isLocal(String url) {
        return url != null && !url.startsWith("http://") && !url.startsWith("https://");
    }

    public static boolean isMediaUri(Uri uri) {
        return "media".equalsIgnoreCase(uri.getAuthority());
    }

    public static Uri getUri(File file) {
        if (file != null) {
            return Uri.fromFile((File)file);
        }
        return null;
    }

    public static File getPathWithoutFilename(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return file;
            }
            String filename = file.getName();
            String filepath = file.getAbsolutePath();
            String pathwithoutname = filepath.substring(0, filepath.length() - filename.length());
            if (pathwithoutname.endsWith("/")) {
                pathwithoutname = pathwithoutname.substring(0, pathwithoutname.length() - 1);
            }
            return new File(pathwithoutname);
        }
        return null;
    }

    public static String getMimeType(File file) {
        String extension = FileUtils.getExtension(file.getName());
        if (extension.length() > 0) {
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.substring(1));
        }
        return "application/octet-stream";
    }

    @RequiresApi(api=19)
    public static String getMimeType(Context context, Uri uri) {
        File file = new File(FileUtils.getPath(context, uri));
        return FileUtils.getMimeType(file);
    }

    public static boolean isLocalStorageDocument(Uri uri) {
        return FilePickerCustomFileProvider.getAuthority().equals(uri.getAuthority());
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isGoogleDriveUri(Uri uri) {
        return "com.google.android.apps.docs.storage".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static String getPath(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 19) {
            return FileUtils.getPathKitkatAndAbove(context, uri);
        }
        if ("content".equalsIgnoreCase(uri.getScheme())) {
            if (FileUtils.isGooglePhotosUri(uri)) {
                return uri.getLastPathSegment();
            }
            if (FileUtils.isGoogleDriveUri(uri)) {
                return uri.getLastPathSegment();
            }
            return FileUtils.getDataColumn(context, uri, null, null);
        }
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return uri.getPath();
        }
        return null;
    }

    @RequiresApi(api=19)
    private static String getPathKitkatAndAbove(Context context, Uri uri) {
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isLocalStorageDocument(uri)) {
                return DocumentsContract.getDocumentId((Uri)uri);
            }
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
                uri.getPath();
            } else {
                if (FileUtils.isDownloadsDocument(uri)) {
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    LogUtils.i(TAG, "id=" + id);
                    if (id.contains("raw:")) {
                        return id.replace("raw:", "");
                    }
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                    return FileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (FileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        }
        return null;
    }

    @RequiresApi(api=19)
    public static File getFile(Context context, Uri uri) {
        String path;
        if (uri != null && (path = FileUtils.getPath(context, uri)) != null && FileUtils.isLocal(path)) {
            return new File(path);
        }
        return null;
    }

    public static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static boolean isDocFile(@NonNull String extension, @Nullable String mimeType) {
        return !FileUtils.isImageAttachment(extension, mimeType) && !FileUtils.isVideoAttachment(extension, mimeType);
    }

    public static boolean isDocFile(@NonNull String fileName) {
        return FilenameUtils.isExtension((String)fileName, (String[])DOC_FILE_EXTENTSIONS);
    }

    public static boolean isDocFile(@NonNull FileInfo fileInfo) {
        return FileUtils.isDocFile(fileInfo.getName());
    }

    public static boolean isAudioFile(@NonNull String fileName) {
        return FilenameUtils.isExtension((String)fileName, (String[])AUDIO_FILE_EXTENTSIONS);
    }

    public static boolean isAudioFile(@NonNull FileInfo fileInfo) {
        return FileUtils.isAudioFile(fileInfo.getName()) || fileInfo.getType().contains("audio");
    }

    public static boolean isImageAttachment(@NonNull String extension, @Nullable String mimeType) {
        if (mimeType == null) {
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return mimeType != null && mimeType.startsWith("image");
    }

    public static boolean isVideoAttachment(@NonNull String extension, @Nullable String mimeType) {
        if (mimeType == null) {
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return mimeType != null && mimeType.startsWith("video");
    }

    public static boolean isImageFile(String path) {
        String mimeType = URLConnection.guessContentTypeFromName(path);
        return mimeType != null && mimeType.startsWith("image");
    }

    public static String getFileExtension(String path) {
        return FilenameUtils.getExtension((String)path);
    }

    public static boolean isVideoFile(String path) {
        String mimeType = URLConnection.guessContentTypeFromName(path);
        return mimeType != null && mimeType.startsWith("video");
    }

    public static String getFileType(File file) {
        String mimeType = null;
        String extension = FilenameUtils.getExtension((String)file.getAbsolutePath());
        if (extension != null) {
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        String type = "image";
        if (mimeType != null) {
            type = mimeType.contains("image") ? "image" : (mimeType.contains("video") ? "video" : "application");
        }
        return type;
    }

    @Nullable
    public static File createImageFile(@NonNull Context context) {
        String fileNamePrefix = FileUtils.getFileNamePrefix();
        File storageDir = new File(context.getFilesDir() + "/" + MEDIA_FOLDER);
        boolean isDirectoryPresent = true;
        if (!storageDir.exists()) {
            try {
                isDirectoryPresent = storageDir.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!isDirectoryPresent) {
            return null;
        }
        File imageFile = null;
        try {
            imageFile = File.createTempFile(fileNamePrefix, IMAGE_EXTENSION, storageDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageFile;
    }

    public static File createVideoFile(@NonNull Context context) {
        String fileNamePrefix = FileUtils.getFileNamePrefix();
        File storageDir = new File(context.getFilesDir() + "/" + MEDIA_FOLDER);
        boolean isDirectoryPresent = true;
        if (!storageDir.exists()) {
            isDirectoryPresent = storageDir.mkdir();
        }
        if (!isDirectoryPresent) {
            return null;
        }
        File videoFile = null;
        try {
            videoFile = File.createTempFile(fileNamePrefix, VIDEO_EXTENSION, storageDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return videoFile;
    }

    @NonNull
    private static String getFileNamePrefix() {
        String timeStamp = new SimpleDateFormat(DATE_FORMAT, Locale.US).format(new Date());
        return FILES_PREFIX + timeStamp + "_";
    }

    public static void addFileToGallery(@NonNull Activity activity, String filePath) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File file = new File(filePath);
        Uri contentUri = FilePickerCustomFileProvider.getUriForFile((Context)activity, file);
        mediaScanIntent.setData(contentUri);
        mediaScanIntent.addFlags(1);
        activity.getApplicationContext().sendBroadcast(mediaScanIntent);
    }

    public static void addFileToGallery(@NonNull Activity activity, Uri contentUri) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaScanIntent.setData(contentUri);
        mediaScanIntent.addFlags(1);
        activity.getApplicationContext().sendBroadcast(mediaScanIntent);
    }
}

