/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.androidfilepickerlibrary;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import com.github.informramiz.androidfilepickerlibrary.FileInfo;
import com.github.informramiz.androidfilepickerlibrary.FilePicker;
import com.github.informramiz.androidfilepickerlibrary.FilePickerCustomFileProvider;
import com.github.informramiz.androidfilepickerlibrary.R;
import com.github.informramiz.androidfilepickerlibrary.utils.CommonUtils;
import com.github.informramiz.androidfilepickerlibrary.utils.FileUtils;
import com.github.informramiz.androidfilepickerlibrary.utils.LogUtils;
import java.io.File;

public class AttachmentPickerActivity
extends AppCompatActivity {
    private static final String TAG = AttachmentPickerActivity.class.getSimpleName();
    private static final String[] GALLERY_ATTACHMENT_MIME_TYPES = new String[]{"image/*", "video/*"};
    private static final String[] DOC_ATTACHMENT_MIME_TYPES = new String[]{"text/*", "application/*"};
    private static final String[] AUDIO_ATTACHMENT_MIME_TYPES = new String[]{"audio/*"};
    private static final String MAIN_MIME_TYPE_GALLERY_ATTACHMENT = "video/*,image/*";
    private static final String MAIN_MIME_TYPE_DOC_ATTACHMENT = "*/*";
    private static final String MAIN_MIME_TYPE_AUDIO_ATTACHMENT = "*/*";
    public static final String DATA_ATTACHMENT = "attachment";
    public static final String EXTRA_ATTACHMENT_TYPE = "attachmentType";
    public static final int ATTACHMENT_TYPE_GALLERY = 0;
    public static final int ATTACHMENT_TYPE_DOC = 1;
    public static final int ATTACHMENT_TYPE_CAPTURE_FROM_CAMERA = 2;
    public static final int ATTACHMENT_TYPE_PICK_AUDIO = 3;
    public static final String EXTRA_CAPTURE_TYPE = "capture_type";
    public static final int CAPTURE_TYPE_IMAGE = 0;
    public static final int CAPTURE_TYPE_VIDEO = 1;
    public static final int REQ_CODE_CAPTURE_IMAGE = 2;
    public static final int REQ_CODE_CAPTURE_VIDEO = 3;
    public static final int REQ_CODE_SELECT_ATTACHMENT = 4;
    private FileInfo captureFromCameraAttachment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int attachmentType = this.getIntent().getIntExtra(EXTRA_ATTACHMENT_TYPE, 0);
        switch (attachmentType) {
            case 0: {
                this.showFileChooser("*/*", GALLERY_ATTACHMENT_MIME_TYPES);
                break;
            }
            case 1: {
                this.showFileChooser("*/*", DOC_ATTACHMENT_MIME_TYPES);
                break;
            }
            case 2: {
                this.handleCameraAttachment();
                break;
            }
            case 3: {
                this.showFileChooser("*/*", AUDIO_ATTACHMENT_MIME_TYPES);
            }
        }
    }

    @RequiresApi(api=19)
    private void showFileChooser(@NonNull String mainMimeType, @Nullable String[] mimeTypes) {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.setType(mainMimeType);
        intent.addCategory("android.intent.category.OPENABLE");
        intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        if (mimeTypes != null) {
            intent.putExtra("android.intent.extra.MIME_TYPES", mimeTypes);
        }
        this.startActivityForResult(intent, 4);
    }

    private void handleCameraAttachment() {
        int captureType = this.getIntent().getIntExtra(EXTRA_CAPTURE_TYPE, 0);
        if (captureType == 1) {
            this.launchCameraVideoIntent();
        } else {
            this.captureFromCameraAttachment = this.launchCameraImageIntent();
        }
    }

    private void launchCameraVideoIntent() {
        Intent recordVideoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (recordVideoIntent.resolveActivity(this.getPackageManager()) != null) {
            this.startActivityForResult(recordVideoIntent, 3);
        } else {
            CommonUtils.showFeatureNotSupportedToast((Context)this);
        }
    }

    @Nullable
    private FileInfo launchCameraImageIntent() {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.getPackageManager()) == null) {
            CommonUtils.showFeatureNotSupportedToast((Context)this);
            return null;
        }
        File photoFile = FileUtils.createImageFile((Context)this);
        if (photoFile == null) {
            CommonUtils.showMessageSafe((Context)this, R.string.error_msg_file_creation_failed);
            return null;
        }
        Uri contentUri = FilePickerCustomFileProvider.getUriForFile((Context)this, photoFile);
        takePictureIntent.addFlags(3);
        takePictureIntent.putExtra("output", (Parcelable)contentUri);
        this.startActivityForResult(takePictureIntent, 2);
        FileInfo fileInfo = FilePicker.convertFileToAttachment(photoFile);
        fileInfo.setUri(contentUri);
        return fileInfo;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Intent dataIntent = new Intent();
        if (resultCode != -1) {
            this.setResult(resultCode, dataIntent);
            this.finish();
            return;
        }
        FileInfo attachment = null;
        if (requestCode == 2) {
            FileUtils.addFileToGallery((Activity)this, this.captureFromCameraAttachment.getPath());
            attachment = this.captureFromCameraAttachment;
        } else if (requestCode == 3) {
            attachment = FilePicker.extractAttachInfoFromUri(this.getApplicationContext(), data.getData());
        } else if (requestCode == 4) {
            attachment = this.extractFileInfo(this.getApplicationContext(), data);
        }
        dataIntent.putExtra(DATA_ATTACHMENT, (Parcelable)attachment);
        this.setResult(-1, dataIntent);
        this.finish();
    }

    private FileInfo extractFileInfo(Context context, Intent data) {
        Uri uri = data.getData();
        this.takePersistablePermissions(context, data, uri);
        LogUtils.i(TAG, "Uri received from File picker: " + uri.toString());
        LogUtils.i(TAG, "Path received from File picker: " + uri.getPath());
        FileInfo fileInfo = FilePicker.extractAttachInfoFromUri(context, uri);
        LogUtils.i(TAG, fileInfo.toString());
        return fileInfo;
    }

    @RequiresApi(api=19)
    private void takePersistablePermissions(Context context, Intent data, Uri uri) {
        try {
            int flags = data.getFlags() & 3;
            context.getContentResolver().takePersistableUriPermission(uri, flags);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

