package com.github.informramiz.androidfilepickerlibrary.utils;

import android.support.annotation.RestrictTo;
import android.util.Log;

import com.github.informramiz.androidfilepickerlibrary.BuildConfig;

/**
 * Created by ramiz on 20/04/2018
 */
@RestrictTo(RestrictTo.Scope.LIBRARY)
public class LogUtils {

    public static void v(String tag, String msg) {
        if (BuildConfig.DEBUG) {
            Log.v(tag, msg);
        }
    }

    public static void i(String tag, String msg) {
        if (BuildConfig.DEBUG) {
            Log.i(tag, msg);
        }
    }

    public static void d(String tag, String msg) {
        if (BuildConfig.DEBUG) {
            Log.d(tag, msg);
        }
    }

    public static void w(String tag, String msg) {
        if (BuildConfig.DEBUG) {
            Log.w(tag, msg);
        }
    }

    public static void e(String tag, String msg) {
        if (BuildConfig.DEBUG) {
            Log.e(tag, msg);
        }
    }
}
