/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.androidfilepickerlibrary;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import com.github.informramiz.androidfilepickerlibrary.Attach;
import com.github.informramiz.androidfilepickerlibrary.AttachmentPickerActivity;
import com.github.informramiz.androidfilepickerlibrary.CameraAttachmentPickerDialog;
import com.github.informramiz.androidfilepickerlibrary.utils.FileUtils;
import com.github.informramiz.androidfilepickerlibrary.utils.PermissionUtils;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class FilePicker {
    public static final String TAG = FilePicker.class.getSimpleName();
    public static final int REQ_CODE_CAPTURE_IMAGE = 2;
    public static final int REQ_CODE_CAPTURE_VIDEO = 3;
    public static final int REQ_CODE_PICK_AUDIO_FILE = 4;
    public static final int REQ_CODE_PICK_GALLERY = 5;
    public static final int REQ_CODE_PICK_DOC = 6;

    public static Attach convertFileToAttachment(String filePath) {
        return FilePicker.convertFileToAttachment(new File(filePath));
    }

    public static Attach convertFileToAttachment(File file) {
        Attach attachment = new Attach();
        attachment.setExtension(FilenameUtils.getExtension((String)file.getAbsolutePath()));
        attachment.setName(file.getName());
        attachment.setPath(file.getPath());
        attachment.setSize(file.length());
        attachment.setType(FileUtils.getFileType(file));
        return attachment;
    }

    private static void openCaptureImageFromCameraPicker(@NonNull Activity activity, @Nullable Fragment fragment) {
        Intent intent = new Intent((Context)activity, AttachmentPickerActivity.class);
        intent.putExtra("attachmentType", 2);
        intent.putExtra("capture_type", 0);
        if (fragment != null) {
            fragment.startActivityForResult(intent, 2);
        } else {
            activity.startActivityForResult(intent, 2);
        }
    }

    public static void openCaptureImageFromCameraPicker(@NonNull Activity activity) {
        FilePicker.openCaptureImageFromCameraPicker(activity, null);
    }

    public static void openCaptureImageFromCameraPicker(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null || !fragment.isAdded()) {
            return;
        }
        FilePicker.openCaptureImageFromCameraPicker((Activity)fragment.getActivity(), fragment);
    }

    private static void openCaptureVideoFromCameraPicker(@NonNull Activity activity, @Nullable Fragment fragment) {
        Intent intent = new Intent((Context)activity, AttachmentPickerActivity.class);
        intent.putExtra("attachmentType", 2);
        intent.putExtra("capture_type", 1);
        if (fragment != null) {
            fragment.startActivityForResult(intent, 3);
        } else {
            activity.startActivityForResult(intent, 3);
        }
    }

    public static void showCameraPickerDialog(@NonNull Activity activity) {
        FilePicker.showCameraPickerDialog((Object)activity);
    }

    public static void showCameraPickerDialog(@NonNull Fragment fragment) {
        FilePicker.showCameraPickerDialog((Object)fragment);
    }

    private static void showCameraPickerDialog(@NonNull Object object) {
        Fragment fragment = null;
        Activity activity = null;
        if (object instanceof Fragment) {
            fragment = (Fragment)object;
            activity = fragment.getActivity();
        } else {
            activity = (Activity)object;
        }
        final Fragment finalFragment = fragment;
        final Activity finalActivity = activity;
        CameraAttachmentPickerDialog cameraAttachmentPickerDialog = new CameraAttachmentPickerDialog((Context)finalActivity);
        cameraAttachmentPickerDialog.setOnOptionSelectedListener(new CameraAttachmentPickerDialog.OnOptionSelectedListener(){

            @Override
            public void onImageOptionSelected() {
                FilePicker.openCaptureImageFromCameraPicker(finalActivity, finalFragment);
            }

            @Override
            public void onVideoOptionSelected() {
                FilePicker.openCaptureVideoFromCameraPicker(finalActivity, finalFragment);
            }
        });
        cameraAttachmentPickerDialog.showCameraDialog();
    }

    public static void openCaptureVideoFromCameraPicker(@NonNull Activity activity) {
        FilePicker.openCaptureVideoFromCameraPicker(activity, null);
    }

    public static void openCaptureVideoFromCameraPicker(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null || !fragment.isAdded()) {
            return;
        }
        FilePicker.openCaptureVideoFromCameraPicker((Activity)fragment.getActivity(), fragment);
    }

    private static void openGalleryPicker(@NonNull Activity activity, @Nullable Fragment fragment) {
        Intent intent = new Intent((Context)activity, AttachmentPickerActivity.class);
        intent.putExtra("attachmentType", 0);
        if (fragment != null) {
            fragment.startActivityForResult(intent, 5);
        } else {
            activity.startActivityForResult(intent, 5);
        }
    }

    public static void openGalleryPicker(@NonNull Activity activity) {
        FilePicker.openGalleryPicker(activity, null);
    }

    public static void openGalleryPicker(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null || !fragment.isAdded()) {
            return;
        }
        FilePicker.openGalleryPicker((Activity)fragment.getActivity(), fragment);
    }

    private static void openDocumentPicker(@NonNull Activity activity, @Nullable Fragment fragment) {
        Intent intent = new Intent((Context)activity, AttachmentPickerActivity.class);
        intent.putExtra("attachmentType", 1);
        if (fragment != null) {
            fragment.startActivityForResult(intent, 6);
        } else {
            activity.startActivityForResult(intent, 6);
        }
    }

    public static void openDocumentPicker(@NonNull Activity activity) {
        FilePicker.openDocumentPicker(activity, null);
    }

    public static void openDocumentPicker(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null || !fragment.isAdded()) {
            return;
        }
        FilePicker.openDocumentPicker((Activity)fragment.getActivity(), fragment);
    }

    private static void openAudioPicker(@NonNull Activity activity, @Nullable Fragment fragment) {
        Intent intent = new Intent((Context)activity, AttachmentPickerActivity.class);
        intent.putExtra("attachmentType", 3);
        if (fragment != null) {
            fragment.startActivityForResult(intent, 4);
        } else {
            activity.startActivityForResult(intent, 4);
        }
    }

    public static void openAudioPicker(@NonNull Activity activity) {
        FilePicker.openAudioPicker(activity, null);
    }

    public static void openAudioPicker(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null || !fragment.isAdded()) {
            return;
        }
        FilePicker.openAudioPicker((Activity)fragment.getActivity(), fragment);
    }

    public static Attach onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            return null;
        }
        Attach attachment = null;
        if (requestCode == 2 || requestCode == 3 || requestCode == 5 || requestCode == 6 || requestCode == 4) {
            attachment = (Attach)data.getParcelableExtra("attachment");
        }
        return attachment;
    }

    public static boolean canHandleActivityResult(int requestCode) {
        return requestCode == 2 || requestCode == 3 || requestCode == 5 || requestCode == 6 || requestCode == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=16)
    public static Attach extractAttachInfoFromUri(Context context, Uri uri) {
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null, null);
        Attach attach = new Attach();
        if (PermissionUtils.checkStoragePermissions(context)) {
            attach.setPath(FileUtils.getPath(context, uri));
        }
        attach.setUri(uri);
        try {
            if (cursor != null && cursor.moveToFirst()) {
                String name = cursor.getString(cursor.getColumnIndex("_display_name"));
                attach.setName(name);
                String mimeType = cursor.getString(cursor.getColumnIndex("mime_type"));
                if (mimeType == null) {
                    mimeType = context.getContentResolver().getType(uri);
                }
                attach.setType(mimeType);
                String extension = FileUtils.getExtensionFromMimeType(mimeType);
                attach.setExtension(extension);
                int sizeColIndex = cursor.getColumnIndex("_size");
                Long size = null;
                if (!cursor.isNull(sizeColIndex)) {
                    size = cursor.getInt(sizeColIndex);
                }
                attach.setSize(size);
            } else if (attach.getPath() != null) {
                attach = FilePicker.convertFileToAttachment(attach.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return attach;
    }
}

