/*
 * Decompiled with CFR 0.152.
 */
package io.github.esneiderfjaimes.githooks;

import io.github.esneiderfjaimes.githooks.GitHooksPlugin;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lio/github/esneiderfjaimes/githooks/GitHooksPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "installGitHooks", "sha256", "", "Ljava/io/File;", "githooks-plugin"})
@SourceDebugExtension(value={"SMAP\nGitHooksPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHooksPlugin.kt\nio/github/esneiderfjaimes/githooks/GitHooksPlugin\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,97:1\n6479#2:98\n13409#2,2:99\n*S KotlinDebug\n*F\n+ 1 GitHooksPlugin.kt\nio/github/esneiderfjaimes/githooks/GitHooksPlugin\n*L\n39#1:98\n64#1:99,2\n*E\n"})
public final class GitHooksPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.afterEvaluate(new Action(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitHooksPlugin this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public final void execute(Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                if (this.$project.file((Object)".git").exists()) {
                    System.out.println((Object)"[>] Installing Git hooks after project evaluation");
                    GitHooksPlugin.access$installGitHooks(this.this$0, this.$project);
                }
            }
        });
        project.getTasks().register("installGitHooks", new Action(this, project){
            final /* synthetic */ GitHooksPlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public final void execute(Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("git");
                $this$register.setDescription("Cleans and installs Git hooks from the hooks/ directory");
                $this$register.doLast(new Action(this.this$0, this.$project){
                    final /* synthetic */ GitHooksPlugin this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                    }

                    public final void execute(Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$this$doLast");
                        GitHooksPlugin.access$installGitHooks(this.this$0, this.$project);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void installGitHooks(Project project) {
        v0 = project.file((Object)".git/hooks");
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"project.file(\".git/hooks\")");
        gitHooksDir = v0;
        v1 = project.file((Object)"hooks");
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"project.file(\"hooks\")");
        hooksDir = v1;
        markerFile = new File(gitHooksDir, ".installed");
        if (!hooksDir.exists()) {
            System.out.println((Object)"[!] hooks/ directory not found, skipping Git hooks installation");
            return;
        }
        var6_5 = hooksDir.listFiles();
        if (var6_5 == null) ** GOTO lbl-1000
        var8_6 = var6_5;
        $i$f$sortedBy = false;
        var7_8 = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        if (var7_8 != null && ($this$sortedBy$iv = CollectionsKt.joinToString$default((Iterable)var7_8, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<File, CharSequence>(this){
            final /* synthetic */ GitHooksPlugin this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final CharSequence invoke(File it) {
                StringBuilder stringBuilder;
                GitHooksPlugin gitHooksPlugin = this.this$0;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u240.append(it.getName());
                $this$invoke_u24lambda_u240.append(":");
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                $this$invoke_u24lambda_u240.append(GitHooksPlugin.access$sha256(gitHooksPlugin, it));
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }), (int)30, null)) != null) {
            v2 = $this$sortedBy$iv;
        } else lbl-1000:
        // 2 sources

        {
            v2 = "";
        }
        currentHooksSignature = v2;
        v3 = previousSignature = markerFile.exists() != false ? FilesKt.readText$default((File)markerFile, null, (int)1, null) : "";
        if (Intrinsics.areEqual((Object)currentHooksSignature, (Object)previousSignature)) {
            System.out.println((Object)"[>] Git hooks already installed and up to date, skipping installation");
            return;
        }
        if (gitHooksDir.exists()) {
            System.out.println((Object)"[>] Removing existing .git/hooks directory");
            FilesKt.deleteRecursively((File)gitHooksDir);
        }
        System.out.println((Object)"[>] Creating fresh .git/hooks directory");
        gitHooksDir.mkdirs();
        System.out.println((Object)"[>] Copying hooks with executable permissions");
        v4 = hooksDir.listFiles();
        if (v4 != null) {
            $this$forEach$iv = v4;
            $i$f$forEach = false;
            var11_11 = $this$forEach$iv.length;
            for (var10_10 = 0; var10_10 < var11_11; ++var10_10) {
                hookFile = element$iv = $this$forEach$iv[var10_10];
                $i$a$-forEach-GitHooksPlugin$installGitHooks$1 = false;
                target = new File(gitHooksDir, hookFile.getName());
                Intrinsics.checkNotNullExpressionValue((Object)hookFile, (String)"hookFile");
                var16_16 = new FileInputStream(hookFile);
                var17_17 = null;
                try {
                    input = (FileInputStream)var16_16;
                    $i$a$-use-GitHooksPlugin$installGitHooks$1$1 = false;
                    var21_23 = new FileOutputStream(target);
                    var22_24 = null;
                    try {
                        output = (FileOutputStream)var21_23;
                        $i$a$-use-GitHooksPlugin$installGitHooks$1$1$1 = false;
                        var23_25 = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable var23_27) {
                        var22_24 = var23_27;
                        throw var23_27;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var21_23, (Throwable)var22_24);
                    }
                    var18_18 = var23_25;
                }
                catch (Throwable var18_20) {
                    var17_17 = var18_20;
                    throw var18_20;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var16_16, (Throwable)var17_17);
                }
                target.setExecutable(true);
            }
        }
        FilesKt.writeText$default((File)markerFile, (String)currentHooksSignature, null, (int)2, null);
        System.out.println((Object)("[>] currentHooksSignature is " + currentHooksSignature));
        System.out.println((Object)"[OK] Git hooks installed successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String sha256(File $this$sha256) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        Closeable closeable = new FileInputStream($this$sha256);
        Throwable throwable = null;
        try {
            FileInputStream fis = (FileInputStream)closeable;
            boolean bl = false;
            byte[] buffer = new byte[8192];
            int bytesRead = fis.read(buffer);
            if (bytesRead == -1) {
                byte[] byArray = digest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
                String string = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)sha256.1.1.INSTANCE, (int)30, null);
                return string;
            }
            while (bytesRead != -1) {
                digest.update(buffer, 0, bytesRead);
                bytesRead = fis.read(buffer);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)sha256.2.INSTANCE, (int)30, null);
    }

    public static final /* synthetic */ void access$installGitHooks(GitHooksPlugin $this, Project project) {
        $this.installGitHooks(project);
    }

    public static final /* synthetic */ String access$sha256(GitHooksPlugin $this, File $receiver) {
        return $this.sha256($receiver);
    }
}

