/*
 * Decompiled with CFR 0.152.
 */
package com.github.dkorotych.gradle.maven;

import com.github.dkorotych.gradle.maven.MavenDescriptor;
import com.github.dkorotych.gradle.maven.MemoizedSupplier;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.gradle.internal.os.OperatingSystem;

public class MavenExecutableProvider {
    private final Path mavenHome;
    private final MemoizedSupplier<String> executableSupplier = MemoizedSupplier.of(this::build);

    public MavenExecutableProvider(Path mavenHome) {
        this.mavenHome = mavenHome;
    }

    public String getExecutable() {
        return this.executableSupplier.get();
    }

    private String build() {
        boolean hasWrapper = Optional.ofNullable(this.mavenHome).flatMap(path -> {
            Optional<File> optional;
            block8: {
                Stream<Path> files = Files.list(path);
                try {
                    optional = files.map(Path::toFile).filter(MavenDescriptor::isMavenExecutionWrapperFile).findFirst();
                    if (files == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        return Optional.empty();
                    }
                }
                files.close();
            }
            return optional;
        }).isPresent();
        boolean windows = OperatingSystem.current().isWindows();
        StringBuilder command = new StringBuilder("mvn" + (Serializable)(hasWrapper ? Character.valueOf('w') : ""));
        if (windows) {
            String extension = ".cmd";
            if (hasWrapper) {
                command.append(".cmd");
            } else {
                boolean oldVersion = Path.of(command + ".bat", new String[0]).toFile().exists();
                if (oldVersion) {
                    command.append(".bat");
                } else {
                    command.append(".cmd");
                }
            }
        }
        if (this.mavenHome != null) {
            Path pathToRunner = hasWrapper ? this.mavenHome.resolve(command.toString()) : this.mavenHome.resolve("bin").resolve(command.toString());
            return pathToRunner.toAbsolutePath().toString();
        }
        return command.toString();
    }
}

