/*
 * Decompiled with CFR 0.152.
 */
package com.github.dkorotych.gradle.maven;

import com.github.dkorotych.gradle.maven.IncorrectMavenInstallationDirectoryException;
import com.github.dkorotych.gradle.maven.MavenDescriptor;
import com.github.dkorotych.gradle.maven.MavenHomeProvider;
import com.github.dkorotych.gradle.maven.MavenOptionsToCommandLineAdapter;
import com.github.dkorotych.gradle.maven.exec.MavenExecSpec;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public final class CommandLineCreator {
    private final MavenExecSpec specification;
    private final Project project;
    private final Logger logger;
    private final MavenHomeProvider mavenHomeProvider;
    private String executable;
    private List<String> arguments;

    public CommandLineCreator(MavenExecSpec specification, Project project) {
        this.specification = Objects.requireNonNull(specification, "Specification should be not null");
        this.project = Objects.requireNonNull(project, "Project should be not null");
        this.logger = project.getLogger();
        this.mavenHomeProvider = new MavenHomeProvider();
        File mavenDir = specification.getMavenDir();
        if (mavenDir != null) {
            this.mavenHomeProvider.setMavenHome(mavenDir);
        }
        this.prepareCommandLine();
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    private void prepareCommandLine() {
        if (this.getMavenDir() == null) {
            this.logger.info("The directory with the executable Maven file is not set. The plugin will try to find the installation by itself");
            this.findMavenExecutable();
            if (this.getMavenDir() == null) {
                throw new GradleException("Maven installation not found");
            }
            this.logger.info("Use Maven from: {}", (Object)this.getMavenDir());
        }
        Path mavenHome = Optional.ofNullable(this.getMavenDir()).map(File::toPath).orElse(null);
        File workingDir = this.specification.getWorkingDir();
        MavenDescriptor descriptor = new MavenDescriptor(mavenHome, workingDir, this.project);
        this.executable = descriptor.getExecutable();
        this.arguments = new ArrayList<String>(new MavenOptionsToCommandLineAdapter(this.specification.getOptions(), descriptor.getSupportedOptions()).asCommandLine());
        this.arguments.addAll(this.specification.getGoals());
    }

    private void findMavenExecutable() {
        this.findMavenInDirectory(this.specification.getWorkingDir());
        if (this.getMavenDir() == null && !this.mavenHomeProvider.findMavenHome()) {
            this.findMavenInDirectory((File)this.project.getLayout().getBuildDirectory().getAsFile().get());
            this.findMavenInDirectory(this.project.getProjectDir());
            this.findMavenInDirectory(this.project.getRootDir());
        }
    }

    private void findMavenInDirectory(File directory) {
        if (this.getMavenDir() == null) {
            this.logger.info("Find Maven executable in {}", (Object)directory);
            try {
                this.mavenHomeProvider.setMavenHome(directory);
                this.specification.setMavenDir(directory);
            }
            catch (IncorrectMavenInstallationDirectoryException ignored) {
                this.logger.debug("Maven executable not found {}", (Object)directory);
            }
        }
    }

    private File getMavenDir() {
        return Optional.of(this.mavenHomeProvider).map(MavenHomeProvider::getMavenHome).map(Path::toFile).orElse(null);
    }
}

