/**
 * Copyright 2022 Dmitry Korotych
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.dkorotych.gradle.maven.exec;

import com.github.dkorotych.gradle.maven.DefaultMavenOptions;
import com.github.dkorotych.gradle.maven.MavenOptions;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;

class MavenProperties {
    private final MavenOptions options = new DefaultMavenOptions();
    private final Set<String> goals = new LinkedHashSet<>();
    private File mavenDir;

    MavenOptions getOptions() {
        return options;
    }

    Set<String> getGoals() {
        return goals;
    }

    File getMavenDir() {
        return mavenDir;
    }

    void setMavenDir(final File mavenDir) {
        this.mavenDir = mavenDir;
    }
}
