/*
 * Decompiled with CFR 0.152.
 */
package com.github.dkorotych.gradle.maven.exec;

import com.github.dkorotych.gradle.maven.exec.MavenExecSpec;
import com.github.dkorotych.gradle.maven.exec.MavenExecSpecDelegate;
import groovy.lang.Closure;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.util.ClosureBackedAction;
import org.gradle.util.CollectionUtils;

public class MavenExecConvention {
    private final Project project;

    public MavenExecConvention(Project project) {
        this.project = Objects.requireNonNull(project, "Project should be not null");
    }

    public ExecResult mavenexec(Closure<MavenExecSpec> configure) {
        Objects.requireNonNull(configure, "Configure closure should not be null");
        try {
            return this.project.exec(execSpec -> {
                MavenExecSpecDelegate delegate = new MavenExecSpecDelegate((ExecSpec)execSpec, this.project);
                ClosureBackedAction.execute((Object)delegate, (Closure)configure);
                List<String> commandLine = delegate.getCommandLine();
                execSpec.setCommandLine(commandLine);
                this.project.getLogger().info("Execute Maven command: {}", (Object)CollectionUtils.asCommandLine(commandLine));
            }).assertNormalExitValue();
        }
        catch (Exception exception) {
            if (exception.getCause() != null) {
                this.printCauseMessagesWithoutLast(exception, this.project.getLogger());
            }
            throw exception;
        }
    }

    private void printCauseMessagesWithoutLast(final Exception e, Logger logger) {
        Iterator<Throwable> iterator = new Iterator<Throwable>(){
            private Throwable current;
            {
                this.current = e;
            }

            @Override
            public boolean hasNext() {
                return this.current.getCause() != null;
            }

            @Override
            public Throwable next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.current = this.current.getCause();
                return this.current;
            }
        };
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1040), false).filter(exception -> exception.getCause() != null).map(Throwable::getMessage).filter(StringUtils::isNotBlank).forEachOrdered(arg_0 -> ((Logger)logger).warn(arg_0));
    }
}

