/*
 * Decompiled with CFR 0.152.
 */
package com.github.dkorotych.gradle.maven;

import com.github.dkorotych.gradle.maven.DefaultMavenOptions;
import com.github.dkorotych.gradle.maven.MavenOptions;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.GradleException;

public class MavenOptionsToCommandLineAdapter {
    private static final Pattern OPTION_PATTERN = Pattern.compile("(\\p{Upper})");
    private final MavenOptions options;
    private final List<PropertyDescriptor> descriptors;

    public MavenOptionsToCommandLineAdapter(MavenOptions options, Set<String> supportedOptions) {
        this.options = Objects.requireNonNull(options, "Maven options should be not null");
        try {
            Predicate<PropertyDescriptor> predicate = supportedOptions == null ? descriptor -> true : descriptor -> {
                String option = this.createOption(descriptor.getName());
                return supportedOptions.contains(option);
            };
            this.descriptors = Arrays.stream(Introspector.getBeanInfo(DefaultMavenOptions.class, Object.class).getPropertyDescriptors()).filter(predicate).sorted(Comparator.comparing(FeatureDescriptor::getName)).collect(Collectors.toList());
        }
        catch (IntrospectionException e) {
            throw new GradleException("Can't create property descriptions", (Throwable)e);
        }
    }

    public List<String> asCommandLine() {
        ArrayList<String> arguments = new ArrayList<String>();
        for (PropertyDescriptor descriptor : this.descriptors) {
            Method readMethod = descriptor.getReadMethod();
            Class<?> type = descriptor.getPropertyType();
            if (type == Boolean.TYPE) {
                this.addBooleanOption(descriptor, readMethod, arguments);
                continue;
            }
            if (type == String.class) {
                this.addStringOption(descriptor, readMethod, arguments);
                continue;
            }
            if (type == File.class) {
                this.addFileOption(descriptor, readMethod, arguments);
                continue;
            }
            if (type == String[].class) {
                this.addStringArrayOption(descriptor, readMethod, arguments);
                continue;
            }
            if (type == Map.class) {
                this.addMapOption(this.options.getDefine(), arguments);
                continue;
            }
            throw new GradleException("Unsupported option type - " + type);
        }
        return Collections.unmodifiableList(arguments);
    }

    private String createOption(String property) {
        return "--" + OPTION_PATTERN.matcher(property).replaceAll("-$1").toLowerCase(Locale.ENGLISH);
    }

    private void addBooleanOption(PropertyDescriptor descriptor, Method readMethod, List<String> arguments) {
        try {
            if (Boolean.TRUE.equals(readMethod.invoke((Object)this.options, new Object[0]))) {
                arguments.add(this.createOption(descriptor.getName()));
            }
        }
        catch (Exception e) {
            throw new GradleException("Can't convert boolean property to option", (Throwable)e);
        }
    }

    private void addStringOption(PropertyDescriptor descriptor, Method readMethod, List<String> arguments) {
        try {
            String value = (String)readMethod.invoke((Object)this.options, new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.addStringOption(descriptor.getName(), value, arguments);
            }
        }
        catch (Exception e) {
            throw new GradleException("Can't convert string property to option", (Throwable)e);
        }
    }

    private void addStringOption(String property, String value, List<String> arguments) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            arguments.add(this.createOption(property));
            arguments.add(this.doubleQuoteIfNecessary(value));
        }
    }

    private void addFileOption(PropertyDescriptor descriptor, Method readMethod, List<String> arguments) {
        try {
            File value = (File)readMethod.invoke((Object)this.options, new Object[0]);
            if (value != null) {
                this.addStringOption(descriptor.getName(), value.getAbsolutePath(), arguments);
            }
        }
        catch (Exception e) {
            throw new GradleException("Can't convert file property to option", (Throwable)e);
        }
    }

    private void addStringArrayOption(PropertyDescriptor descriptor, Method readMethod, List<String> arguments) {
        try {
            String[] value = (String[])readMethod.invoke((Object)this.options, new Object[0]);
            if (value != null && value.length > 0) {
                String arrayAsString = Arrays.stream(value).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
                this.addStringOption(descriptor.getName(), arrayAsString, arguments);
            }
        }
        catch (Exception e) {
            throw new GradleException("Can't convert string array property to option", (Throwable)e);
        }
    }

    private void addMapOption(Map<String, String> value, List<String> arguments) {
        if (value != null) {
            value.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey())) && StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).map(entry -> "-D" + (String)entry.getKey() + '=' + this.doubleQuoteIfNecessary((String)entry.getValue())).forEach(arguments::add);
        }
    }

    private String doubleQuoteIfNecessary(String value) {
        if (StringUtils.containsWhitespace((CharSequence)value) && !value.startsWith("\"")) {
            return '\"' + value + '\"';
        }
        return value;
    }
}

