/*
 * Decompiled with CFR 0.152.
 */
package com.github.dkorotych.gradle.maven;

import com.github.dkorotych.gradle.maven.IncorrectMavenInstallationDirectoryException;
import com.github.dkorotych.gradle.maven.MavenDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.GradleException;

public class MavenHomeProvider {
    private Path mavenHome;

    public boolean findMavenHome() {
        return this.mavenHome != null || this.tryToSetMavenHome("maven.home", true) || this.tryToSetMavenHome("MAVEN_HOME", false) || this.tryToSetMavenHome("M2_HOME", false);
    }

    public Path getMavenHome() {
        return this.mavenHome;
    }

    public void setMavenHome(File dir) {
        this.mavenHome = Optional.ofNullable(dir).filter(File::exists).map(File::toPath).map(Path::normalize).map(Path::toAbsolutePath).map(Path::toFile).map(file -> {
            String parentName;
            File returnValue = null;
            if (file.isDirectory()) {
                try (Stream<Path> files = Files.find(file.toPath(), 2, (path, basicFileAttributes) -> {
                    File currentFile = path.toFile();
                    return MavenDescriptor.isMavenExecutionFile(currentFile) || MavenDescriptor.isMavenExecutionWrapperFile(currentFile);
                }, FileVisitOption.FOLLOW_LINKS);){
                    Path mavenExecutionFile = files.findFirst().orElse(null);
                    if (mavenExecutionFile == null) return returnValue;
                    this.setMavenHome(mavenExecutionFile);
                    returnValue = Optional.ofNullable(this.getMavenHome()).map(Path::toFile).orElse(null);
                    return returnValue;
                }
                catch (IOException e) {
                    throw new GradleException("Can't find Maven execution file", (Throwable)e);
                }
            }
            if (MavenDescriptor.isMavenExecutionFile(file) && "bin".equals(parentName = (String)Optional.of(file).map(File::getParentFile).map(File::getName).orElse(null))) {
                returnValue = Optional.of(file).map(File::getParentFile).map(File::getParentFile).orElse(null);
            }
            if (!MavenDescriptor.isMavenExecutionWrapperFile(file)) return returnValue;
            return Optional.of(file).map(File::getParentFile).orElse(null);
        }).orElseThrow(() -> new IncorrectMavenInstallationDirectoryException(dir)).toPath().normalize().toAbsolutePath();
    }

    public void setMavenHome(String path) {
        File directory = Optional.ofNullable(path).map(String::trim).filter(((Predicate<String>)String::isEmpty).negate()).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toFile).orElse(null);
        this.setMavenHome(directory);
    }

    public void setMavenHome(Path path) {
        File directory = Optional.ofNullable(path).map(Path::toFile).orElse(null);
        this.setMavenHome(directory);
    }

    private boolean tryToSetMavenHome(String name, boolean property) {
        try {
            String path = Optional.ofNullable(name).filter(StringUtils::isNotBlank).map(s -> property ? System.getProperty(name) : System.getenv(name)).orElse(null);
            if (StringUtils.isNotBlank((CharSequence)path)) {
                this.setMavenHome(path);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

