/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.config.Config;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputHandler {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SEPARATOR = "_";
    public static final String DATE_FORMAT = "yyyy.MM.dd_HH.mm.ss.SSS";
    public static final String BASE64_KEY = "base64";
    public static final String PNG_KEY = "png";
    public static final String BASE64_AND_PNG_KEY = "base64andpng";
    public static final String SUREFIRE_REPORTS_KEY = "surefire-reports";
    public static final String SUREFIRE_REPORTS_FOLDER = "./target/surefire-reports/";
    ExtensionContext extensionContext;
    Config config;
    Parameter parameter;

    public OutputHandler(ExtensionContext extensionContext, Config config, Parameter parameter) {
        this.extensionContext = extensionContext;
        this.config = config;
        this.parameter = parameter;
    }

    public File getScreenshotFile(WebDriver driver) {
        String outputFolder = this.getOutputFolder();
        String fileName = this.getOutputFileName(driver);
        return new File(outputFolder, fileName + ".png");
    }

    public String getPrefix() {
        Object prefix = "";
        Optional testMethod = this.extensionContext.getTestMethod();
        if (testMethod.isPresent()) {
            prefix = ((Method)testMethod.get()).getName() + SEPARATOR;
        } else {
            Optional testClass = this.extensionContext.getTestClass();
            if (testClass.isPresent()) {
                prefix = ((Class)testClass.get()).getSimpleName() + SEPARATOR;
            }
        }
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        prefix = (String)prefix + this.parameter.getName() + SEPARATOR + dateFormat.format(now) + SEPARATOR;
        return prefix;
    }

    public String getOutputFileName(WebDriver driver) {
        Object name = this.getPrefix();
        Class<?> driverClass = driver.getClass();
        if (RemoteWebDriver.class.isAssignableFrom(driverClass)) {
            name = (String)name + ((RemoteWebDriver)driver).getCapabilities().getBrowserName().toLowerCase(Locale.ROOT) + SEPARATOR + ((RemoteWebDriver)driver).getSessionId();
        }
        return name;
    }

    public String getOutputFolder() {
        String outputFolder = this.config.getOutputFolder();
        Optional testMethod = this.extensionContext.getTestMethod();
        Optional testInstance = this.extensionContext.getTestClass();
        if (testMethod.isPresent() && testInstance.isPresent()) {
            Class testClass = (Class)testInstance.get();
            if (outputFolder.equalsIgnoreCase(SUREFIRE_REPORTS_KEY)) {
                outputFolder = this.getClassSpecificOutputFolder(SUREFIRE_REPORTS_FOLDER, testClass);
            } else {
                if (outputFolder.isEmpty()) {
                    outputFolder = ".";
                }
                if (this.config.isOutputFolderPerClass()) {
                    outputFolder = this.getClassSpecificOutputFolder(outputFolder, testClass);
                }
            }
        }
        log.trace("Output folder {}", (Object)outputFolder);
        File outputFolderFile = new File(outputFolder);
        if (!outputFolderFile.exists()) {
            outputFolderFile.mkdirs();
        }
        return outputFolder;
    }

    private String getClassSpecificOutputFolder(String baseFolder, Class<?> testClass) {
        String testClassName = testClass.getName();
        StringBuilder stringBuilder = new StringBuilder(baseFolder);
        if (!baseFolder.endsWith(File.separator)) {
            stringBuilder.append(File.separator);
        }
        stringBuilder.append(testClassName);
        return stringBuilder.toString();
    }
}

