/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer.excel;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jsoup.nodes.Element;
import uk.co.certait.htmlexporter.css.StyleMap;
import uk.co.certait.htmlexporter.writer.AbstractExporter;
import uk.co.certait.htmlexporter.writer.excel.ExcelTableCellWriter;
import uk.co.certait.htmlexporter.writer.excel.ExcelTableRowWriter;
import uk.co.certait.htmlexporter.writer.excel.ExcelTableWriter;

public class ExcelExporter
extends AbstractExporter {
    @Override
    public void exportHtml(String html, OutputStream out) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        StyleMap styleMapper = this.getStyleMapper(html);
        Sheet sheet = null;
        int startRow = 0;
        for (Element element : this.getTables(html)) {
            String sheetName;
            if (workbook.getNumberOfSheets() == 0) {
                sheetName = this.getSheetName(element);
                sheet = StringUtils.isNotEmpty((CharSequence)sheetName) ? workbook.createSheet(sheetName) : workbook.createSheet();
            } else if (this.isNewSheet(element)) {
                sheetName = this.getSheetName(element);
                sheet = StringUtils.isNotEmpty((CharSequence)sheetName) ? workbook.createSheet(sheetName) : workbook.createSheet();
                startRow = 0;
            }
            ExcelTableWriter writer = new ExcelTableWriter(new ExcelTableRowWriter(sheet, new ExcelTableCellWriter(sheet, styleMapper)));
            startRow += writer.writeTable(element, styleMapper, startRow) + 1;
            sheet.createRow(startRow);
        }
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            this.formatSheet(workbook.getSheetAt(i));
        }
        workbook.write(out);
        out.flush();
        out.close();
        workbook.close();
    }

    protected void formatSheet(Sheet sheet) {
        int i;
        int lastRowWithData = 0;
        for (i = sheet.getLastRowNum(); i >= 0; --i) {
            if (sheet.getRow(i) == null || sheet.getRow(i).getPhysicalNumberOfCells() <= 0) continue;
            lastRowWithData = i;
            break;
        }
        for (i = 0; i < sheet.getRow(lastRowWithData).getPhysicalNumberOfCells(); ++i) {
            sheet.autoSizeColumn(i);
        }
        for (i = 0; i < sheet.getRow(sheet.getLastRowNum()).getPhysicalNumberOfCells(); ++i) {
            sheet.setColumnWidth(i, (int)((double)sheet.getColumnWidth(i) * 1.2));
        }
    }
}

