/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer.ods;

import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.table.Cell;
import uk.co.certait.htmlexporter.css.CssColorProperty;
import uk.co.certait.htmlexporter.css.CssIntegerProperty;
import uk.co.certait.htmlexporter.css.CssStringProperty;
import uk.co.certait.htmlexporter.css.Style;

public class OdsStyleGenerator {
    public void styleCell(Cell cell, Style style) {
        if (style.isBackgroundSet()) {
            cell.setCellBackgroundColor(new Color(style.getProperty(CssColorProperty.BACKGROUND_COLOR).get()));
        }
        this.applyBorder(cell, style);
        this.applyHorizontalAlignment(cell, style);
        this.applyVerticalAlignment(cell, style);
        this.applyFont(cell, style);
    }

    protected void applyBorder(Cell cell, Style style) {
    }

    protected void applyHorizontalAlignment(Cell cell, Style style) {
        if (style.isHorizontallyAlignedLeft()) {
            cell.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.LEFT);
        } else if (style.isHorizontallyAlignedRight()) {
            cell.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.RIGHT);
        } else if (style.isHorizontallyAlignedCenter()) {
            cell.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
        }
    }

    protected void applyVerticalAlignment(Cell cell, Style style) {
        if (style.isVerticallyAlignedTop()) {
            cell.setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType.TOP);
        } else if (style.isVerticallyAlignedBottom()) {
            cell.setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType.BOTTOM);
        } else if (style.isVerticallyAlignedMiddle()) {
            cell.setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType.MIDDLE);
        }
    }

    protected void applyFont(Cell cell, Style style) {
        Font font = cell.getFont();
        if (style.isFontNameSet()) {
            font.setFamilyName(style.getProperty(CssStringProperty.FONT_FAMILY).get());
        }
        if (style.isFontBold() && style.isFontItalic()) {
            font.setFontStyle(StyleTypeDefinitions.FontStyle.BOLDITALIC);
        } else if (style.isFontBold()) {
            font.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        } else if (style.isFontItalic()) {
            font.setFontStyle(StyleTypeDefinitions.FontStyle.ITALIC);
        }
        if (style.isFontSizeSet()) {
            font.setSize((double)style.getProperty(CssIntegerProperty.FONT_SIZE).get().intValue());
        }
        if (style.isColorSet()) {
            font.setColor(new Color(style.getProperty(CssColorProperty.COLOR).get()));
        }
        cell.setFont(font);
    }
}

