/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash;

import io.getunleash.ActivationStrategy;
import io.getunleash.EvaluatedToggle;
import io.getunleash.FeatureEvaluationResult;
import io.getunleash.FeatureToggle;
import io.getunleash.MoreOperations;
import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.UnleashContextProvider;
import io.getunleash.Variant;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.IsEnabledImpressionEvent;
import io.getunleash.event.ToggleEvaluated;
import io.getunleash.event.VariantImpressionEvent;
import io.getunleash.lang.Nullable;
import io.getunleash.metric.UnleashMetricService;
import io.getunleash.metric.UnleashMetricServiceImpl;
import io.getunleash.repository.FeatureRepository;
import io.getunleash.repository.IFeatureRepository;
import io.getunleash.strategy.ApplicationHostnameStrategy;
import io.getunleash.strategy.DefaultStrategy;
import io.getunleash.strategy.FlexibleRolloutStrategy;
import io.getunleash.strategy.GradualRolloutRandomStrategy;
import io.getunleash.strategy.GradualRolloutSessionIdStrategy;
import io.getunleash.strategy.GradualRolloutUserIdStrategy;
import io.getunleash.strategy.RemoteAddressStrategy;
import io.getunleash.strategy.Strategy;
import io.getunleash.strategy.UnknownStrategy;
import io.getunleash.strategy.UserWithIdStrategy;
import io.getunleash.util.ConstraintMerger;
import io.getunleash.util.UnleashConfig;
import io.getunleash.variant.VariantUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnleash
implements Unleash {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUnleash.class);
    private static ConcurrentHashMap<String, LongAdder> initCounts = new ConcurrentHashMap();
    private static final List<Strategy> BUILTIN_STRATEGIES = Arrays.asList(new DefaultStrategy(), new ApplicationHostnameStrategy(), new GradualRolloutRandomStrategy(), new GradualRolloutSessionIdStrategy(), new GradualRolloutUserIdStrategy(), new RemoteAddressStrategy(), new UserWithIdStrategy(), new FlexibleRolloutStrategy());
    public static final UnknownStrategy UNKNOWN_STRATEGY = new UnknownStrategy();
    private final UnleashMetricService metricService;
    private final IFeatureRepository featureRepository;
    private final Map<String, Strategy> strategyMap;
    private final UnleashContextProvider contextProvider;
    private final EventDispatcher eventDispatcher;
    private final UnleashConfig config;

    private static IFeatureRepository defaultToggleRepository(UnleashConfig unleashConfig) {
        return new FeatureRepository(unleashConfig);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, Strategy ... strategies) {
        this(unleashConfig, DefaultUnleash.defaultToggleRepository(unleashConfig), strategies);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, IFeatureRepository featureRepository, Strategy ... strategies) {
        this(unleashConfig, featureRepository, DefaultUnleash.buildStrategyMap(strategies), unleashConfig.getContextProvider(), new EventDispatcher(unleashConfig), new UnleashMetricServiceImpl(unleashConfig, unleashConfig.getScheduledExecutor()), false);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, IFeatureRepository featureRepository, Map<String, Strategy> strategyMap, UnleashContextProvider contextProvider, EventDispatcher eventDispatcher, UnleashMetricService metricService) {
        this(unleashConfig, featureRepository, strategyMap, contextProvider, eventDispatcher, metricService, false);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, IFeatureRepository featureRepository, Map<String, Strategy> strategyMap, UnleashContextProvider contextProvider, EventDispatcher eventDispatcher, UnleashMetricService metricService, boolean failOnMultipleInstantiations) {
        this.config = unleashConfig;
        this.featureRepository = featureRepository;
        this.strategyMap = strategyMap;
        this.contextProvider = contextProvider;
        this.eventDispatcher = eventDispatcher;
        this.metricService = metricService;
        metricService.register(strategyMap.keySet());
        initCounts.compute(this.config.getClientIdentifier(), (key, inits) -> {
            if (inits != null) {
                String error = String.format("You already have %d clients for AppName [%s] with instanceId: [%s] running. Please double check your code where you are instantiating the Unleash SDK", inits.sum(), unleashConfig.getAppName(), unleashConfig.getInstanceId());
                if (failOnMultipleInstantiations) {
                    throw new RuntimeException(error);
                }
                LOGGER.error(error);
            }
            LongAdder a = inits == null ? new LongAdder() : inits;
            a.increment();
            return a;
        });
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, BiPredicate<String, UnleashContext> fallbackAction) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), fallbackAction);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction) {
        return this.isEnabled(toggleName, context, fallbackAction, false);
    }

    public boolean isEnabled(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction, boolean isParent) {
        FeatureEvaluationResult result = this.getFeatureEvaluationResult(toggleName, context, fallbackAction, null);
        if (!isParent) {
            this.count(toggleName, result.isEnabled());
        }
        this.eventDispatcher.dispatch(new ToggleEvaluated(toggleName, result.isEnabled()));
        this.dispatchEnabledImpressionDataIfNeeded("isEnabled", toggleName, result.isEnabled(), context);
        return result.isEnabled();
    }

    private void dispatchEnabledImpressionDataIfNeeded(String eventType, String toggleName, boolean enabled, UnleashContext context) {
        FeatureToggle toggle = this.featureRepository.getToggle(toggleName);
        if (toggle != null && toggle.hasImpressionData()) {
            this.eventDispatcher.dispatch(new IsEnabledImpressionEvent(toggleName, enabled, context));
        }
    }

    private FeatureEvaluationResult getFeatureEvaluationResult(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction, @Nullable Variant defaultVariant) {
        this.checkIfToggleMatchesNamePrefix(toggleName);
        FeatureToggle featureToggle = this.featureRepository.getToggle(toggleName);
        UnleashContext enhancedContext = context.applyStaticFields(this.config);
        if (featureToggle == null) {
            return new FeatureEvaluationResult(fallbackAction.test(toggleName, enhancedContext), defaultVariant);
        }
        if (!featureToggle.isEnabled()) {
            return new FeatureEvaluationResult(false, defaultVariant);
        }
        if (this.isParentDependencySatisfied(featureToggle, context, fallbackAction)) {
            if (featureToggle.getStrategies().isEmpty()) {
                return new FeatureEvaluationResult(true, VariantUtil.selectVariant(featureToggle, context, defaultVariant));
            }
            for (ActivationStrategy strategy : featureToggle.getStrategies()) {
                FeatureEvaluationResult result;
                Strategy configuredStrategy = this.getStrategy(strategy.getName());
                if (configuredStrategy == UNKNOWN_STRATEGY) {
                    LOGGER.warn("Unable to find matching strategy for toggle:{} strategy:{}", (Object)toggleName, (Object)strategy.getName());
                }
                if (!(result = configuredStrategy.getResult(strategy.getParameters(), enhancedContext, ConstraintMerger.mergeConstraints(this.featureRepository, strategy), strategy.getVariants())).isEnabled()) continue;
                Variant variant = result.getVariant();
                if (variant == null) {
                    variant = VariantUtil.selectVariant(featureToggle, context, defaultVariant);
                }
                result.setVariant(variant);
                return result;
            }
        }
        return new FeatureEvaluationResult(false, defaultVariant);
    }

    private FeatureEvaluationResult deprecatedGetFeatureEvaluationResult(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction, @Nullable Variant defaultVariant) {
        this.checkIfToggleMatchesNamePrefix(toggleName);
        FeatureToggle featureToggle = this.featureRepository.getToggle(toggleName);
        UnleashContext enhancedContext = context.applyStaticFields(this.config);
        if (featureToggle == null) {
            return new FeatureEvaluationResult(fallbackAction.test(toggleName, enhancedContext), defaultVariant);
        }
        if (!featureToggle.isEnabled()) {
            return new FeatureEvaluationResult(false, defaultVariant);
        }
        if (this.isParentDependencySatisfied(featureToggle, context, fallbackAction)) {
            if (featureToggle.getStrategies().isEmpty()) {
                return new FeatureEvaluationResult(true, VariantUtil.selectDeprecatedVariantHashingAlgo(featureToggle, context, defaultVariant));
            }
            for (ActivationStrategy strategy : featureToggle.getStrategies()) {
                FeatureEvaluationResult result;
                Strategy configuredStrategy = this.getStrategy(strategy.getName());
                if (configuredStrategy == UNKNOWN_STRATEGY) {
                    LOGGER.warn("Unable to find matching strategy for toggle:{} strategy:{}", (Object)toggleName, (Object)strategy.getName());
                }
                if (!(result = configuredStrategy.getDeprecatedHashingAlgoResult(strategy.getParameters(), enhancedContext, ConstraintMerger.mergeConstraints(this.featureRepository, strategy), strategy.getVariants())).isEnabled()) continue;
                Variant variant = result.getVariant();
                if (variant == null) {
                    variant = VariantUtil.selectDeprecatedVariantHashingAlgo(featureToggle, context, defaultVariant);
                }
                result.setVariant(variant);
                return result;
            }
        }
        return new FeatureEvaluationResult(false, defaultVariant);
    }

    private boolean isParentDependencySatisfied(@Nonnull FeatureToggle featureToggle, @Nonnull UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction) {
        if (!featureToggle.hasDependencies()) {
            return true;
        }
        return featureToggle.getDependencies().stream().allMatch(parent -> {
            FeatureToggle parentToggle = this.featureRepository.getToggle(parent.getFeature());
            if (parentToggle == null) {
                LOGGER.warn("Missing dependency [{}] for toggle: [{}]", (Object)parent.getFeature(), (Object)featureToggle.getName());
                return false;
            }
            if (!parentToggle.getDependencies().isEmpty()) {
                LOGGER.warn("[{}] depends on feature [{}] which also depends on something. We don't currently support more than one level of dependency resolution", (Object)featureToggle.getName(), (Object)parent.getFeature());
                return false;
            }
            boolean parentSatisfied = this.isEnabled(parent.getFeature(), context, fallbackAction, true);
            if (parentSatisfied) {
                if (!parent.getVariants().isEmpty()) {
                    return parent.getVariants().contains(this.getVariant(parent.feature, context, Variant.DISABLED_VARIANT, true).getName());
                }
                return parent.isEnabled();
            }
            return !parent.isEnabled();
        });
    }

    private void checkIfToggleMatchesNamePrefix(String toggleName) {
        if (this.config.getNamePrefix() != null && !toggleName.startsWith(this.config.getNamePrefix())) {
            LOGGER.warn("Toggle [{}] doesnt start with configured name prefix of [{}] so it will always be disabled", (Object)toggleName, (Object)this.config.getNamePrefix());
        }
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, context, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        return this.getVariant(toggleName, context, defaultValue, false);
    }

    private Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue, boolean isParent) {
        FeatureEvaluationResult result = this.getFeatureEvaluationResult(toggleName, context, (n, c) -> false, defaultValue);
        Variant variant = result.getVariant();
        if (!isParent) {
            this.metricService.countVariant(toggleName, variant.getName());
            this.metricService.count(toggleName, result.isEnabled());
        }
        this.dispatchVariantImpressionDataIfNeeded(toggleName, variant.getName(), result.isEnabled(), context);
        return variant;
    }

    private void dispatchVariantImpressionDataIfNeeded(String toggleName, String variantName, boolean enabled, UnleashContext context) {
        FeatureToggle toggle = this.featureRepository.getToggle(toggleName);
        if (toggle != null && toggle.hasImpressionData()) {
            this.eventDispatcher.dispatch(new VariantImpressionEvent(toggleName, enabled, context, variantName));
        }
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, this.contextProvider.getContext());
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        return this.getVariant(toggleName, this.contextProvider.getContext(), defaultValue);
    }

    @Override
    public Variant deprecatedGetVariant(String toggleName, UnleashContext context) {
        return this.deprecatedGetVariant(toggleName, context, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant deprecatedGetVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        return this.deprecatedGetVariant(toggleName, context, defaultValue, false);
    }

    private Variant deprecatedGetVariant(String toggleName, UnleashContext context, Variant defaultValue, boolean isParent) {
        FeatureEvaluationResult result = this.deprecatedGetFeatureEvaluationResult(toggleName, context, (n, c) -> false, defaultValue);
        Variant variant = result.getVariant();
        if (!isParent) {
            this.metricService.countVariant(toggleName, variant.getName());
            this.metricService.count(toggleName, result.isEnabled());
        }
        this.dispatchVariantImpressionDataIfNeeded(toggleName, variant.getName(), result.isEnabled(), context);
        return variant;
    }

    @Override
    public Variant deprecatedGetVariant(String toggleName) {
        return this.deprecatedGetVariant(toggleName, this.contextProvider.getContext());
    }

    @Override
    public Variant deprecatedGetVariant(String toggleName, Variant defaultValue) {
        return this.deprecatedGetVariant(toggleName, this.contextProvider.getContext(), defaultValue);
    }

    @Deprecated
    public Optional<FeatureToggle> getFeatureToggleDefinition(String toggleName) {
        return Optional.ofNullable(this.featureRepository.getToggle(toggleName));
    }

    @Override
    @Deprecated
    public List<String> getFeatureToggleNames() {
        return this.featureRepository.getFeatureNames();
    }

    @Deprecated
    public void count(String toggleName, boolean enabled) {
        this.metricService.count(toggleName, enabled);
    }

    private static Map<String, Strategy> buildStrategyMap(@Nullable Strategy[] strategies) {
        HashMap<String, Strategy> map = new HashMap<String, Strategy>();
        BUILTIN_STRATEGIES.forEach(strategy -> map.put(strategy.getName(), (Strategy)strategy));
        if (strategies != null) {
            for (Strategy strategy2 : strategies) {
                map.put(strategy2.getName(), strategy2);
            }
        }
        return map;
    }

    private Strategy getStrategy(String strategy) {
        return this.strategyMap.getOrDefault(strategy, this.config.getFallbackStrategy());
    }

    @Override
    public void shutdown() {
        this.config.getScheduledExecutor().shutdown();
    }

    @Override
    public MoreOperations more() {
        return new DefaultMore();
    }

    public class DefaultMore
    implements MoreOperations {
        @Override
        public List<String> getFeatureToggleNames() {
            return DefaultUnleash.this.featureRepository.getFeatureNames();
        }

        @Override
        public Optional<FeatureToggle> getFeatureToggleDefinition(String toggleName) {
            return Optional.ofNullable(DefaultUnleash.this.featureRepository.getToggle(toggleName));
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles() {
            return this.evaluateAllToggles(DefaultUnleash.this.contextProvider.getContext());
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles(UnleashContext context) {
            return this.getFeatureToggleNames().stream().map(toggleName -> {
                FeatureEvaluationResult result = DefaultUnleash.this.getFeatureEvaluationResult(toggleName, context, (n, c) -> false, null);
                return new EvaluatedToggle((String)toggleName, result.isEnabled(), result.getVariant());
            }).collect(Collectors.toList());
        }

        @Override
        public void count(String toggleName, boolean enabled) {
            DefaultUnleash.this.metricService.count(toggleName, enabled);
        }

        @Override
        public void countVariant(String toggleName, String variantName) {
            DefaultUnleash.this.metricService.countVariant(toggleName, variantName);
        }
    }
}

