/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyInfo;
import android.security.keystore.StrongBoxUnavailableException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import io.getlime.security.powerauth.system.PA2Log;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

@RequiresApi(api=23)
public class SymmetricKeyProvider {
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    @NonNull
    private final KeyStore keyStore;
    @NonNull
    private final String keyAlias;
    @NonNull
    private final OnGenerateKey onGenerateKey;

    @Nullable
    public static SymmetricKeyProvider getSymmetricKeyProvider(@NonNull String keyAlias, @NonNull OnGenerateKey onGenerateKey) {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
            keyStore.load(null);
            return new SymmetricKeyProvider(keyStore, keyAlias, onGenerateKey);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            PA2Log.e("SymmetricKeyProvider: " + keyAlias + ": Unable to initialize Android KeyStore. Exception: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Nullable
    public static SymmetricKeyProvider getAesGcmKeyProvider(@NonNull String keyAlias, final int keySize, final boolean randomizedEncryption, final @Nullable OnGenerateKey onGenerateKey) {
        return SymmetricKeyProvider.getSymmetricKeyProvider(keyAlias, new OnGenerateKey(){

            @Override
            public void configureBuilder(@NonNull KeyGenParameterSpec.Builder builder) {
                builder.setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setRandomizedEncryptionRequired(randomizedEncryption);
                if (keySize != 0) {
                    builder.setKeySize(keySize);
                }
                if (onGenerateKey != null) {
                    onGenerateKey.configureBuilder(builder);
                }
            }
        });
    }

    @Nullable
    public static SymmetricKeyProvider getAesCbcKeyProvider(@NonNull String keyAlias, final int keySize, final boolean randomizedEncryption, final @Nullable OnGenerateKey onGenerateKey) {
        return SymmetricKeyProvider.getSymmetricKeyProvider(keyAlias, new OnGenerateKey(){

            @Override
            public void configureBuilder(@NonNull KeyGenParameterSpec.Builder builder) {
                builder.setBlockModes(new String[]{"CBC"}).setEncryptionPaddings(new String[]{"PKCS7Padding"}).setRandomizedEncryptionRequired(randomizedEncryption);
                if (keySize != 0) {
                    builder.setKeySize(keySize);
                }
                if (onGenerateKey != null) {
                    onGenerateKey.configureBuilder(builder);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SecretKey getOrCreateSecretKey(@NonNull Context context, boolean forceCreateOnFailure) {
        Class<SymmetricKeyProvider> clazz = SymmetricKeyProvider.class;
        synchronized (SymmetricKeyProvider.class) {
            if (this.hasSecretKey()) {
                try {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (SecretKey)this.keyStore.getKey(this.keyAlias, null);
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    PA2Log.e("SymmetricKeyProvider: " + this.keyAlias + "Failed to get key. Exception: " + e.getMessage(), new Object[0]);
                    if (!forceCreateOnFailure) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return null;
                    }
                    this.removeSecretKey();
                }
            }
            SecretKey newSecretKey = Build.VERSION.SDK_INT >= 28 ? (this.isStrongBoxSupported(context) ? this.generateStrongBoxSecretKey(context) : this.generateSecretKey()) : this.generateSecretKey();
            if (newSecretKey != null) {
                KeyInfo newKeyInfo = this.getKeyInfoForSecretKey(newSecretKey);
                PA2Log.d("SymmetricKeyProvider: " + this.keyAlias + ": Created key with attributes: " + this.getSecretKeyAttributes(newKeyInfo), new Object[0]);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return newSecretKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSecretKey() {
        Class<SymmetricKeyProvider> clazz = SymmetricKeyProvider.class;
        synchronized (SymmetricKeyProvider.class) {
            if (this.hasSecretKey()) {
                this.removeSecretKey();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSecretKey() {
        Class<SymmetricKeyProvider> clazz = SymmetricKeyProvider.class;
        synchronized (SymmetricKeyProvider.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.hasSecretKey();
        }
    }

    @NonNull
    public String getKeyAlias() {
        return this.keyAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public KeyInfo getSecretKeyInfo(@NonNull Context context) {
        Class<SymmetricKeyProvider> clazz = SymmetricKeyProvider.class;
        synchronized (SymmetricKeyProvider.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.getKeyInfoForSecretKey(this.getOrCreateSecretKey(context, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public KeyInfo dumpSecretKeyInfo(@NonNull Context context) {
        Class<SymmetricKeyProvider> clazz = SymmetricKeyProvider.class;
        synchronized (SymmetricKeyProvider.class) {
            if (this.hasSecretKey()) {
                SecretKey secretKey = this.getOrCreateSecretKey(context, false);
                KeyInfo secretKeyInfo = this.getKeyInfoForSecretKey(secretKey);
                if (secretKey != null) {
                    PA2Log.d("SymmetricKeyProvider.dumpSecretKeyInfo: " + this.keyAlias + ": Key is available and has attributes: " + this.getSecretKeyAttributes(secretKeyInfo), new Object[0]);
                } else {
                    PA2Log.d("SymmetricKeyProvider.dumpSecretKeyInfo: " + this.keyAlias + ": Failed to get key.", new Object[0]);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return secretKeyInfo;
            }
            PA2Log.d("SymmetricKeyProvider.dumpSecretKeyInfo: " + this.keyAlias + ": Key is not created yet.", new Object[0]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    private SymmetricKeyProvider(@NonNull KeyStore keyStore, @NonNull String keyAlias, @NonNull OnGenerateKey onGenerateKey) {
        this.keyStore = keyStore;
        this.keyAlias = keyAlias;
        this.onGenerateKey = onGenerateKey;
    }

    @Nullable
    private KeyInfo getKeyInfoForSecretKey(@Nullable SecretKey secretKey) {
        try {
            if (secretKey == null) {
                return null;
            }
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(secretKey.getAlgorithm(), ANDROID_KEY_STORE);
            return (KeyInfo)keyFactory.getKeySpec(secretKey, KeyInfo.class);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            PA2Log.e("SymmetricKeyProvider: " + this.keyAlias + ": Failed to acquire KeyInfo: Exception: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @NonNull
    private String getSecretKeyAttributes(@Nullable KeyInfo keyInfo) {
        if (keyInfo == null) {
            return "N/A";
        }
        ArrayList<String> attrs = new ArrayList<String>();
        if (keyInfo.isInsideSecureHardware()) {
            attrs.add("secure-hw");
        }
        if (Build.VERSION.SDK_INT >= 24 && keyInfo.isInvalidatedByBiometricEnrollment()) {
            attrs.add("inv-by-bio-enrollment");
        }
        if (keyInfo.isUserAuthenticationRequired()) {
            attrs.add("user-auth-required");
        }
        if (Build.VERSION.SDK_INT >= 28 && keyInfo.isUserConfirmationRequired()) {
            attrs.add("user-conf-required");
        }
        if (attrs.isEmpty()) {
            return "none";
        }
        return TextUtils.join((CharSequence)", ", attrs);
    }

    @Nullable
    @RequiresApi(api=28)
    private SecretKey generateStrongBoxSecretKey(@NonNull Context context) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", ANDROID_KEY_STORE);
            keyGenerator.init((AlgorithmParameterSpec)this.getSecretKeySpecBuilder().setIsStrongBoxBacked(true).build());
            return keyGenerator.generateKey();
        }
        catch (StrongBoxUnavailableException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            PA2Log.d("SymmetricKeyProvider: " + this.keyAlias + ": Failed to generate new StrongBox backed key. Exception: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @RequiresApi(api=28)
    private boolean isStrongBoxSupported(@NonNull Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.strongbox_keystore");
    }

    @Nullable
    private SecretKey generateSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", ANDROID_KEY_STORE);
            keyGenerator.init((AlgorithmParameterSpec)this.getSecretKeySpecBuilder().build());
            return keyGenerator.generateKey();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            PA2Log.e("SymmetricKeyProvider: " + this.keyAlias + ": Failed to generate new key. Exception: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @NonNull
    private KeyGenParameterSpec.Builder getSecretKeySpecBuilder() {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.keyAlias, 3);
        this.onGenerateKey.configureBuilder(builder);
        return builder;
    }

    private boolean hasSecretKey() {
        try {
            return this.keyStore.containsAlias(this.keyAlias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    private void removeSecretKey() {
        try {
            this.keyStore.deleteEntry(this.keyAlias);
            PA2Log.d("SymmetricKeyProvider: " + this.keyAlias + ": Key has been deleted.", new Object[0]);
        }
        catch (KeyStoreException e) {
            PA2Log.e("SymmetricKeyProvider: " + this.keyAlias + ": Failed to remove secret key. Exception: " + e.getMessage(), new Object[0]);
        }
    }

    public static interface OnGenerateKey {
        public void configureBuilder(@NonNull KeyGenParameterSpec.Builder var1);
    }
}

