/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry;

import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import io.getlime.security.powerauth.R;

public class BiometricDialogResources {
    @NonNull
    public final Strings strings;
    @NonNull
    public final Drawables drawables;
    @NonNull
    public final Colors colors;
    @NonNull
    public final Layout layout;
    private static final int PACK_STRINGS_OFFSET = 0;
    private static final int PACK_DRAWABLES_OFFSET = 18;
    private static final int PACK_COLORS_OFFSET = 21;
    private static final int PACK_LAYOUT_OFFSET = 27;
    private static final int PACK_DATA_COUNT = 31;

    private BiometricDialogResources(@NonNull Strings strings, @NonNull Drawables drawables, @NonNull Colors colors, @NonNull Layout layout2) {
        this.layout = layout2;
        this.strings = strings;
        this.colors = colors;
        this.drawables = drawables;
    }

    @NonNull
    public int[] packResources() {
        int[] array2 = new int[31];
        this.strings.packTo(array2, 0);
        this.drawables.packTo(array2, 18);
        this.colors.packTo(array2, 21);
        this.layout.packTo(array2, 27);
        return array2;
    }

    @NonNull
    public static BiometricDialogResources unpackResources(int[] array2) {
        if (array2 == null) {
            throw new IllegalArgumentException("array must not be null");
        }
        if (array2.length != 31) {
            throw new IllegalArgumentException("array has unexpected size.");
        }
        return new BiometricDialogResources(Strings.unpackFrom(array2, 0), Drawables.unpackFrom(array2, 18), Colors.unpackFrom(array2, 21), Layout.unpackFrom(array2, 27));
    }

    public static class Layout {
        static final int RESOURCES_COUNT = 4;
        @LayoutRes
        public final int dialogLayout;
        @IdRes
        public final int statusImageView;
        @IdRes
        public final int statusTextView;
        @IdRes
        public final int descriptionTextView;

        public Layout(@LayoutRes int dialogLayout, @IdRes int statusImageView, @IdRes int statusTextView, @IdRes int descriptionTextView) {
            this.dialogLayout = dialogLayout;
            this.statusImageView = statusImageView;
            this.statusTextView = statusTextView;
            this.descriptionTextView = descriptionTextView;
        }

        @NonNull
        public static Layout getDefaultLayout() {
            return new Layout(R.layout.dialog_fingerprint_login, R.id.fingerprint_icon, R.id.fingerprint_status, R.id.fingerprint_description);
        }

        void packTo(@NonNull int[] array2, int offset) {
            array2[offset] = this.dialogLayout;
            array2[offset + 1] = this.statusImageView;
            array2[offset + 2] = this.statusTextView;
            array2[offset + 3] = this.descriptionTextView;
        }

        @NonNull
        static Layout unpackFrom(@NonNull int[] array2, int offset) {
            return new Layout(array2[offset], array2[offset + 1], array2[offset + 2], array2[offset + 3]);
        }
    }

    public static class Colors {
        static final int RESOURCES_COUNT = 6;
        @ColorRes
        public final int background;
        @ColorRes
        public final int primaryText;
        @ColorRes
        public final int secondaryText;
        @ColorRes
        public final int successText;
        @ColorRes
        public final int failureText;
        @ColorRes
        public final int closeButtonText;

        public Colors(@ColorRes int background, @ColorRes int primaryText, @ColorRes int secondaryText, @ColorRes int successText, @ColorRes int failureText, @ColorRes int closeButtonText) {
            this.background = background;
            this.primaryText = primaryText;
            this.secondaryText = secondaryText;
            this.successText = successText;
            this.failureText = failureText;
            this.closeButtonText = closeButtonText;
        }

        @NonNull
        public static Colors getDefaultColors() {
            return new Colors(R.color.color_fingerprint_dialog_background, R.color.color_fingerprint_text_primary, R.color.color_fingerprint_text_secondary, R.color.color_fingerprint_success_text, R.color.color_fingerprint_failure_text, R.color.color_fingerprint_close_button);
        }

        void packTo(@NonNull int[] array2, int offset) {
            array2[offset] = this.background;
            array2[offset + 1] = this.primaryText;
            array2[offset + 2] = this.secondaryText;
            array2[offset + 3] = this.successText;
            array2[offset + 4] = this.failureText;
            array2[offset + 5] = this.closeButtonText;
        }

        @NonNull
        static Colors unpackFrom(@NonNull int[] array2, int offset) {
            return new Colors(array2[offset], array2[offset + 1], array2[offset + 2], array2[offset + 3], array2[offset + 4], array2[offset + 5]);
        }
    }

    public static class Drawables {
        static final int RESOURCES_COUNT = 3;
        @DrawableRes
        public final int fingerprintIcon;
        @DrawableRes
        public final int errorIcon;
        @DrawableRes
        public final int successIcon;

        public Drawables(@DrawableRes int fingerprintIcon, @DrawableRes int errorIcon, @DrawableRes int successIcon) {
            this.fingerprintIcon = fingerprintIcon;
            this.errorIcon = errorIcon;
            this.successIcon = successIcon;
        }

        @NonNull
        public static Drawables getDefaultDrawables() {
            return new Drawables(R.drawable.ic_fingerprint_default, R.drawable.ic_fingerprint_error, R.drawable.ic_fingerprint_success);
        }

        void packTo(@NonNull int[] array2, int offset) {
            array2[offset] = this.fingerprintIcon;
            array2[offset + 1] = this.errorIcon;
            array2[offset + 2] = this.successIcon;
        }

        @NonNull
        static Drawables unpackFrom(@NonNull int[] array2, int offset) {
            return new Drawables(array2[offset], array2[offset + 1], array2[offset + 2]);
        }
    }

    public static class Strings {
        static final int RESOURCES_COUNT = 18;
        @StringRes
        public final int ok;
        @StringRes
        public final int close;
        @StringRes
        public final int errorEnrollFingerprintTitle;
        @StringRes
        public final int errorEnrollFingerprintDescription;
        @StringRes
        public final int errorNoFingerprintScannerTitle;
        @StringRes
        public final int errorNoFingerprintScannerDescription;
        @StringRes
        public final int errorFingerprintDisabledTitle;
        @StringRes
        public final int errorFingerprintDisabledDescription;
        @StringRes
        public final int statusTouchSensor;
        @StringRes
        public final int statusFingerprintNotRecognized;
        @StringRes
        public final int statusSuccess;
        @StringRes
        public final int errorCodeLockout;
        @StringRes
        public final int errorCodeGeneric;
        @StringRes
        public final int accessibilityFingerprintIcon;
        @StringRes
        public final int accessibilitySuccessIcon;
        @StringRes
        public final int accessibilityFailureIcon;
        @StringRes
        public final int accessibilityTryAgainAnnouncement;
        @StringRes
        public final int accessibilitySuccessAnnouncement;

        public Strings(@StringRes int ok, @StringRes int close, @StringRes int errorEnrollFingerprintTitle, @StringRes int errorEnrollFingerprintDescription, @StringRes int errorNoFingerprintScannerTitle, @StringRes int errorNoFingerprintScannerDescription, @StringRes int errorFingerprintDisabledTitle, @StringRes int errorFingerprintDisabledDescription, @StringRes int statusTouchSensor, @StringRes int statusFingerprintNotRecognized, @StringRes int statusSuccess, @StringRes int errorCodeLockout, @StringRes int errorCodeGeneric, @StringRes int accessibilityFingerprintIcon, @StringRes int accessibilitySuccessIcon, @StringRes int accessibilityFailureIcon, @StringRes int accessibilityTryAgainAnnouncement, @StringRes int accessibilitySuccessAnnouncement) {
            this.ok = ok;
            this.close = close;
            this.errorEnrollFingerprintTitle = errorEnrollFingerprintTitle;
            this.errorEnrollFingerprintDescription = errorEnrollFingerprintDescription;
            this.errorNoFingerprintScannerTitle = errorNoFingerprintScannerTitle;
            this.errorNoFingerprintScannerDescription = errorNoFingerprintScannerDescription;
            this.errorFingerprintDisabledTitle = errorFingerprintDisabledTitle;
            this.errorFingerprintDisabledDescription = errorFingerprintDisabledDescription;
            this.statusTouchSensor = statusTouchSensor;
            this.statusFingerprintNotRecognized = statusFingerprintNotRecognized;
            this.statusSuccess = statusSuccess;
            this.errorCodeLockout = errorCodeLockout;
            this.errorCodeGeneric = errorCodeGeneric;
            this.accessibilityFingerprintIcon = accessibilityFingerprintIcon;
            this.accessibilitySuccessIcon = accessibilitySuccessIcon;
            this.accessibilityFailureIcon = accessibilityFailureIcon;
            this.accessibilityTryAgainAnnouncement = accessibilityTryAgainAnnouncement;
            this.accessibilitySuccessAnnouncement = accessibilitySuccessAnnouncement;
        }

        @NonNull
        public static Strings getDefaultStrings() {
            return new Strings(R.string.ok, R.string.close, R.string.fingerprint_dialog_title_new_fingerprint, R.string.fingerprint_dialog_description_new_fingerprint, R.string.fingerprint_dialog_title_no_scanner, R.string.fingerprint_dialog_description_no_scanner, R.string.fingerprint_dialog_title_invalidated, R.string.fingerprint_dialog_description_invalidated, R.string.fingerprint_dialog_touch_sensor, R.string.fingerprint_dialog_not_recognized, R.string.fingerprint_dialog_success, R.string.fallback_error_code_lockout, R.string.fallback_error_code_generic, R.string.accessibility_icon_fingerprint, R.string.accessibility_icon_success, R.string.accessibility_icon_failure, R.string.accessibility_announcement_try_again, R.string.accessibility_announcement_success);
        }

        void packTo(@NonNull int[] array2, int offset) {
            array2[offset] = this.ok;
            array2[offset + 1] = this.close;
            array2[offset + 2] = this.errorEnrollFingerprintTitle;
            array2[offset + 3] = this.errorEnrollFingerprintDescription;
            array2[offset + 4] = this.errorNoFingerprintScannerTitle;
            array2[offset + 5] = this.errorNoFingerprintScannerDescription;
            array2[offset + 6] = this.errorFingerprintDisabledTitle;
            array2[offset + 7] = this.errorFingerprintDisabledDescription;
            array2[offset + 8] = this.statusTouchSensor;
            array2[offset + 9] = this.statusFingerprintNotRecognized;
            array2[offset + 10] = this.statusSuccess;
            array2[offset + 11] = this.errorCodeLockout;
            array2[offset + 12] = this.errorCodeGeneric;
            array2[offset + 13] = this.accessibilityFingerprintIcon;
            array2[offset + 14] = this.accessibilitySuccessIcon;
            array2[offset + 15] = this.accessibilityFailureIcon;
            array2[offset + 16] = this.accessibilityTryAgainAnnouncement;
            array2[offset + 17] = this.accessibilitySuccessAnnouncement;
        }

        @NonNull
        static Strings unpackFrom(@NonNull int[] array2, int offset) {
            return new Strings(array2[offset], array2[offset + 1], array2[offset + 2], array2[offset + 3], array2[offset + 4], array2[offset + 5], array2[offset + 6], array2[offset + 7], array2[offset + 8], array2[offset + 9], array2[offset + 10], array2[offset + 11], array2[offset + 12], array2[offset + 13], array2[offset + 14], array2[offset + 15], array2[offset + 16], array2[offset + 17]);
        }
    }

    public static class Builder {
        private Strings strings;
        private Drawables drawables;
        private Colors colors;
        private Layout layout;

        public BiometricDialogResources build() {
            return new BiometricDialogResources(this.strings != null ? this.strings : Strings.getDefaultStrings(), this.drawables != null ? this.drawables : Drawables.getDefaultDrawables(), this.colors != null ? this.colors : Colors.getDefaultColors(), this.layout != null ? this.layout : Layout.getDefaultLayout());
        }

        public Builder setStrings(@NonNull Strings strings) {
            this.strings = strings;
            return this;
        }

        public Builder setDrawables(@NonNull Drawables drawables) {
            this.drawables = drawables;
            return this;
        }

        public Builder setColors(@NonNull Colors colors) {
            this.colors = colors;
            return this;
        }

        public Builder setLayout(@NonNull Layout layout2) {
            this.layout = layout2;
            return this;
        }
    }
}

