/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import io.getlime.security.powerauth.biometry.BiometricKeyData;
import io.getlime.security.powerauth.biometry.IBiometricKeyEncryptor;
import io.getlime.security.powerauth.system.PA2Log;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

@RequiresApi(api=23)
public class BiometricKeyEncryptorRsa
implements IBiometricKeyEncryptor {
    @Nullable
    private final PublicKey publicKey;
    @Nullable
    private final PrivateKey privateKey;
    @Nullable
    private Cipher cipher;
    private boolean cipherIsInitialized;
    private boolean encryptorIsUsed;
    private boolean encryptMode;
    private static final String RSA_CIPHER = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    public BiometricKeyEncryptorRsa(@NonNull PublicKey publicKey) {
        this.publicKey = publicKey;
        this.privateKey = null;
    }

    public BiometricKeyEncryptorRsa(@NonNull PrivateKey privateKey) {
        this.publicKey = null;
        this.privateKey = privateKey;
    }

    @Override
    public boolean isAuthenticationRequiredOnEncryption() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Cipher initializeCipher(boolean encryptMode) {
        try {
            if (this.cipherIsInitialized) {
                throw new IllegalStateException("Cipher is already initialized");
            }
            this.cipher = Cipher.getInstance(RSA_CIPHER);
            if (this.cipher != null) {
                if (encryptMode) {
                    if (this.publicKey == null) {
                        throw new IllegalStateException("Initializing cipher for encryption, but public key is missing");
                    }
                    PublicKey unrestrictedPublicKey = KeyFactory.getInstance(this.publicKey.getAlgorithm()).generatePublic(new X509EncodedKeySpec(this.publicKey.getEncoded()));
                    OAEPParameterSpec spec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
                    this.cipher.init(1, (Key)unrestrictedPublicKey, spec);
                } else {
                    if (this.privateKey == null) {
                        throw new IllegalStateException("Initializing cipher for decryption, but private key is missing");
                    }
                    this.cipher.init(2, this.privateKey);
                }
                this.encryptMode = encryptMode;
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            PA2Log.e("BiometricKeyEncryptorRsa.initializeCipher failed: " + e.getMessage(), new Object[0]);
            this.cipher = null;
        }
        finally {
            this.cipherIsInitialized = true;
        }
        return this.cipher;
    }

    @Override
    @Nullable
    public BiometricKeyData encryptBiometricKey(@NonNull byte[] key) {
        try {
            if (this.cipher == null) {
                throw new IllegalStateException("Cipher is not initialized");
            }
            if (!this.encryptMode) {
                throw new IllegalStateException("Encryptor is not configured for encryption");
            }
            if (this.encryptorIsUsed) {
                throw new IllegalStateException("Encryptor cannot be used for the second time");
            }
            this.encryptorIsUsed = true;
            byte[] encryptedBiometricKey = this.cipher.doFinal(key);
            return new BiometricKeyData(encryptedBiometricKey, key, true);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            PA2Log.e("BiometricKeyEncryptorRsa.encryptBiometricKey failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Override
    @Nullable
    public BiometricKeyData decryptBiometricKey(@NonNull byte[] encryptedKey) {
        try {
            if (this.cipher == null) {
                throw new IllegalStateException("Cipher is not initialized");
            }
            if (this.encryptMode) {
                throw new IllegalStateException("Encryptor is not used for decryption");
            }
            if (this.encryptorIsUsed) {
                throw new IllegalStateException("Encryptor cannot be used for the second time");
            }
            this.encryptorIsUsed = true;
            byte[] decryptedKey = this.cipher.doFinal(encryptedKey);
            return new BiometricKeyData(encryptedKey, decryptedKey, false);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            PA2Log.e("BiometricKeyEncryptorRsa.decryptBiometricKey failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Nullable
    public static IBiometricKeyEncryptor createRsaEncryptor(@NonNull String providerName, @NonNull String keyName, boolean invalidateByBiometricEnrollment) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", providerName);
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(keyName, 3).setDigests(new String[]{"SHA-256", "SHA-512"}).setEncryptionPaddings(new String[]{"OAEPPadding"}).setUserAuthenticationRequired(true);
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setInvalidatedByBiometricEnrollment(invalidateByBiometricEnrollment);
            }
            keyPairGenerator.initialize((AlgorithmParameterSpec)builder.build());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            return new BiometricKeyEncryptorRsa(publicKey);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            PA2Log.e("BiometricKeyEncryptorRsa.createRsaEncryptor failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }
}

