/*
 * Copyright 2019 Wultra s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.getlime.security.powerauth.sdk.impl;

import io.getlime.security.powerauth.networking.interfaces.ICancelable;

/**
 * The {@code DummyCancelable} object implements {@link ICancelable} interface with a dummy
 * implementation that's already canceled. The object is useful in situations, when {@link ICancelable}
 * must be returned from the function, but operation already finished with an error.
 */
public class DummyCancelable implements ICancelable {
    @Override
    public void cancel() {
    }

    @Override
    public boolean isCancelled() {
        return true;
    }
}
