/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk.impl;

import android.support.annotation.NonNull;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.system.PA2Log;
import java.util.ArrayList;

public class CompositeCancelableTask
implements ICancelable {
    private boolean exclusiveMode;
    private boolean isCancelled;
    private final ArrayList<ICancelable> cancelables;

    public CompositeCancelableTask(boolean exclusiveMode) {
        this.exclusiveMode = exclusiveMode;
        this.cancelables = new ArrayList(1);
    }

    public CompositeCancelableTask(boolean exclusiveMode, @NonNull ICancelable cancelable) {
        this.exclusiveMode = exclusiveMode;
        this.cancelables = new ArrayList(1);
        this.cancelables.add(cancelable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancelable(@NonNull ICancelable cancelable) {
        CompositeCancelableTask compositeCancelableTask = this;
        synchronized (compositeCancelableTask) {
            if (!this.isCancelled) {
                if (this.exclusiveMode) {
                    this.cancelables.clear();
                }
                this.cancelables.add(cancelable);
            } else {
                PA2Log.d("CompositeCancelableTask is already canceled.", new Object[0]);
                cancelable.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCancelable(@NonNull ICancelable cancelable) {
        CompositeCancelableTask compositeCancelableTask = this;
        synchronized (compositeCancelableTask) {
            this.cancelables.remove(cancelable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        CompositeCancelableTask compositeCancelableTask = this;
        synchronized (compositeCancelableTask) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
            for (ICancelable cancelable : this.cancelables) {
                cancelable.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        CompositeCancelableTask compositeCancelableTask = this;
        synchronized (compositeCancelableTask) {
            return this.isCancelled;
        }
    }
}

