/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Pair;
import io.getlime.security.powerauth.R;
import io.getlime.security.powerauth.biometry.BiometricDialogResources;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.system.PA2Log;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class BiometricHelper {
    @NonNull
    public static PowerAuthErrorException getExceptionForBiometricStatus(int status) {
        switch (status) {
            case 2: {
                return new PowerAuthErrorException(19, "Biometric data is not enrolled on the device.");
            }
            case 1: {
                return new PowerAuthErrorException(18, "Biometry is not supported on the device.");
            }
            case 3: {
                return new PowerAuthErrorException(19, "Biometry is not available. Try again later.");
            }
            case 0: {
                throw new IllegalArgumentException("Cannot get exception for success status.");
            }
        }
        throw new IllegalArgumentException("Unknown status.");
    }

    @NonNull
    public static Pair<Integer, Integer> getErrorDialogStringsForBiometricStatus(int status, @NonNull BiometricDialogResources resources) {
        int errorDescription;
        int errorTitle;
        if (status == 2) {
            errorTitle = resources.strings.errorEnrollFingerprintTitle;
            errorDescription = resources.strings.errorEnrollFingerprintDescription;
        } else if (status == 1) {
            errorTitle = resources.strings.errorNoFingerprintScannerTitle;
            errorDescription = resources.strings.errorNoFingerprintScannerDescription;
        } else if (status == 3) {
            errorTitle = resources.strings.errorFingerprintDisabledTitle;
            errorDescription = resources.strings.errorFingerprintDisabledDescription;
        } else {
            errorTitle = resources.strings.errorFingerprintDisabledTitle;
            errorDescription = resources.strings.errorFingerprintDisabledDescription;
        }
        return Pair.create((Object)errorTitle, (Object)errorDescription);
    }

    @RequiresApi(api=23)
    @Nullable
    public static Cipher createAesCipher(@NonNull SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            byte[] zero_iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            IvParameterSpec algorithmSpec = new IvParameterSpec(zero_iv);
            cipher.init(1, (Key)key, algorithmSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            PA2Log.e("BiometricHelper.createAesCipher failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Nullable
    public static byte[] protectKeyWithCipher(@NonNull byte[] keyToProtect, @NonNull Cipher cipher) {
        try {
            return cipher.doFinal(keyToProtect);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            PA2Log.e("BiometricHelper.protectKeyWithCipher failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public static boolean shouldFallbackToFingerprintManager(@NonNull Context context) {
        if (Build.VERSION.SDK_INT != 28) {
            return false;
        }
        if (!BiometricHelper.isVendorInFallbackList(context)) {
            return false;
        }
        return BiometricHelper.isModelInPrefixList(context.getResources().getStringArray(R.array.crypto_fingerprint_fallback_prefixes));
    }

    public static boolean shouldHideFingerprintDialog(@NonNull Context context) {
        if (Build.VERSION.SDK_INT != 28) {
            return false;
        }
        if (!BiometricHelper.isVendorInFallbackList(context)) {
            return false;
        }
        return BiometricHelper.isModelInPrefixList(context.getResources().getStringArray(R.array.hide_fingerprint_instantly_prefixes));
    }

    private static boolean isVendorInFallbackList(@NonNull Context context) {
        String[] vendorNames = context.getResources().getStringArray(R.array.crypto_fingerprint_fallback_vendors);
        String vendor = Build.MANUFACTURER;
        if (vendor == null) {
            return false;
        }
        for (String vendorName : vendorNames) {
            if (!vendor.equalsIgnoreCase(vendorName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isModelInPrefixList(String[] modelPrefixes) {
        String model = Build.MODEL;
        if (model == null) {
            return false;
        }
        for (String modelPrefix : modelPrefixes) {
            if (!model.startsWith(modelPrefix)) continue;
            return true;
        }
        return false;
    }
}

