/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.networking.interceptors.HttpRequestInterceptor;
import io.getlime.security.powerauth.networking.ssl.PA2ClientValidationStrategy;
import io.getlime.security.powerauth.system.PA2Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PowerAuthClientConfiguration {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 20000;
    public static final int DEFAULT_READ_TIMEOUT = 20000;
    public static final boolean DEFAULT_ALLOW_UNSECURED_CONNECTION = false;
    private final int connectionTimeout;
    private final int readTimeout;
    private final boolean allowUnsecuredConnection;
    private final PA2ClientValidationStrategy clientValidationStrategy;
    private final List<HttpRequestInterceptor> requestInterceptors;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isUnsecuredConnectionAllowed() {
        return this.allowUnsecuredConnection;
    }

    public PA2ClientValidationStrategy getClientValidationStrategy() {
        return this.clientValidationStrategy;
    }

    @Nullable
    public List<HttpRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    private PowerAuthClientConfiguration(int connectionTimeout, int readTimeout, boolean allowUnsecuredConnection, PA2ClientValidationStrategy clientValidationStrategy, List<HttpRequestInterceptor> requestInterceptors) {
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.allowUnsecuredConnection = allowUnsecuredConnection;
        this.clientValidationStrategy = clientValidationStrategy;
        this.requestInterceptors = requestInterceptors;
    }

    public static class Builder {
        private int connectionTimeout = 20000;
        private int readTimeout = 20000;
        private boolean allowUnsecuredConnection = false;
        private PA2ClientValidationStrategy clientValidationStrategy;
        private ArrayList<HttpRequestInterceptor> requestInterceptors;

        public Builder timeouts(int connectionTimeout, int readTimeout) {
            this.connectionTimeout = connectionTimeout;
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder allowUnsecuredConnection(boolean allow) {
            this.allowUnsecuredConnection = allow;
            if (allow) {
                PA2Log.e("Unsecured connection is dangerous for production application.", new Object[0]);
            }
            return this;
        }

        public Builder clientValidationStrategy(PA2ClientValidationStrategy clientValidationStrategy) {
            this.clientValidationStrategy = clientValidationStrategy;
            return this;
        }

        public Builder requestInterceptor(@NonNull HttpRequestInterceptor interceptor) {
            if (this.requestInterceptors == null) {
                this.requestInterceptors = new ArrayList();
            }
            this.requestInterceptors.add(interceptor);
            return this;
        }

        public PowerAuthClientConfiguration build() {
            return new PowerAuthClientConfiguration(this.connectionTimeout, this.readTimeout, this.allowUnsecuredConnection, this.clientValidationStrategy, this.requestInterceptors != null ? Collections.unmodifiableList(this.requestInterceptors) : null);
        }
    }
}

