/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.system;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class PA2System {
    private static final String[] PATHS_SU = new String[]{"/data/local/bin/su", "/data/local/su", "/data/local/xbin/su", "/sbin/su", "/su/bin/su", "/system/app/Superuser.apk", "/system/bin/.ext/.su", "/system/bin/failsafe/su", "/system/bin/su", "/system/sd/xbin/su", "/system/su", "/system/usr/we-need-root/su-backup", "/system/xbin/mu", "/system/xbin/su"};
    private static final String[] PATHS_READ_ONLY = new String[]{"/", "/data", "/dev", "/etc", "/proc", "/sbin", "/sys", "/system", "/system/bin", "/system/sbin", "/system/xbin", "/vendor/bin"};
    private static final String[] APKS_SU = new String[]{"com.kingouser.com", "com.koushikdutta.superuser", "com.noshufou.android.su", "com.noshufou.android.su.elite", "com.thirdparty.superuser", "eu.chainfire.supersu", "com.yellowes.su", "com.devadvance.rootcloak", "com.devadvance.rootcloak2", "com.devadvance.rootcloakplus", "com.ramdroid.appquarantine", "com.zachspong.temprootremovejb", "de.robv.android.xposed.installer", "com.saurik.substrate", "com.amphoras.hidemyroot", "com.amphoras.hidemyrootadfree", "com.formyhm.hiderootPremium", "com.formyhm.hideroot", "ru.meefik.busybox", "stericson.busybox", "stericson.busybox.donate", "com.koushikdutta.rommanager", "com.koushikdutta.rommanager.license", "com.dimonvideo.luckypatcher", "com.chelpus.lackypatch", "com.ramdroid.appquarantine", "com.ramdroid.appquarantinepro"};
    private static final String CMD_FIND_SU = "which su";
    private static final String CMD_BUSYBOX = "busybox df";
    private static final String TAGS_TEST_KEYS = "test-keys";

    @WorkerThread
    public static boolean isRooted(Context context) {
        return PA2System.findSuOnPaths() || PA2System.findSuWithWhich() || PA2System.findTagsTestKeys() || PA2System.findWritableSystemPaths() || PA2System.findSuApks(context);
    }

    @NonNull
    public static String getPlatform() {
        return "Android";
    }

    @NonNull
    public static String getDeviceInfo() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (model.toLowerCase().startsWith(manufacturer.toLowerCase())) {
            return PA2System.capitalizeString(model);
        }
        return PA2System.capitalizeString(manufacturer) + " " + model;
    }

    private static String capitalizeString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    @WorkerThread
    private static boolean findSuOnPaths() {
        for (String path : PATHS_SU) {
            File su = new File(path);
            if (!su.exists()) continue;
            return true;
        }
        return false;
    }

    @WorkerThread
    private static boolean findSuWithWhich() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(CMD_FIND_SU);
            String line = PA2System.streamToString(process.getInputStream());
            if (!TextUtils.isEmpty((CharSequence)line)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return false;
    }

    private static boolean findTagsTestKeys() {
        return Build.TAGS != null && Build.TAGS.contains(TAGS_TEST_KEYS);
    }

    private static boolean findSuApks(Context context) {
        PackageManager packageManager = context.getPackageManager();
        for (String pkgName : APKS_SU) {
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, 0);
                if (packageInfo == null) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    @WorkerThread
    private static boolean findWritableSystemPaths() {
        for (String path : PATHS_READ_ONLY) {
            File directory = new File(path);
            if (!directory.exists() || !directory.canWrite()) continue;
            return true;
        }
        return false;
    }

    @WorkerThread
    private static boolean findBusyBox() {
        Process process = null;
        try {
            process = new ProcessBuilder(CMD_BUSYBOX).redirectErrorStream(true).start();
            String line = PA2System.streamToString(process.getInputStream());
            if (!TextUtils.isEmpty((CharSequence)line)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String streamToString(InputStream is) throws IOException {
        Reader reader = null;
        try {
            int n;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[256];
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            String string2 = ((Object)writer).toString();
            return string2;
        }
        catch (UnsupportedEncodingException e) {
            String string3 = "";
            return string3;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

