/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class PowerAuthPrivateTokenData {
    public final String name;
    public final String identifier;
    public final byte[] secret;
    private static final int SECRET_LENGTH = 16;

    public PowerAuthPrivateTokenData(@NonNull String name, @NonNull String identifier, @NonNull byte[] secret) {
        this.name = name;
        this.identifier = identifier;
        this.secret = secret;
    }

    public boolean hasValidData() {
        if (this.name != null && this.identifier != null && this.secret != null) {
            return this.secret.length == 16 && !this.identifier.isEmpty() && !this.name.isEmpty();
        }
        return false;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof PowerAuthPrivateTokenData) {
            PowerAuthPrivateTokenData anotherToken = (PowerAuthPrivateTokenData)anObject;
            if (this.hasValidData() && anotherToken.hasValidData()) {
                return this.name.equals(anotherToken.name) && this.identifier.equals(anotherToken.identifier) && Arrays.equals(this.secret, anotherToken.secret);
            }
        }
        return false;
    }

    @Nullable
    public byte[] getSerializedData() {
        if (!this.hasValidData()) {
            return null;
        }
        String nameB64 = Base64.encodeToString((byte[])this.name.getBytes(), (int)2);
        String secretB64 = Base64.encodeToString((byte[])this.secret, (int)2);
        String dataString = this.identifier + "," + secretB64 + "," + nameB64;
        try {
            return dataString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Nullable
    public static PowerAuthPrivateTokenData deserializeWithData(@NonNull byte[] data) {
        String str;
        try {
            str = new String(data, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        String[] components = str.split("\\,");
        if (components.length != 3) {
            return null;
        }
        String identifier = components[0];
        byte[] secret = Base64.decode((String)components[1], (int)2);
        String name = new String(Base64.decode((String)components[2], (int)2));
        PowerAuthPrivateTokenData tokenData = new PowerAuthPrivateTokenData(name, identifier, secret);
        return tokenData.hasValidData() ? tokenData : null;
    }
}

