/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.content.Context;
import android.os.Build;
import android.support.annotation.CheckResult;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentManager;
import com.google.gson.reflect.TypeToken;
import io.getlime.security.powerauth.biometry.BiometricAuthentication;
import io.getlime.security.powerauth.biometry.BiometricAuthenticationRequest;
import io.getlime.security.powerauth.biometry.IBiometricAuthenticationCallback;
import io.getlime.security.powerauth.biometry.IBiometricKeystore;
import io.getlime.security.powerauth.biometry.ICommitActivationWithBiometryListener;
import io.getlime.security.powerauth.core.ActivationStatus;
import io.getlime.security.powerauth.core.ActivationStep1Param;
import io.getlime.security.powerauth.core.ActivationStep1Result;
import io.getlime.security.powerauth.core.ActivationStep2Param;
import io.getlime.security.powerauth.core.ActivationStep2Result;
import io.getlime.security.powerauth.core.EciesEncryptor;
import io.getlime.security.powerauth.core.Password;
import io.getlime.security.powerauth.core.RecoveryData;
import io.getlime.security.powerauth.core.Session;
import io.getlime.security.powerauth.core.SessionSetup;
import io.getlime.security.powerauth.core.SignatureRequest;
import io.getlime.security.powerauth.core.SignatureResult;
import io.getlime.security.powerauth.core.SignatureUnlockKeys;
import io.getlime.security.powerauth.core.SignedData;
import io.getlime.security.powerauth.ecies.EciesEncryptorFactory;
import io.getlime.security.powerauth.ecies.EciesEncryptorId;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.exception.PowerAuthMissingConfigException;
import io.getlime.security.powerauth.keychain.PA2Keychain;
import io.getlime.security.powerauth.networking.client.HttpClient;
import io.getlime.security.powerauth.networking.client.JsonSerialization;
import io.getlime.security.powerauth.networking.endpoints.ConfirmRecoveryCodeEndpoint;
import io.getlime.security.powerauth.networking.endpoints.CreateActivationEndpoint;
import io.getlime.security.powerauth.networking.endpoints.RemoveActivationEndpoint;
import io.getlime.security.powerauth.networking.endpoints.ValidateSignatureEndpoint;
import io.getlime.security.powerauth.networking.endpoints.VaultUnlockEndpoint;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.model.entity.ActivationRecovery;
import io.getlime.security.powerauth.networking.model.entity.ActivationType;
import io.getlime.security.powerauth.networking.model.request.ActivationLayer1Request;
import io.getlime.security.powerauth.networking.model.request.ActivationLayer2Request;
import io.getlime.security.powerauth.networking.model.request.ConfirmRecoveryRequestPayload;
import io.getlime.security.powerauth.networking.model.request.ValidateSignatureRequest;
import io.getlime.security.powerauth.networking.model.request.VaultUnlockRequestPayload;
import io.getlime.security.powerauth.networking.model.response.ActivationLayer1Response;
import io.getlime.security.powerauth.networking.model.response.ActivationLayer2Response;
import io.getlime.security.powerauth.networking.model.response.ConfirmRecoveryResponsePayload;
import io.getlime.security.powerauth.networking.model.response.VaultUnlockResponsePayload;
import io.getlime.security.powerauth.networking.response.CreateActivationResult;
import io.getlime.security.powerauth.networking.response.IActivationRemoveListener;
import io.getlime.security.powerauth.networking.response.IActivationStatusListener;
import io.getlime.security.powerauth.networking.response.IAddBiometryFactorListener;
import io.getlime.security.powerauth.networking.response.IChangePasswordListener;
import io.getlime.security.powerauth.networking.response.IConfirmRecoveryCodeListener;
import io.getlime.security.powerauth.networking.response.ICreateActivationListener;
import io.getlime.security.powerauth.networking.response.IDataSignatureListener;
import io.getlime.security.powerauth.networking.response.IFetchEncryptionKeyListener;
import io.getlime.security.powerauth.networking.response.IGetRecoveryDataListener;
import io.getlime.security.powerauth.networking.response.IValidatePasswordListener;
import io.getlime.security.powerauth.sdk.PowerAuthAuthentication;
import io.getlime.security.powerauth.sdk.PowerAuthAuthorizationHttpHeader;
import io.getlime.security.powerauth.sdk.PowerAuthClientConfiguration;
import io.getlime.security.powerauth.sdk.PowerAuthConfiguration;
import io.getlime.security.powerauth.sdk.PowerAuthKeychainConfiguration;
import io.getlime.security.powerauth.sdk.PowerAuthTokenStore;
import io.getlime.security.powerauth.sdk.impl.CompositeCancelableTask;
import io.getlime.security.powerauth.sdk.impl.DefaultCallbackDispatcher;
import io.getlime.security.powerauth.sdk.impl.DefaultExecutorProvider;
import io.getlime.security.powerauth.sdk.impl.DefaultSavePowerAuthStateListener;
import io.getlime.security.powerauth.sdk.impl.GetActivationStatusTask;
import io.getlime.security.powerauth.sdk.impl.ICallbackDispatcher;
import io.getlime.security.powerauth.sdk.impl.IPrivateCryptoHelper;
import io.getlime.security.powerauth.sdk.impl.ISavePowerAuthStateListener;
import io.getlime.security.powerauth.system.PA2Log;
import io.getlime.security.powerauth.util.otp.Otp;
import io.getlime.security.powerauth.util.otp.OtpUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class PowerAuthSDK {
    private Session mSession;
    private PowerAuthConfiguration mConfiguration;
    private PowerAuthClientConfiguration mClientConfiguration;
    private PowerAuthKeychainConfiguration mKeychainConfiguration;
    private HttpClient mClient;
    private ISavePowerAuthStateListener mStateListener;
    private PA2Keychain mStatusKeychain;
    private PA2Keychain mBiometryKeychain;
    private PowerAuthTokenStore mTokenStore;
    private ICallbackDispatcher mCallbackDispatcher;
    private GetActivationStatusTask mGetActivationStatusTask;
    private ActivationStatus mLastFetchedActivationStatus;

    private PowerAuthSDK() {
    }

    @NonNull
    IPrivateCryptoHelper getCryptoHelper(final @Nullable Context context) {
        return new IPrivateCryptoHelper(){

            @Override
            @NonNull
            public EciesEncryptor getEciesEncryptor(@NonNull EciesEncryptorId identifier) throws PowerAuthErrorException {
                byte[] deviceRelatedKey = context == null ? null : PowerAuthSDK.this.deviceRelatedKey(context);
                EciesEncryptorFactory factory = new EciesEncryptorFactory(PowerAuthSDK.this.mSession, deviceRelatedKey);
                return factory.getEncryptor(identifier);
            }

            @Override
            @NonNull
            public PowerAuthAuthorizationHttpHeader getAuthorizationHeader(boolean availableInProtocolUpgrade, @NonNull byte[] body, @NonNull String method, @NonNull String uriIdentifier, @NonNull PowerAuthAuthentication authentication) throws PowerAuthErrorException {
                if (context == null) {
                    throw new PowerAuthErrorException(3, "Context object is not set.");
                }
                SignatureRequest signatureRequest = new SignatureRequest(body, method, uriIdentifier, null);
                SignatureResult signatureResult = PowerAuthSDK.this.calculatePowerAuthSignature(context, signatureRequest, authentication, availableInProtocolUpgrade);
                return PowerAuthAuthorizationHttpHeader.createAuthorizationHeader(signatureResult.getAuthHeaderValue());
            }

            @Override
            @Nullable
            public byte[] getDeviceRelatedKey() {
                return context == null ? null : PowerAuthSDK.this.deviceRelatedKey(context);
            }
        };
    }

    private void checkForValidSetup() {
        if (this.mSession == null || !this.mSession.hasValidSetup()) {
            throw new PowerAuthMissingConfigException("Invalid PowerAuthSDK configuration. You must set a valid PowerAuthConfiguration to PowerAuthSDK instance using initializer.");
        }
    }

    private byte[] deviceRelatedKey(@NonNull Context context) {
        return this.mSession.normalizeSignatureUnlockKeyFromData(this.mConfiguration.getFetchKeysStrategy().getPossessionUnlockKey(context).getBytes());
    }

    @NonNull
    private SignatureUnlockKeys signatureKeysForAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication) {
        byte[] possessionKey = null;
        byte[] biometryKey = null;
        Password knowledgeKey = null;
        if (authentication.usePossession) {
            possessionKey = authentication.overridenPossessionKey != null ? authentication.overridenPossessionKey : this.deviceRelatedKey(context);
        }
        if (authentication.useBiometry != null) {
            biometryKey = authentication.useBiometry;
        }
        if (authentication.usePassword != null) {
            knowledgeKey = new Password(authentication.usePassword);
        }
        return new SignatureUnlockKeys(possessionKey, biometryKey, knowledgeKey);
    }

    private int determineSignatureFactorForAuthentication(@NonNull PowerAuthAuthentication authentication) {
        int factor = 0;
        if (authentication.usePossession) {
            factor |= 1;
        }
        if (authentication.usePassword != null) {
            factor |= 0x10;
        }
        if (authentication.useBiometry != null) {
            factor |= 0x100;
        }
        return factor;
    }

    @Nullable
    private ICancelable fetchEncryptedVaultUnlockKey(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, @NonNull String reason, final @NonNull IFetchEncryptedVaultUnlockKeyListener listener) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onFetchEncryptedVaultUnlockKeyFailed(new PowerAuthErrorException(5));
                }
            });
            return null;
        }
        VaultUnlockRequestPayload request = new VaultUnlockRequestPayload();
        request.setReason(reason);
        return this.mClient.post(request, new VaultUnlockEndpoint(), this.getCryptoHelper(context), authentication, new INetworkResponseListener<VaultUnlockResponsePayload>(){

            @Override
            public void onNetworkResponse(VaultUnlockResponsePayload response) {
                listener.onFetchEncryptedVaultUnlockKeySucceed(response.getEncryptedVaultEncryptionKey());
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onFetchEncryptedVaultUnlockKeyFailed(t);
            }

            @Override
            public void onCancel() {
            }
        });
    }

    public synchronized PowerAuthTokenStore getTokenStore() {
        if (this.mTokenStore == null) {
            PA2Keychain tokenStoreKeychain = new PA2Keychain(this.mKeychainConfiguration.getKeychainTokenStoreId());
            this.mTokenStore = new PowerAuthTokenStore(this, tokenStoreKeychain, this.mClient);
        }
        return this.mTokenStore;
    }

    public Session getSession() {
        return this.mSession;
    }

    @Nullable
    public String getActivationIdentifier() {
        return this.mSession.getActivationIdentifier();
    }

    @Nullable
    public String getActivationFingerprint() {
        return this.mSession.getActivationFingerprint();
    }

    @NonNull
    public PowerAuthConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    public void saveSerializedState() {
        byte[] state = this.mSession.serializedState();
        this.mStateListener.onPowerAuthStateChanged(this.mConfiguration.getInstanceId(), state);
    }

    @CheckResult
    public boolean restoreState(byte[] state) {
        this.mSession.resetSession();
        int result = this.mSession.deserializeState(state);
        return result == 0;
    }

    @CheckResult
    public boolean hasDebugFeatures() {
        return this.mSession.hasDebugFeatures();
    }

    @CheckResult
    public boolean canStartActivation() {
        this.checkForValidSetup();
        return this.mSession.canStartActivation();
    }

    @CheckResult
    public boolean hasPendingActivation() {
        this.checkForValidSetup();
        return this.mSession.hasPendingActivation();
    }

    @CheckResult
    public boolean hasValidActivation() {
        this.checkForValidSetup();
        return this.mSession.hasValidActivation();
    }

    public void destroy() {
        this.mSession.destroy();
        this.mSession = null;
    }

    @Nullable
    public ICancelable createActivation(@Nullable String name, @NonNull String activationCode, @NonNull ICreateActivationListener listener) {
        return this.createActivation(name, activationCode, null, null, listener);
    }

    @Nullable
    public ICancelable createActivation(@Nullable String name, @NonNull String activationCode, @Nullable String extras, @NonNull ICreateActivationListener listener) {
        return this.createActivation(name, activationCode, extras, null, listener);
    }

    @Nullable
    public ICancelable createActivation(@Nullable String name, @NonNull String activationCode, @Nullable String extras, @Nullable Map<String, Object> customAttributes, final @NonNull ICreateActivationListener listener) {
        Otp otp = OtpUtil.parseFromActivationCode(activationCode);
        if (otp == null) {
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onActivationCreateFailed(new PowerAuthErrorException(12));
                }
            });
            return null;
        }
        HashMap<String, String> identityAttributes = new HashMap<String, String>();
        identityAttributes.put("code", otp.activationCode);
        ActivationLayer1Request request = new ActivationLayer1Request();
        request.setType(ActivationType.CODE);
        request.setIdentityAttributes(identityAttributes);
        request.setCustomAttributes(customAttributes);
        return this.createActivationImpl(name, request, otp, extras, listener);
    }

    @Nullable
    public ICancelable createCustomActivation(@Nullable String name, @NonNull Map<String, String> identityAttributes, @Nullable String extras, @Nullable Map<String, Object> customAttributes, @NonNull ICreateActivationListener listener) {
        ActivationLayer1Request request = new ActivationLayer1Request();
        request.setType(ActivationType.CUSTOM);
        request.setIdentityAttributes(identityAttributes);
        request.setCustomAttributes(customAttributes);
        return this.createActivationImpl(name, request, null, extras, listener);
    }

    @Nullable
    public ICancelable createRecoveryActivation(@Nullable String name, @NonNull String recoveryCode, @NonNull String puk, @Nullable String extras, @Nullable Map<String, Object> customAttributes, final @NonNull ICreateActivationListener listener) {
        Otp otp = OtpUtil.parseFromRecoveryCode(recoveryCode);
        boolean validPuk = OtpUtil.validateRecoveryPuk(puk);
        if (otp == null || !validPuk) {
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onActivationCreateFailed(new PowerAuthErrorException(4));
                }
            });
            return null;
        }
        HashMap<String, String> identityAttributes = new HashMap<String, String>();
        identityAttributes.put("recoveryCode", otp.activationCode);
        identityAttributes.put("puk", puk);
        ActivationLayer1Request request = new ActivationLayer1Request();
        request.setType(ActivationType.RECOVERY);
        request.setIdentityAttributes(identityAttributes);
        request.setCustomAttributes(customAttributes);
        return this.createActivationImpl(name, request, null, extras, listener);
    }

    @Nullable
    private ICancelable createActivationImpl(@Nullable String name, @NonNull ActivationLayer1Request request, @Nullable Otp otp, @Nullable String extras, final @NonNull ICreateActivationListener listener) {
        EciesEncryptor encryptor;
        this.checkForValidSetup();
        if (!this.canStartActivation()) {
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onActivationCreateFailed(new PowerAuthErrorException(3));
                }
            });
            return null;
        }
        IPrivateCryptoHelper cryptoHelper = this.getCryptoHelper(null);
        final JsonSerialization serialization = new JsonSerialization();
        try {
            encryptor = cryptoHelper.getEciesEncryptor(EciesEncryptorId.ACTIVATION_PAYLOAD);
            ActivationStep1Param step1Param = otp != null ? new ActivationStep1Param(otp.activationCode, otp.activationSignature) : null;
            ActivationStep1Result step1Result = this.mSession.startActivation(step1Param);
            if (step1Result.errorCode != 0) {
                final int errorCode = step1Result.errorCode == 1 ? 2 : 4;
                this.dispatchCallback(new Runnable(){

                    @Override
                    public void run() {
                        listener.onActivationCreateFailed(new PowerAuthErrorException(errorCode));
                    }
                });
                return null;
            }
            ActivationLayer2Request privateData = new ActivationLayer2Request();
            privateData.setActivationName(name);
            privateData.setExtras(extras);
            privateData.setDevicePublicKey(step1Result.devicePublicKey);
            request.setActivationData(serialization.encryptObjectToRequest(privateData, encryptor));
        }
        catch (PowerAuthErrorException e) {
            this.mSession.resetSession();
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onActivationCreateFailed(e);
                }
            });
            return null;
        }
        return this.mClient.post(request, new CreateActivationEndpoint(), cryptoHelper, new INetworkResponseListener<ActivationLayer1Response>(){

            @Override
            public void onNetworkResponse(ActivationLayer1Response response) {
                try {
                    RecoveryData recoveryData;
                    ActivationLayer2Response layer2Response = (ActivationLayer2Response)serialization.decryptObjectFromResponse(response.getActivationData(), encryptor, TypeToken.get(ActivationLayer2Response.class));
                    if (layer2Response.getActivationRecovery() != null) {
                        ActivationRecovery rd = layer2Response.getActivationRecovery();
                        recoveryData = new RecoveryData(rd.getRecoveryCode(), rd.getPuk());
                    } else {
                        recoveryData = null;
                    }
                    ActivationStep2Param step2Param = new ActivationStep2Param(layer2Response.getActivationId(), layer2Response.getServerPublicKey(), layer2Response.getCtrData(), recoveryData);
                    ActivationStep2Result step2Result = PowerAuthSDK.this.mSession.validateActivationResponse(step2Param);
                    if (step2Result.errorCode == 0) {
                        CreateActivationResult result = new CreateActivationResult(step2Result.activationFingerprint, response.getCustomAttributes(), recoveryData);
                        listener.onActivationCreateSucceed(result);
                        return;
                    }
                    throw new PowerAuthErrorException(4, "Invalid activation data received from the server.");
                }
                catch (PowerAuthErrorException e) {
                    PowerAuthSDK.this.mSession.resetSession();
                    listener.onActivationCreateFailed(e);
                    return;
                }
            }

            @Override
            public void onNetworkError(Throwable throwable) {
                PowerAuthSDK.this.mSession.resetSession();
                listener.onActivationCreateFailed(throwable);
            }

            @Override
            public void onCancel() {
                PowerAuthSDK.this.mSession.resetSession();
            }
        });
    }

    @CheckResult
    public int commitActivationWithPassword(@NonNull Context context, @NonNull String password) {
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.useBiometry = null;
        authentication.usePossession = true;
        authentication.usePassword = password;
        return this.commitActivationWithAuthentication(context, authentication);
    }

    @RequiresApi(api=23)
    @NonNull
    public ICancelable commitActivation(final @NonNull Context context, FragmentManager fragmentManager, String title, String description, final @NonNull String password, final ICommitActivationWithBiometryListener callback) {
        return this.authenticateUsingBiometry(context, fragmentManager, title, description, true, new IBiometricAuthenticationCallback(){

            @Override
            public void onBiometricDialogCancelled(boolean userCancel) {
                if (userCancel) {
                    callback.onBiometricDialogCancelled();
                }
            }

            @Override
            public void onBiometricDialogSuccess(@NonNull byte[] biometricKeyEncrypted) {
                int errorCode = PowerAuthSDK.this.commitActivationWithPassword(context, password, biometricKeyEncrypted);
                if (errorCode == 0) {
                    callback.onBiometricDialogSuccess();
                } else {
                    callback.onBiometricDialogFailed(new PowerAuthErrorException(errorCode));
                }
            }

            @Override
            public void onBiometricDialogFailed(@NonNull PowerAuthErrorException error) {
                callback.onBiometricDialogFailed(error);
            }
        });
    }

    @RequiresApi(api=23)
    @CheckResult
    public int commitActivationWithPassword(@NonNull Context context, @NonNull String password, @Nullable byte[] encryptedBiometryKey) {
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.useBiometry = encryptedBiometryKey;
        authentication.usePossession = true;
        authentication.usePassword = password;
        return this.commitActivationWithAuthentication(context, authentication);
    }

    @CheckResult
    public int commitActivationWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication) {
        Password knowledgeKey;
        byte[] biometryKey;
        this.checkForValidSetup();
        if (!this.mSession.hasPendingActivation()) {
            return 3;
        }
        byte[] possessionKey = authentication.usePossession ? this.deviceRelatedKey(context) : null;
        SignatureUnlockKeys keys = new SignatureUnlockKeys(possessionKey, biometryKey = authentication.useBiometry, knowledgeKey = authentication.usePassword != null ? new Password(authentication.usePassword) : null);
        int result = this.mSession.completeActivation(keys);
        if (result == 0) {
            this.saveSerializedState();
            return 0;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ActivationStatus getLastFetchedActivationStatus() {
        PowerAuthSDK powerAuthSDK = this;
        synchronized (powerAuthSDK) {
            return this.mLastFetchedActivationStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ICancelable fetchActivationStatusWithCallback(@NonNull Context context, final @NonNull IActivationStatusListener listener) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            final int errorCode = this.mSession.hasPendingActivation() ? 7 : 5;
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onActivationStatusFailed(new PowerAuthErrorException(errorCode));
                }
            });
            return null;
        }
        ICancelable task = null;
        PowerAuthSDK powerAuthSDK = this;
        synchronized (powerAuthSDK) {
            if (this.mGetActivationStatusTask != null && (task = this.mGetActivationStatusTask.addActivationStatusListener(listener)) == null) {
                this.mGetActivationStatusTask = null;
            }
            if (this.mGetActivationStatusTask == null) {
                this.mGetActivationStatusTask = new GetActivationStatusTask(this.mClient, this.getCryptoHelper(context), this.mSession, this.mCallbackDispatcher, new GetActivationStatusTask.ICompletionListener(){

                    @Override
                    public void onSessionStateChange() {
                        PowerAuthSDK.this.saveSerializedState();
                    }

                    @Override
                    public void onSuccess(@NonNull GetActivationStatusTask task, @NonNull ActivationStatus status) {
                        PowerAuthSDK.this.completeGetActivationStatusTask(task, status);
                    }

                    @Override
                    public void onFailure(@NonNull GetActivationStatusTask task) {
                        PowerAuthSDK.this.completeGetActivationStatusTask(task, null);
                    }
                });
                this.mGetActivationStatusTask.setUpgradeDisabled(this.mConfiguration.isAutomaticProtocolUpgradeDisabled());
                task = this.mGetActivationStatusTask.addActivationStatusListener(listener);
                this.mGetActivationStatusTask.execute();
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeGetActivationStatusTask(@Nullable GetActivationStatusTask task, @Nullable ActivationStatus status) {
        PowerAuthSDK powerAuthSDK = this;
        synchronized (powerAuthSDK) {
            boolean updateLastStatus;
            if (task == this.mGetActivationStatusTask) {
                this.mGetActivationStatusTask = null;
                updateLastStatus = true;
            } else {
                boolean bl = updateLastStatus = this.mGetActivationStatusTask != null;
            }
            if (updateLastStatus && status != null) {
                this.mLastFetchedActivationStatus = status;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelGetActivationStatusTask() {
        PowerAuthSDK powerAuthSDK = this;
        synchronized (powerAuthSDK) {
            if (this.mGetActivationStatusTask != null) {
                this.mGetActivationStatusTask.cancel();
                this.mGetActivationStatusTask = null;
            }
            this.mLastFetchedActivationStatus = null;
        }
    }

    @Nullable
    public ICancelable removeActivationWithAuthentication(final @NonNull Context context, @NonNull PowerAuthAuthentication authentication, final @NonNull IActivationRemoveListener listener) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onActivationRemoveFailed(new PowerAuthErrorException(5));
                }
            });
            return null;
        }
        return this.mClient.post(null, new RemoveActivationEndpoint(), this.getCryptoHelper(context), authentication, new INetworkResponseListener<Void>(){

            @Override
            public void onNetworkResponse(Void aVoid) {
                PowerAuthSDK.this.removeActivationLocal(context);
                listener.onActivationRemoveSucceed();
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onActivationRemoveFailed(t);
            }

            @Override
            public void onCancel() {
            }
        });
    }

    public void removeActivationLocal(@NonNull Context context) {
        this.removeActivationLocal(context, true);
    }

    public void removeActivationLocal(@Nullable Context context, boolean removeSharedBiometryKey) {
        this.checkForValidSetup();
        if (Build.VERSION.SDK_INT >= 23) {
            if (removeSharedBiometryKey && this.mSession.hasBiometryFactor() && context != null) {
                this.mBiometryKeychain.removeDataForKey(context, this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
            }
            BiometricAuthentication.getBiometricKeystore().removeDefaultKey();
        }
        if (context != null) {
            this.getTokenStore().removeAllLocalTokens(context);
        }
        this.mSession.resetSession();
        this.saveSerializedState();
        this.cancelGetActivationStatusTask();
    }

    @NonNull
    public PowerAuthAuthorizationHttpHeader requestGetSignatureWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, String uriId, Map<String, String> params) {
        byte[] body = this.mSession.prepareKeyValueDictionaryForDataSigning(params);
        return this.requestSignatureWithAuthentication(context, authentication, "GET", uriId, body);
    }

    @NonNull
    public PowerAuthAuthorizationHttpHeader requestSignatureWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, String method, String uriId, byte[] body) {
        this.checkForValidSetup();
        try {
            SignatureRequest signatureRequest = new SignatureRequest(body, method, uriId, null);
            SignatureResult signatureResult = this.calculatePowerAuthSignature(context, signatureRequest, authentication, false);
            return PowerAuthAuthorizationHttpHeader.createAuthorizationHeader(signatureResult.getAuthHeaderValue());
        }
        catch (PowerAuthErrorException e) {
            return PowerAuthAuthorizationHttpHeader.createError(e.getPowerAuthErrorCode());
        }
    }

    @Nullable
    public String offlineSignatureWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, String uriId, byte[] body, String nonce) {
        this.checkForValidSetup();
        if (nonce == null) {
            PA2Log.e("offlineSignatureWithAuthentication: 'nonce' parameter is required.", new Object[0]);
            return null;
        }
        try {
            SignatureRequest signatureRequest = new SignatureRequest(body, "POST", uriId, nonce);
            SignatureResult signatureResult = this.calculatePowerAuthSignature(context, signatureRequest, authentication, false);
            return signatureResult.signatureCode;
        }
        catch (PowerAuthErrorException e) {
            PA2Log.e("offlineSignatureWithAuthentication: Failed at: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @NonNull
    private SignatureResult calculatePowerAuthSignature(@NonNull Context context, @NonNull SignatureRequest signatureRequest, @NonNull PowerAuthAuthentication authentication, boolean allowInUpgrade) throws PowerAuthErrorException {
        if (!this.mSession.hasValidActivation()) {
            throw new PowerAuthErrorException(5, "Missing activation.");
        }
        if (this.mSession.hasPendingProtocolUpgrade() && !allowInUpgrade) {
            throw new PowerAuthErrorException(17, "Data signing is temporarily unavailable, due to pending protocol upgrade.");
        }
        int signatureFactor = this.determineSignatureFactorForAuthentication(authentication);
        if (signatureFactor == 0) {
            throw new PowerAuthErrorException(15, "Invalid combination of signature factors.");
        }
        SignatureUnlockKeys keys = this.signatureKeysForAuthentication(context, authentication);
        SignatureResult signatureResult = this.mSession.signHTTPRequest(signatureRequest, keys, signatureFactor);
        if (signatureResult == null) {
            throw new PowerAuthErrorException(3, "Session is no longer valid.");
        }
        this.saveSerializedState();
        if (signatureResult.errorCode != 0) {
            throw new PowerAuthErrorException(2, "Signature calculation failed on error " + signatureResult.errorCode);
        }
        return signatureResult;
    }

    public boolean verifyServerSignedData(byte[] data, byte[] signature, boolean useMasterKey) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            return false;
        }
        SignedData signedData = new SignedData(data, signature, useMasterKey);
        return this.mSession.verifyServerSignedData(signedData) == 0;
    }

    @Nullable
    public ICancelable signDataWithDevicePrivateKey(final @NonNull Context context, @NonNull PowerAuthAuthentication authentication, final @NonNull byte[] data, final @NonNull IDataSignatureListener listener) {
        return this.fetchEncryptedVaultUnlockKey(context, authentication, "SIGN_WITH_DEVICE_PRIVATE_KEY", new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                if (encryptedEncryptionKey != null) {
                    SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), null, null);
                    byte[] signature = PowerAuthSDK.this.mSession.signDataWithDevicePrivateKey(encryptedEncryptionKey, keys, data);
                    if (signature != null) {
                        listener.onDataSignedSucceed(signature);
                    } else {
                        listener.onDataSignedFailed(new PowerAuthErrorException(4));
                    }
                } else {
                    listener.onDataSignedFailed(new PowerAuthErrorException(3));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onDataSignedFailed(t);
            }
        });
    }

    public boolean changePasswordUnsafe(@NonNull String oldPassword, @NonNull String newPassword) {
        int result = this.mSession.changeUserPassword(new Password(oldPassword), new Password(newPassword));
        if (result == 0) {
            this.saveSerializedState();
            return true;
        }
        return false;
    }

    @Nullable
    public ICancelable changePassword(@NonNull Context context, final @NonNull String oldPassword, final @NonNull String newPassword, final @NonNull IChangePasswordListener listener) {
        return this.validatePasswordCorrect(context, oldPassword, new IValidatePasswordListener(){

            @Override
            public void onPasswordValid() {
                int result = PowerAuthSDK.this.mSession.changeUserPassword(new Password(oldPassword), new Password(newPassword));
                if (result == 0) {
                    PowerAuthSDK.this.saveSerializedState();
                    listener.onPasswordChangeSucceed();
                } else {
                    listener.onPasswordChangeFailed(new PowerAuthErrorException(3));
                }
            }

            @Override
            public void onPasswordValidationFailed(Throwable t) {
                listener.onPasswordChangeFailed(t);
            }
        });
    }

    @RequiresApi(api=23)
    public boolean hasBiometryFactor(@NonNull Context context) {
        this.checkForValidSetup();
        IBiometricKeystore keyStore = BiometricAuthentication.getBiometricKeystore();
        return this.mSession.hasBiometryFactor() && keyStore.containsDefaultKey() && this.mBiometryKeychain.containsDataForKey(context, this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
    }

    @RequiresApi(api=23)
    @Nullable
    public ICancelable addBiometryFactor(final @NonNull Context context, final FragmentManager fragmentManager, final String title, final String description, String password, final @NonNull IAddBiometryFactorListener listener) {
        PowerAuthAuthentication authAuthentication = new PowerAuthAuthentication();
        authAuthentication.usePossession = true;
        authAuthentication.usePassword = password;
        final CompositeCancelableTask compositeCancelableTask = new CompositeCancelableTask(true);
        ICancelable httpRequest = this.fetchEncryptedVaultUnlockKey(context, authAuthentication, "ADD_BIOMETRY", new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(final String encryptedEncryptionKey) {
                if (encryptedEncryptionKey != null) {
                    ICancelable biometricAuthentication = PowerAuthSDK.this.authenticateUsingBiometry(context, fragmentManager, title, description, true, new IBiometricAuthenticationCallback(){

                        @Override
                        public void onBiometricDialogCancelled(boolean userCancel) {
                            if (userCancel) {
                                listener.onAddBiometryFactorFailed(new PowerAuthErrorException(10));
                            }
                        }

                        @Override
                        public void onBiometricDialogSuccess(@NonNull byte[] biometricKeyEncrypted) {
                            SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), biometricKeyEncrypted, null);
                            int result = PowerAuthSDK.this.mSession.addBiometryFactor(encryptedEncryptionKey, keys);
                            if (result == 0) {
                                PowerAuthSDK.this.saveSerializedState();
                                listener.onAddBiometryFactorSucceed();
                            } else {
                                listener.onAddBiometryFactorFailed(new PowerAuthErrorException(3));
                            }
                        }

                        @Override
                        public void onBiometricDialogFailed(@NonNull PowerAuthErrorException error) {
                            listener.onAddBiometryFactorFailed(error);
                        }
                    });
                    compositeCancelableTask.addCancelable(biometricAuthentication);
                } else {
                    listener.onAddBiometryFactorFailed(new PowerAuthErrorException(4));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onAddBiometryFactorFailed(t);
            }
        });
        if (httpRequest != null) {
            compositeCancelableTask.addCancelable(httpRequest);
            return compositeCancelableTask;
        }
        return null;
    }

    @Nullable
    public ICancelable addBiometryFactor(final @NonNull Context context, String password, final byte[] encryptedBiometryKey, final @NonNull IAddBiometryFactorListener listener) {
        PowerAuthAuthentication authAuthentication = new PowerAuthAuthentication();
        authAuthentication.usePossession = true;
        authAuthentication.usePassword = password;
        return this.fetchEncryptedVaultUnlockKey(context, authAuthentication, "ADD_BIOMETRY", new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                if (encryptedEncryptionKey != null) {
                    SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), encryptedBiometryKey, null);
                    int result = PowerAuthSDK.this.mSession.addBiometryFactor(encryptedEncryptionKey, keys);
                    if (result == 0) {
                        PowerAuthSDK.this.saveSerializedState();
                        listener.onAddBiometryFactorSucceed();
                    } else {
                        listener.onAddBiometryFactorFailed(new PowerAuthErrorException(3));
                    }
                } else {
                    listener.onAddBiometryFactorFailed(new PowerAuthErrorException(3));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onAddBiometryFactorFailed(t);
            }
        });
    }

    @RequiresApi(api=23)
    public boolean removeBiometryFactor(@NonNull Context context) {
        this.checkForValidSetup();
        int result = this.mSession.removeBiometryFactor();
        if (result == 0) {
            this.saveSerializedState();
            this.mBiometryKeychain.removeDataForKey(context, this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
            BiometricAuthentication.getBiometricKeystore().removeDefaultKey();
        }
        return result == 0;
    }

    @Nullable
    public ICancelable fetchEncryptionKey(final @NonNull Context context, @NonNull PowerAuthAuthentication authentication, final long index, final @NonNull IFetchEncryptionKeyListener listener) {
        return this.fetchEncryptedVaultUnlockKey(context, authentication, "FETCH_ENCRYPTION_KEY", new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), null, null);
                byte[] key = PowerAuthSDK.this.mSession.deriveCryptographicKeyFromVaultKey(encryptedEncryptionKey, keys, index);
                if (key != null) {
                    listener.onFetchEncryptionKeySucceed(key);
                } else {
                    listener.onFetchEncryptionKeyFailed(new PowerAuthErrorException(4));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onFetchEncryptionKeyFailed(t);
            }
        });
    }

    @Nullable
    public ICancelable validatePasswordCorrect(@NonNull Context context, String password, final @NonNull IValidatePasswordListener listener) {
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.usePossession = true;
        authentication.usePassword = password;
        ValidateSignatureRequest request = new ValidateSignatureRequest();
        request.setReason("VALIDATE_PASSWORD");
        return this.mClient.post(request, new ValidateSignatureEndpoint(), this.getCryptoHelper(context), authentication, new INetworkResponseListener<Void>(){

            @Override
            public void onNetworkResponse(Void aVoid) {
                listener.onPasswordValid();
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onPasswordValidationFailed(t);
            }

            @Override
            public void onCancel() {
            }
        });
    }

    @RequiresApi(api=23)
    @NonNull
    public ICancelable authenticateUsingBiometry(Context context, FragmentManager fragmentManager, String title, String description, IBiometricAuthenticationCallback callback) {
        return this.authenticateUsingBiometry(context, fragmentManager, title, description, false, callback);
    }

    @RequiresApi(api=23)
    @NonNull
    private ICancelable authenticateUsingBiometry(final @NonNull Context context, @NonNull FragmentManager fragmentManager, @NonNull String title, @NonNull String description, final boolean forceGenerateNewKey, final IBiometricAuthenticationCallback callback) {
        final byte[] biometryKey = forceGenerateNewKey ? this.mSession.generateSignatureUnlockKey() : this.mBiometryKeychain.dataForKey(context, this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
        BiometricAuthenticationRequest request = new BiometricAuthenticationRequest.Builder(context).setTitle(title).setDescription(description).setKeyToProtect(biometryKey).setForceGenerateNewKey(forceGenerateNewKey, this.mKeychainConfiguration.isLinkBiometricItemsToCurrentSet()).build();
        return BiometricAuthentication.authenticate(context, fragmentManager, request, new IBiometricAuthenticationCallback(){

            @Override
            public void onBiometricDialogCancelled(boolean userCancel) {
                callback.onBiometricDialogCancelled(userCancel);
            }

            @Override
            public void onBiometricDialogSuccess(@NonNull byte[] biometricKeyEncrypted) {
                if (forceGenerateNewKey) {
                    PowerAuthSDK.this.mBiometryKeychain.putDataForKey(context, biometryKey, PowerAuthSDK.this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
                }
                byte[] normalizedEncryptionKey = PowerAuthSDK.this.mSession.normalizeSignatureUnlockKeyFromData(biometricKeyEncrypted);
                callback.onBiometricDialogSuccess(normalizedEncryptionKey);
            }

            @Override
            public void onBiometricDialogFailed(@NonNull PowerAuthErrorException error) {
                int errorCode = error.getPowerAuthErrorCode();
                if (!forceGenerateNewKey && errorCode == 20) {
                    callback.onBiometricDialogSuccess(PowerAuthSDK.this.mSession.generateSignatureUnlockKey());
                } else {
                    callback.onBiometricDialogFailed(error);
                }
            }
        });
    }

    @Nullable
    public EciesEncryptor getEciesEncryptorForApplicationScope() throws PowerAuthErrorException {
        IPrivateCryptoHelper helper = this.getCryptoHelper(null);
        return helper.getEciesEncryptor(EciesEncryptorId.GENERIC_APPLICATION_SCOPE);
    }

    @Nullable
    public EciesEncryptor getEciesEncryptorForActivationScope(@NonNull Context context) throws PowerAuthErrorException {
        IPrivateCryptoHelper helper = this.getCryptoHelper(context);
        return helper.getEciesEncryptor(EciesEncryptorId.GENERIC_ACTIVATION_SCOPE);
    }

    @NonNull
    public Executor getSerialExecutor() throws PowerAuthErrorException {
        if (!this.hasValidActivation()) {
            throw new PowerAuthErrorException(3, "Missing activation");
        }
        return this.mClient.getExecutorProvider().getSerialExecutor();
    }

    void dispatchCallback(Runnable runnable) {
        this.mCallbackDispatcher.dispatchCallback(runnable);
    }

    public boolean hasActivationRecoveryData() {
        this.checkForValidSetup();
        return this.mSession.hasActivationRecoveryData();
    }

    @Nullable
    public ICancelable getActivationRecoveryData(final @NonNull Context context, final @NonNull PowerAuthAuthentication authentication, final @NonNull IGetRecoveryDataListener listener) {
        if (!this.mSession.hasActivationRecoveryData()) {
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onGetRecoveryDataFailed(new PowerAuthErrorException(3, "Session has no recovery data available."));
                }
            });
            return null;
        }
        return this.fetchEncryptedVaultUnlockKey(context, authentication, "RECOVERY_CODE", new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                SignatureUnlockKeys keys = PowerAuthSDK.this.signatureKeysForAuthentication(context, authentication);
                RecoveryData recoveryData = PowerAuthSDK.this.mSession.getActivationRecoveryData(encryptedEncryptionKey, keys);
                if (recoveryData != null) {
                    listener.onGetRecoveryDataSucceeded(recoveryData);
                } else {
                    listener.onGetRecoveryDataFailed(new PowerAuthErrorException(14, "Cannot decrypt recovery data."));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable throwable) {
                listener.onGetRecoveryDataFailed(throwable);
            }
        });
    }

    @Nullable
    public ICancelable confirmRecoveryCode(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, @NonNull String recoveryCode, final @NonNull IConfirmRecoveryCodeListener listener) {
        Otp otp = OtpUtil.parseFromRecoveryCode(recoveryCode);
        if (otp == null) {
            this.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onRecoveryCodeConfirmFailed(new PowerAuthErrorException(12));
                }
            });
            return null;
        }
        ConfirmRecoveryRequestPayload request = new ConfirmRecoveryRequestPayload();
        request.setRecoveryCode(otp.activationCode);
        return this.mClient.post(request, new ConfirmRecoveryCodeEndpoint(), this.getCryptoHelper(context), authentication, new INetworkResponseListener<ConfirmRecoveryResponsePayload>(){

            @Override
            public void onNetworkResponse(ConfirmRecoveryResponsePayload confirmRecoveryResponsePayload) {
                listener.onRecoveryCodeConfirmed(confirmRecoveryResponsePayload.getAlreadyConfirmed());
            }

            @Override
            public void onNetworkError(Throwable throwable) {
                listener.onRecoveryCodeConfirmFailed(throwable);
            }

            @Override
            public void onCancel() {
            }
        });
    }

    private static interface IFetchEncryptedVaultUnlockKeyListener {
        @MainThread
        public void onFetchEncryptedVaultUnlockKeySucceed(String var1);

        @MainThread
        public void onFetchEncryptedVaultUnlockKeyFailed(Throwable var1);
    }

    public static class Builder {
        private PowerAuthConfiguration mConfiguration;
        private PowerAuthClientConfiguration mClientConfiguration;
        private PowerAuthKeychainConfiguration mKeychainConfiguration;
        private ISavePowerAuthStateListener mStateListener;

        public Builder(@NonNull PowerAuthConfiguration mConfiguration) {
            this.mConfiguration = mConfiguration;
        }

        public Builder clientConfiguration(PowerAuthClientConfiguration configuration) {
            this.mClientConfiguration = configuration;
            return this;
        }

        public Builder keychainConfiguration(PowerAuthKeychainConfiguration configuration) {
            this.mKeychainConfiguration = configuration;
            return this;
        }

        public Builder stateListener(ISavePowerAuthStateListener stateListener) {
            this.mStateListener = stateListener;
            return this;
        }

        public PowerAuthSDK build(@NonNull Context context) {
            PowerAuthSDK instance = new PowerAuthSDK();
            instance.mConfiguration = this.mConfiguration;
            if (this.mKeychainConfiguration != null) {
                instance.mKeychainConfiguration = this.mKeychainConfiguration;
            } else {
                instance.mKeychainConfiguration = new PowerAuthKeychainConfiguration();
            }
            if (this.mClientConfiguration != null) {
                instance.mClientConfiguration = this.mClientConfiguration;
            } else {
                instance.mClientConfiguration = new PowerAuthClientConfiguration.Builder().build();
            }
            instance.mClient = new HttpClient(instance.mClientConfiguration, instance.mConfiguration.getBaseEndpointUrl(), new DefaultExecutorProvider());
            instance.mStatusKeychain = new PA2Keychain(instance.mKeychainConfiguration.getKeychainStatusId());
            instance.mBiometryKeychain = new PA2Keychain(instance.mKeychainConfiguration.getKeychainBiometryId());
            if (this.mStateListener != null) {
                instance.mStateListener = this.mStateListener;
            } else {
                instance.mStateListener = new DefaultSavePowerAuthStateListener(context, instance.mStatusKeychain);
            }
            SessionSetup sessionSetup = new SessionSetup(instance.mConfiguration.getAppKey(), instance.mConfiguration.getAppSecret(), instance.mConfiguration.getMasterServerPublicKey(), 0, instance.mConfiguration.getExternalEncryptionKey());
            instance.mSession = new Session(sessionSetup);
            boolean b = instance.restoreState(instance.mStateListener.serializedState(instance.mConfiguration.getInstanceId()));
            instance.mCallbackDispatcher = new DefaultCallbackDispatcher();
            return instance;
        }
    }
}

