/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.core;

import android.util.Base64;

public class EciesCryptogram {
    public final byte[] body;
    public final byte[] mac;
    public final byte[] key;

    public String getBodyBase64() {
        if (this.body != null) {
            return Base64.encodeToString((byte[])this.body, (int)2);
        }
        return null;
    }

    public String getMacBase64() {
        if (this.mac != null) {
            return Base64.encodeToString((byte[])this.mac, (int)2);
        }
        return null;
    }

    public String getKeyBase64() {
        if (this.key != null) {
            return Base64.encodeToString((byte[])this.key, (int)2);
        }
        return null;
    }

    public EciesCryptogram() {
        this.body = null;
        this.mac = null;
        this.key = null;
    }

    public EciesCryptogram(byte[] body, byte[] mac, byte[] key) {
        this.body = body;
        this.mac = mac;
        this.key = key;
    }

    public EciesCryptogram(String bodyBase64, String macBase64, String keyBase64) {
        this.body = bodyBase64 != null ? Base64.decode((String)bodyBase64, (int)2) : null;
        this.mac = macBase64 != null ? Base64.decode((String)macBase64, (int)2) : null;
        this.key = keyBase64 != null ? Base64.decode((String)keyBase64, (int)2) : null;
    }

    public EciesCryptogram(String bodyBase64, String macBase64) {
        this.body = bodyBase64 != null ? Base64.decode((String)bodyBase64, (int)2) : null;
        this.mac = macBase64 != null ? Base64.decode((String)macBase64, (int)2) : null;
        this.key = null;
    }
}

