/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.app.FragmentManager;
import android.util.Pair;
import io.getlime.security.powerauth.biometry.BiometricAuthenticationRequest;
import io.getlime.security.powerauth.biometry.BiometricDialogResources;
import io.getlime.security.powerauth.biometry.IBiometricAuthenticationCallback;
import io.getlime.security.powerauth.biometry.IBiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.BiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.BiometricErrorDialogFragment;
import io.getlime.security.powerauth.biometry.impl.BiometricHelper;
import io.getlime.security.powerauth.biometry.impl.BiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.BiometricResultDispatcher;
import io.getlime.security.powerauth.biometry.impl.IBiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.PrivateRequestData;
import io.getlime.security.powerauth.biometry.impl.dummy.DummyBiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.dummy.DummyBiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.legacy.FingerprintAuthenticator;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.sdk.impl.CancelableTask;
import io.getlime.security.powerauth.sdk.impl.DefaultCallbackDispatcher;
import io.getlime.security.powerauth.system.PA2Log;
import javax.crypto.SecretKey;

public class BiometricAuthentication {
    @NonNull
    public static IBiometricKeystore getBiometricKeystore() {
        if (Build.VERSION.SDK_INT >= 23) {
            return new BiometricKeystore();
        }
        return new DummyBiometricKeystore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBiometricAuthenticationAvailable(@NonNull Context context) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BiometricAuthentication.getContext().getAuthenticator(context).isAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int canAuthenticate(@NonNull Context context) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BiometricAuthentication.getContext().getAuthenticator(context).canAuthenticate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    @NonNull
    public static ICancelable authenticate(@NonNull Context context, @NonNull FragmentManager fragmentManager, @NonNull BiometricAuthenticationRequest request, @NonNull IBiometricAuthenticationCallback callback) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            final SharedContext ctx = BiometricAuthentication.getContext();
            if (!ctx.startBiometricAuthentication()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return BiometricAuthentication.reportSimultaneousRequest(callback);
            }
            final IBiometricAuthenticator device = ctx.getAuthenticator(context);
            BiometricResultDispatcher dispatcher = new BiometricResultDispatcher(callback, new DefaultCallbackDispatcher(), new BiometricResultDispatcher.IResultCompletion(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompletion() {
                    Class<SharedContext> clazz = SharedContext.class;
                    synchronized (SharedContext.class) {
                        ctx.finishPendingBiometricAuthentication();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }

                @Override
                public void onBiometricKeyUnavailable() {
                    device.getBiometricKeystore().removeDefaultKey();
                }
            });
            PrivateRequestData requestData = new PrivateRequestData(request, dispatcher, ctx.getBiometricDialogResources());
            int status = device.canAuthenticate();
            PowerAuthErrorException exception = null;
            if (status == 0) {
                try {
                    requestData.setSecretKey(BiometricAuthentication.prepareSecretKey(device.getBiometricKeystore(), request));
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return device.authenticate(context, fragmentManager, requestData);
                }
                catch (PowerAuthErrorException e) {
                    PA2Log.e("BiometricAuthentication.authenticate() failed with exception: " + e.getMessage(), new Object[0]);
                    exception = e;
                    status = 3;
                }
            }
            device.getBiometricKeystore().removeDefaultKey();
            if (exception == null) {
                exception = BiometricHelper.getExceptionForBiometricStatus(status);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return BiometricAuthentication.showErrorDialog(status, exception, context, fragmentManager, requestData);
        }
    }

    @NonNull
    private static SecretKey prepareSecretKey(IBiometricKeystore keystore, @NonNull BiometricAuthenticationRequest request) throws PowerAuthErrorException {
        SecretKey key;
        if (request.isForceGenerateNewKey()) {
            key = keystore.generateDefaultKey(request.isInvalidateByBiometricEnrollment());
            if (key == null) {
                throw new PowerAuthErrorException(18, "Keystore failed to generate a new biometric key.");
            }
        } else {
            key = keystore.getDefaultKey();
            if (key == null) {
                throw new PowerAuthErrorException(19, "Cannot get biometric key from the keystore.");
            }
        }
        return key;
    }

    @NonNull
    private static ICancelable showErrorDialog(int status, final @NonNull PowerAuthErrorException exception, @NonNull Context context, @NonNull FragmentManager fragmentManager, final @NonNull PrivateRequestData requestData) {
        CancelableTask cancelableTask = requestData.getDispatcher().getCancelableTask();
        BiometricDialogResources resources = requestData.getResources();
        Pair<Integer, Integer> titleDescription = BiometricHelper.getErrorDialogStringsForBiometricStatus(status, resources);
        final BiometricErrorDialogFragment dialogFragment = new BiometricErrorDialogFragment.Builder(context).setTitle((Integer)titleDescription.first).setMessage((Integer)titleDescription.second).setCloseButton(resources.strings.ok, resources.colors.closeButtonText).setIcon(resources.drawables.errorIcon).setOnCloseListener(new BiometricErrorDialogFragment.OnCloseListener(){

            @Override
            public void onClose() {
                requestData.getDispatcher().dispatchError(exception);
            }
        }).build();
        requestData.getDispatcher().setOnCancelListener(new CancelableTask.OnCancelListener(){

            @Override
            public void onCancel() {
                dialogFragment.dismiss();
            }
        });
        dialogFragment.show(fragmentManager, "BIOMETRIC_ERROR_DEFAULT_TAG");
        return cancelableTask;
    }

    private static ICancelable reportSimultaneousRequest(final @NonNull IBiometricAuthenticationCallback callback) {
        PA2Log.e("Cannot execute more than one biometric authentication request at the same time. This request is going to be canceled.", new Object[0]);
        new DefaultCallbackDispatcher().dispatchCallback(new Runnable(){

            @Override
            public void run() {
                callback.onBiometricDialogCancelled(false);
            }
        });
        return new ICancelable(){

            @Override
            public void cancel() {
            }

            @Override
            public boolean isCancelled() {
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBiometricDialogResources(@NonNull BiometricDialogResources resources) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            BiometricAuthentication.getContext().setBiometricDialogResources(resources);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public BiometricDialogResources getBiometricDialogResources() {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BiometricAuthentication.getContext().getBiometricDialogResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBiometricPromptAuthenticationDisabled(boolean disabled) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            BiometricAuthentication.getContext().setBiometricPromptAuthenticationDisabled(disabled);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBiometricPromptAuthenticationDisabled() {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return BiometricAuthentication.getContext().isBiometricPromptAuthenticationDisabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBiometryType(@NonNull Context context) {
        Class<SharedContext> clazz = SharedContext.class;
        synchronized (SharedContext.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BiometricAuthentication.getContext().getBiometryType(context);
        }
    }

    @NonNull
    private static SharedContext getContext() {
        return SharedContext.INSTANCE;
    }

    private static class SharedContext {
        private static final SharedContext INSTANCE = new SharedContext();
        @NonNull
        private BiometricDialogResources biometricDialogResources = new BiometricDialogResources.Builder().build();
        @Nullable
        private IBiometricAuthenticator authenticator = null;
        private boolean isBiometricPromptAuthenticationDisabled = false;
        private boolean isPendingBiometricAuthentication = false;
        private boolean isBiometryTypeEvaluated = false;
        private int biometryType = 0;

        private SharedContext() {
        }

        void setBiometricDialogResources(@NonNull BiometricDialogResources resources) {
            this.biometricDialogResources = resources;
        }

        @NonNull
        BiometricDialogResources getBiometricDialogResources() {
            return this.biometricDialogResources;
        }

        boolean isBiometricPromptAuthenticationDisabled() {
            return this.isBiometricPromptAuthenticationDisabled;
        }

        void setBiometricPromptAuthenticationDisabled(boolean disabled) {
            this.isBiometricPromptAuthenticationDisabled = disabled;
        }

        @NonNull
        IBiometricAuthenticator getAuthenticator(@NonNull Context context) {
            IBiometricAuthenticator newAuthenticator;
            if (this.authenticator != null) {
                return this.authenticator;
            }
            if (Build.VERSION.SDK_INT >= 28 && !this.isBiometricPromptAuthenticationDisabled && (newAuthenticator = BiometricAuthenticator.createAuthenticator(context, BiometricAuthentication.getBiometricKeystore())) != null) {
                return newAuthenticator;
            }
            if (Build.VERSION.SDK_INT >= 23 && (newAuthenticator = FingerprintAuthenticator.createAuthenticator(context, BiometricAuthentication.getBiometricKeystore())) != null) {
                return newAuthenticator;
            }
            this.authenticator = new DummyBiometricAuthenticator();
            return this.authenticator;
        }

        boolean startBiometricAuthentication() {
            if (this.isPendingBiometricAuthentication) {
                return false;
            }
            this.isPendingBiometricAuthentication = true;
            return true;
        }

        void finishPendingBiometricAuthentication() {
            this.isPendingBiometricAuthentication = false;
        }

        int getBiometryType(@NonNull Context context) {
            if (!this.isBiometryTypeEvaluated) {
                this.biometryType = this.getAuthenticator(context).getBiometryType(context);
                this.isBiometryTypeEvaluated = true;
            }
            return this.biometryType;
        }
    }
}

