/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl.legacy;

import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.CancellationSignal;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentManager;
import android.util.Pair;
import io.getlime.security.powerauth.biometry.BiometricAuthenticationRequest;
import io.getlime.security.powerauth.biometry.BiometricDialogResources;
import io.getlime.security.powerauth.biometry.IBiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.BiometricErrorDialogFragment;
import io.getlime.security.powerauth.biometry.impl.BiometricHelper;
import io.getlime.security.powerauth.biometry.impl.BiometricResultDispatcher;
import io.getlime.security.powerauth.biometry.impl.IBiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.PrivateRequestData;
import io.getlime.security.powerauth.biometry.impl.legacy.FingerprintAuthenticationDialogFragment;
import io.getlime.security.powerauth.biometry.impl.legacy.FingerprintAuthenticationHandler;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.sdk.impl.CancelableTask;
import io.getlime.security.powerauth.system.PA2Log;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

@RequiresApi(api=23)
public class FingerprintAuthenticator
implements IBiometricAuthenticator {
    @NonNull
    private final Context context;
    @NonNull
    private final FingerprintManager fingerprintManager;
    @NonNull
    private final IBiometricKeystore keystore;
    private byte[] alreadyProtectedKey;

    @Nullable
    public static IBiometricAuthenticator createAuthenticator(@NonNull Context context, @NonNull IBiometricKeystore keystore) {
        FingerprintManager fingerprintManager;
        if (!keystore.isKeystoreReady()) {
            return null;
        }
        if (Build.VERSION.SDK_INT == 23) {
            fingerprintManager = (FingerprintManager)context.getSystemService(FingerprintManager.class);
        } else if (Build.VERSION.SDK_INT > 23 && context.getPackageManager().hasSystemFeature("android.hardware.fingerprint")) {
            fingerprintManager = (FingerprintManager)context.getSystemService(FingerprintManager.class);
        } else {
            return null;
        }
        if (fingerprintManager == null) {
            return null;
        }
        if (!fingerprintManager.isHardwareDetected()) {
            return null;
        }
        return new FingerprintAuthenticator(context, keystore, fingerprintManager);
    }

    private FingerprintAuthenticator(@NonNull Context context, @NonNull IBiometricKeystore keystore, @NonNull FingerprintManager manager) {
        this.context = context;
        this.fingerprintManager = manager;
        this.keystore = keystore;
    }

    @Override
    public boolean isAvailable() {
        return this.keystore.isKeystoreReady();
    }

    @Override
    public int canAuthenticate() {
        if (!this.isAvailable()) {
            return 3;
        }
        if (!this.fingerprintManager.hasEnrolledFingerprints()) {
            return 2;
        }
        return 0;
    }

    @Override
    @NonNull
    public IBiometricKeystore getBiometricKeystore() {
        return this.keystore;
    }

    @Override
    @Nullable
    public ICancelable authenticate(@NonNull Context context, final @NonNull FragmentManager fragmentManager, final @NonNull PrivateRequestData requestData) throws PowerAuthErrorException {
        final BiometricAuthenticationRequest request = requestData.getRequest();
        final BiometricResultDispatcher dispatcher = requestData.getDispatcher();
        FingerprintManager.CryptoObject cryptoObject = this.getCryptoObject(requestData.getSecretKey());
        if (cryptoObject == null) {
            throw new PowerAuthErrorException(18, "Cannot create CryptoObject for biometric authentication.");
        }
        CancellationSignal cancellationSignal = dispatcher.getCancelableTask().getCancellationSignal();
        final FingerprintAuthenticationDialogFragment dialogFragment = new FingerprintAuthenticationDialogFragment.Builder(context).setTitle(request.getTitle()).setDescription(request.getDescription()).setDialogResources(requestData.getResources()).build();
        FingerprintAuthenticationHandler handler = new FingerprintAuthenticationHandler(this.fingerprintManager, cryptoObject, cancellationSignal, dialogFragment, new FingerprintAuthenticationHandler.ResultCallback(){

            @Override
            public void onAuthenticationSuccess(@NonNull FingerprintManager.AuthenticationResult result) {
                Cipher cipher;
                Cipher cipher2 = cipher = result.getCryptoObject() != null ? result.getCryptoObject().getCipher() : null;
                if (cipher != null) {
                    byte[] protectedKey = FingerprintAuthenticator.this.protectKeyWithCipher(request.getKeyToProtect(), cipher);
                    if (protectedKey != null) {
                        dispatcher.dispatchSuccess(protectedKey);
                        return;
                    }
                    PA2Log.e("Failed to encrypt biometric key.", new Object[0]);
                } else {
                    PA2Log.e("Failed to get Cipher from CryptoObject.", new Object[0]);
                }
                dispatcher.reportBiometricKeyUnavailable();
                dispatcher.dispatchRunnable(new Runnable(){

                    @Override
                    public void run() {
                        PowerAuthErrorException exception = new PowerAuthErrorException(19, "Failed to encrypt biometric key.");
                        FingerprintAuthenticator.this.showErrorDialogAfterSuccess(fragmentManager, requestData, exception);
                    }
                });
            }

            @Override
            public void onAuthenticationFailure(@NonNull PowerAuthErrorException exception) {
                dispatcher.dispatchError(exception);
            }

            @Override
            public void onAuthenticationCancel(boolean userCancel) {
                if (userCancel) {
                    dispatcher.dispatchUserCancel();
                }
            }
        });
        dispatcher.setOnCancelListener(new CancelableTask.OnCancelListener(){

            @Override
            public void onCancel() {
                dialogFragment.dismiss();
            }
        });
        dialogFragment.setFingerprintAuthenticationHandler(handler);
        dialogFragment.show(fragmentManager);
        return dispatcher.getCancelableTask();
    }

    @Nullable
    private FingerprintManager.CryptoObject getCryptoObject(@Nullable SecretKey secretKey) {
        if (secretKey == null) {
            return null;
        }
        Cipher cipher = BiometricHelper.createAesCipher(secretKey);
        if (cipher == null) {
            return null;
        }
        return new FingerprintManager.CryptoObject(cipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private byte[] protectKeyWithCipher(@NonNull byte[] keyToProtect, @NonNull Cipher cipher) {
        FingerprintAuthenticator fingerprintAuthenticator = this;
        synchronized (fingerprintAuthenticator) {
            if (this.alreadyProtectedKey == null) {
                this.alreadyProtectedKey = BiometricHelper.protectKeyWithCipher(keyToProtect, cipher);
                if (this.alreadyProtectedKey == null) {
                    this.alreadyProtectedKey = new byte[0];
                }
            }
            return this.alreadyProtectedKey.length > 0 ? this.alreadyProtectedKey : null;
        }
    }

    private void showErrorDialogAfterSuccess(@NonNull FragmentManager fragmentManager, @NonNull PrivateRequestData requestData, final @NonNull PowerAuthErrorException exception) {
        final BiometricResultDispatcher dispatcher = requestData.getDispatcher();
        if (dispatcher.getCancelableTask().isCancelled()) {
            return;
        }
        BiometricDialogResources resources = requestData.getResources();
        Pair<Integer, Integer> titleDescription = BiometricHelper.getErrorDialogStringsForBiometricStatus(3, resources);
        final BiometricErrorDialogFragment dialogFragment = new BiometricErrorDialogFragment.Builder(this.context).setTitle((Integer)titleDescription.first).setMessage((Integer)titleDescription.second).setCloseButton(resources.strings.ok, resources.colors.closeButtonText).setIcon(resources.drawables.errorIcon).setOnCloseListener(new BiometricErrorDialogFragment.OnCloseListener(){

            @Override
            public void onClose() {
                dispatcher.dispatchError(exception);
            }
        }).build();
        dispatcher.setOnCancelListener(new CancelableTask.OnCancelListener(){

            @Override
            public void onCancel() {
                dialogFragment.dismiss();
            }
        });
        dialogFragment.show(fragmentManager, "BIOMETRIC_ERROR_DEFAULT_TAG");
    }
}

