/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.content.Context;
import android.content.DialogInterface;
import android.hardware.biometrics.BiometricPrompt;
import android.hardware.fingerprint.FingerprintManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentManager;
import io.getlime.security.powerauth.biometry.BiometricAuthenticationRequest;
import io.getlime.security.powerauth.biometry.BiometricDialogResources;
import io.getlime.security.powerauth.biometry.IBiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.BiometricErrorDialogFragment;
import io.getlime.security.powerauth.biometry.impl.BiometricHelper;
import io.getlime.security.powerauth.biometry.impl.BiometricResultDispatcher;
import io.getlime.security.powerauth.biometry.impl.IBiometricAuthenticator;
import io.getlime.security.powerauth.biometry.impl.PrivateRequestData;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.sdk.impl.CancelableTask;
import io.getlime.security.powerauth.sdk.impl.CompositeCancelableTask;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

@RequiresApi(api=28)
public class BiometricAuthenticator
implements IBiometricAuthenticator {
    @NonNull
    private final Context context;
    @NonNull
    private final IBiometricKeystore keystore;
    @NonNull
    private final FingerprintManager legacyFingerprintManager;
    private byte[] alreadyProtectedKey;
    private boolean authenticationFailedBefore;
    private boolean biometricPromptIsProbablyVisible;
    private static final long PROMPT_API_MIN_RESPONSE_TIME = 2000L;
    private static final long PROMPT_API_RESPONSE_TOLERANCE = 200L;

    @Nullable
    public static IBiometricAuthenticator createAuthenticator(Context context, IBiometricKeystore keystore) {
        if (!keystore.isKeystoreReady()) {
            return null;
        }
        if (!context.getPackageManager().hasSystemFeature("android.hardware.fingerprint")) {
            return null;
        }
        FingerprintManager fingerprintManager = (FingerprintManager)context.getSystemService("fingerprint");
        if (fingerprintManager == null) {
            return null;
        }
        return new BiometricAuthenticator(context, keystore, fingerprintManager);
    }

    private BiometricAuthenticator(@NonNull Context context, @NonNull IBiometricKeystore keystore, @NonNull FingerprintManager legacyFingerprintManager) {
        this.context = context;
        this.keystore = keystore;
        this.legacyFingerprintManager = legacyFingerprintManager;
    }

    @Override
    public boolean isAvailable() {
        return this.keystore.isKeystoreReady();
    }

    @Override
    public int canAuthenticate() {
        if (!this.isAvailable()) {
            return 3;
        }
        if (!this.legacyFingerprintManager.hasEnrolledFingerprints()) {
            return 2;
        }
        return 0;
    }

    @Override
    @NonNull
    public IBiometricKeystore getBiometricKeystore() {
        return this.keystore;
    }

    @Override
    @NonNull
    public ICancelable authenticate(@NonNull Context context, final @NonNull FragmentManager fragmentManager, final @NonNull PrivateRequestData requestData) throws PowerAuthErrorException {
        final BiometricAuthenticationRequest request = requestData.getRequest();
        final BiometricResultDispatcher dispatcher = requestData.getDispatcher();
        CancelableTask cancelableTask = dispatcher.getCancelableTask();
        final CompositeCancelableTask compositeCancelableTask = new CompositeCancelableTask(true, cancelableTask);
        BiometricPrompt.CryptoObject cryptoObject = this.getCryptoObject(requestData.getSecretKey());
        if (cryptoObject == null) {
            throw new PowerAuthErrorException(18, "Cannot create CryptoObject for biometric authentication.");
        }
        BiometricDialogResources resources = requestData.getResources();
        BiometricPrompt.Builder builder = new BiometricPrompt.Builder(context).setTitle(request.getTitle()).setDescription(request.getDescription());
        CharSequence subtitle = request.getSubtitle();
        if (subtitle != null) {
            builder.setSubtitle(subtitle);
        }
        builder.setNegativeButton(context.getText(resources.strings.close), context.getMainExecutor(), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dispatcher.dispatchUserCancel();
            }
        });
        BiometricPrompt prompt = builder.build();
        prompt.authenticate(cryptoObject, cancelableTask.getCancellationSignal(), context.getMainExecutor(), new BiometricPrompt.AuthenticationCallback(){

            public void onAuthenticationError(int code, CharSequence errString) {
                boolean isLockout;
                super.onAuthenticationError(code, errString);
                if (errString == null) {
                    errString = BiometricAuthenticator.this.getFallbackErrorMessage(code, requestData.getResources());
                }
                boolean isCancel = code == 10 || code == 5;
                boolean bl = isLockout = code == 7 || code == 9;
                if (isCancel) {
                    dispatcher.dispatchUserCancel();
                } else {
                    PowerAuthErrorException exception = isLockout && BiometricAuthenticator.this.authenticationFailedBefore ? new PowerAuthErrorException(20, "Biometric image was not recognized.") : new PowerAuthErrorException(19, errString.toString());
                    if (BiometricAuthenticator.this.shouldDisplayErrorDialog(requestData)) {
                        BiometricAuthenticator.this.showBiometricErrorDialog(errString, exception, fragmentManager, requestData, compositeCancelableTask);
                    } else {
                        dispatcher.dispatchError(exception);
                    }
                }
            }

            public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
                super.onAuthenticationHelp(helpCode, helpString);
                BiometricAuthenticator.this.biometricPromptIsProbablyVisible = true;
            }

            public void onAuthenticationSucceeded(BiometricPrompt.AuthenticationResult result) {
                super.onAuthenticationSucceeded(result);
                BiometricAuthenticator.this.biometricPromptIsProbablyVisible = true;
                Cipher cipher = result != null && result.getCryptoObject() != null ? result.getCryptoObject().getCipher() : null;
                if (cipher != null) {
                    byte[] protectedKey = BiometricAuthenticator.this.protectKeyWithCipher(request.getKeyToProtect(), cipher);
                    if (protectedKey != null) {
                        dispatcher.dispatchSuccess(protectedKey);
                    } else {
                        dispatcher.dispatchError(14, "Failed to encrypt biometric key.");
                    }
                } else {
                    dispatcher.dispatchError(14, "The device has broken biometric implementation.");
                }
            }

            public void onAuthenticationFailed() {
                super.onAuthenticationFailed();
                BiometricAuthenticator.this.biometricPromptIsProbablyVisible = true;
                BiometricAuthenticator.this.authenticationFailedBefore = true;
            }
        });
        return compositeCancelableTask;
    }

    @Nullable
    private BiometricPrompt.CryptoObject getCryptoObject(@Nullable SecretKey secretKey) {
        if (secretKey == null) {
            return null;
        }
        Cipher cipher = BiometricHelper.createAesCipher(secretKey);
        return cipher != null ? new BiometricPrompt.CryptoObject(cipher) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private byte[] protectKeyWithCipher(@NonNull byte[] keyToProtect, @Nullable Cipher cipher) {
        if (cipher == null) {
            return null;
        }
        BiometricAuthenticator biometricAuthenticator = this;
        synchronized (biometricAuthenticator) {
            if (this.alreadyProtectedKey == null) {
                this.alreadyProtectedKey = BiometricHelper.protectKeyWithCipher(keyToProtect, cipher);
                if (this.alreadyProtectedKey == null) {
                    this.alreadyProtectedKey = new byte[0];
                }
            }
            return this.alreadyProtectedKey.length > 0 ? this.alreadyProtectedKey : null;
        }
    }

    private boolean shouldDisplayErrorDialog(@NonNull PrivateRequestData requestData) {
        if (this.biometricPromptIsProbablyVisible) {
            return false;
        }
        this.biometricPromptIsProbablyVisible = true;
        long elapsedTime = requestData.getElapsedTime();
        if (elapsedTime < 200L) {
            return true;
        }
        return elapsedTime >= 2000L && elapsedTime < 2200L;
    }

    private void showBiometricErrorDialog(@NonNull CharSequence message, final @NonNull PowerAuthErrorException exception, @NonNull FragmentManager fragmentManager, @NonNull PrivateRequestData requestData, @NonNull CompositeCancelableTask cancelable) {
        final BiometricResultDispatcher dispatcher = requestData.getDispatcher();
        BiometricDialogResources resources = requestData.getResources();
        final BiometricErrorDialogFragment dialogFragment = new BiometricErrorDialogFragment.Builder(this.context).setTitle(resources.strings.errorFingerprintDisabledTitle).setMessage(message).setCloseButton(resources.strings.ok, resources.colors.closeButtonText).setIcon(resources.drawables.errorIcon).setOnCloseListener(new BiometricErrorDialogFragment.OnCloseListener(){

            @Override
            public void onClose() {
                dispatcher.dispatchError(exception);
            }
        }).build();
        CancelableTask dialogCancelable = new CancelableTask(new CancelableTask.OnCancelListener(){

            @Override
            public void onCancel() {
                dialogFragment.dismiss();
            }
        });
        cancelable.addCancelable(dialogCancelable);
        dialogFragment.show(fragmentManager, "BIOMETRIC_ERROR_DEFAULT_TAG");
    }

    @NonNull
    private CharSequence getFallbackErrorMessage(int code, @NonNull BiometricDialogResources resources) {
        if (code == 7 || code == 9) {
            return this.context.getString(resources.strings.errorCodeLockout);
        }
        return this.context.getString(resources.strings.errorCodeGeneric);
    }
}

